package pl.poznan.put.torsion;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.interfaces.DisplayableExportable;
import pl.poznan.put.pdb.analysis.MoleculeType;
import pl.poznan.put.types.Quadruple;

/**
 * Immutable implementation of {@link AtomBasedTorsionAngleType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAtomBasedTorsionAngleType.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableAtomBasedTorsionAngleType.of()}.
 */
@Generated(from = "AtomBasedTorsionAngleType", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableAtomBasedTorsionAngleType
    implements AtomBasedTorsionAngleType {
  private final MoleculeType moleculeType;
  private final String shortDisplayName;
  private final String exportName;
  private final Quadruple<AtomName> atoms;
  private final Quadruple<Integer> residueRule;
  private final boolean isPseudoTorsion;

  private ImmutableAtomBasedTorsionAngleType(
      MoleculeType moleculeType,
      String shortDisplayName,
      String exportName,
      Quadruple<AtomName> atoms,
      Quadruple<Integer> residueRule) {
    this.moleculeType = Objects.requireNonNull(moleculeType, "moleculeType");
    this.shortDisplayName = Objects.requireNonNull(shortDisplayName, "shortDisplayName");
    this.exportName = Objects.requireNonNull(exportName, "exportName");
    this.atoms = Objects.requireNonNull(atoms, "atoms");
    this.residueRule = Objects.requireNonNull(residueRule, "residueRule");
    this.isPseudoTorsion = AtomBasedTorsionAngleType.super.isPseudoTorsion();
  }

  private ImmutableAtomBasedTorsionAngleType(ImmutableAtomBasedTorsionAngleType.Builder builder) {
    this.moleculeType = builder.moleculeType;
    this.shortDisplayName = builder.shortDisplayName;
    this.exportName = builder.exportName;
    this.atoms = builder.atoms;
    this.residueRule = builder.residueRule;
    this.isPseudoTorsion = builder.isPseudoTorsionIsSet()
        ? builder.isPseudoTorsion
        : AtomBasedTorsionAngleType.super.isPseudoTorsion();
  }

  private ImmutableAtomBasedTorsionAngleType(
      MoleculeType moleculeType,
      String shortDisplayName,
      String exportName,
      Quadruple<AtomName> atoms,
      Quadruple<Integer> residueRule,
      boolean isPseudoTorsion) {
    this.moleculeType = moleculeType;
    this.shortDisplayName = shortDisplayName;
    this.exportName = exportName;
    this.atoms = atoms;
    this.residueRule = residueRule;
    this.isPseudoTorsion = isPseudoTorsion;
  }

  /**
   * @return The value of the {@code moleculeType} attribute
   */
  @Override
  public MoleculeType moleculeType() {
    return moleculeType;
  }

  /**
   * @return The value of the {@code shortDisplayName} attribute
   */
  @Override
  public String shortDisplayName() {
    return shortDisplayName;
  }

  /**
   * @return The value of the {@code exportName} attribute
   */
  @Override
  public String exportName() {
    return exportName;
  }

  /**
   *@return The quadruple of atoms defining this torsion angle type. 
   */
  @Override
  public Quadruple<AtomName> atoms() {
    return atoms;
  }

  /**
   * @return The quadruple of relative indices to take atoms from. For example, a rule (0, 0, 0, 0)
   *     means that all atoms are from the same residue, while a rule (-1, 0, 0, 0) means that the
   *     first atom is taken from the preceding residue.
   */
  @Override
  public Quadruple<Integer> residueRule() {
    return residueRule;
  }

  /**
   * @return True if this is an instance of a pseudo-torsion angle type. A pseudo-torsion angle type
   *     is defined on a quadruple of atoms which are not connected (See {@link
   *     pl.poznan.put.rna.NucleotideTorsionAngle#ETA} or {@link
   *     pl.poznan.put.protein.AminoAcidTorsionAngle#CALPHA}).
   */
  @Override
  public boolean isPseudoTorsion() {
    return isPseudoTorsion;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AtomBasedTorsionAngleType#moleculeType() moleculeType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for moleculeType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAtomBasedTorsionAngleType withMoleculeType(MoleculeType value) {
    if (this.moleculeType == value) return this;
    MoleculeType newValue = Objects.requireNonNull(value, "moleculeType");
    if (this.moleculeType.equals(newValue)) return this;
    return new ImmutableAtomBasedTorsionAngleType(
        newValue,
        this.shortDisplayName,
        this.exportName,
        this.atoms,
        this.residueRule,
        this.isPseudoTorsion);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AtomBasedTorsionAngleType#shortDisplayName() shortDisplayName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for shortDisplayName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAtomBasedTorsionAngleType withShortDisplayName(String value) {
    String newValue = Objects.requireNonNull(value, "shortDisplayName");
    if (this.shortDisplayName.equals(newValue)) return this;
    return new ImmutableAtomBasedTorsionAngleType(
        this.moleculeType,
        newValue,
        this.exportName,
        this.atoms,
        this.residueRule,
        this.isPseudoTorsion);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AtomBasedTorsionAngleType#exportName() exportName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for exportName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAtomBasedTorsionAngleType withExportName(String value) {
    String newValue = Objects.requireNonNull(value, "exportName");
    if (this.exportName.equals(newValue)) return this;
    return new ImmutableAtomBasedTorsionAngleType(
        this.moleculeType,
        this.shortDisplayName,
        newValue,
        this.atoms,
        this.residueRule,
        this.isPseudoTorsion);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AtomBasedTorsionAngleType#atoms() atoms} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for atoms
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAtomBasedTorsionAngleType withAtoms(Quadruple<AtomName> value) {
    if (this.atoms == value) return this;
    Quadruple<AtomName> newValue = Objects.requireNonNull(value, "atoms");
    return new ImmutableAtomBasedTorsionAngleType(
        this.moleculeType,
        this.shortDisplayName,
        this.exportName,
        newValue,
        this.residueRule,
        this.isPseudoTorsion);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AtomBasedTorsionAngleType#residueRule() residueRule} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for residueRule
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAtomBasedTorsionAngleType withResidueRule(Quadruple<Integer> value) {
    if (this.residueRule == value) return this;
    Quadruple<Integer> newValue = Objects.requireNonNull(value, "residueRule");
    return new ImmutableAtomBasedTorsionAngleType(
        this.moleculeType,
        this.shortDisplayName,
        this.exportName,
        this.atoms,
        newValue,
        this.isPseudoTorsion);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AtomBasedTorsionAngleType#isPseudoTorsion() isPseudoTorsion} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isPseudoTorsion
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAtomBasedTorsionAngleType withIsPseudoTorsion(boolean value) {
    if (this.isPseudoTorsion == value) return this;
    return new ImmutableAtomBasedTorsionAngleType(this.moleculeType, this.shortDisplayName, this.exportName, this.atoms, this.residueRule, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAtomBasedTorsionAngleType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAtomBasedTorsionAngleType
        && equalTo((ImmutableAtomBasedTorsionAngleType) another);
  }

  private boolean equalTo(ImmutableAtomBasedTorsionAngleType another) {
    return moleculeType.equals(another.moleculeType)
        && shortDisplayName.equals(another.shortDisplayName)
        && exportName.equals(another.exportName)
        && atoms.equals(another.atoms)
        && residueRule.equals(another.residueRule)
        && isPseudoTorsion == another.isPseudoTorsion;
  }

  /**
   * Computes a hash code from attributes: {@code moleculeType}, {@code shortDisplayName}, {@code exportName}, {@code atoms}, {@code residueRule}, {@code isPseudoTorsion}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + moleculeType.hashCode();
    h += (h << 5) + shortDisplayName.hashCode();
    h += (h << 5) + exportName.hashCode();
    h += (h << 5) + atoms.hashCode();
    h += (h << 5) + residueRule.hashCode();
    h += (h << 5) + Boolean.hashCode(isPseudoTorsion);
    return h;
  }

  /**
   * Prints the immutable value {@code AtomBasedTorsionAngleType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AtomBasedTorsionAngleType{"
        + "moleculeType=" + moleculeType
        + ", shortDisplayName=" + shortDisplayName
        + ", exportName=" + exportName
        + ", atoms=" + atoms
        + ", residueRule=" + residueRule
        + ", isPseudoTorsion=" + isPseudoTorsion
        + "}";
  }

  /**
   * Construct a new immutable {@code AtomBasedTorsionAngleType} instance.
   * @param moleculeType The value for the {@code moleculeType} attribute
   * @param shortDisplayName The value for the {@code shortDisplayName} attribute
   * @param exportName The value for the {@code exportName} attribute
   * @param atoms The value for the {@code atoms} attribute
   * @param residueRule The value for the {@code residueRule} attribute
   * @return An immutable AtomBasedTorsionAngleType instance
   */
  public static ImmutableAtomBasedTorsionAngleType of(MoleculeType moleculeType, String shortDisplayName, String exportName, Quadruple<AtomName> atoms, Quadruple<Integer> residueRule) {
    return new ImmutableAtomBasedTorsionAngleType(moleculeType, shortDisplayName, exportName, atoms, residueRule);
  }

  /**
   * Creates an immutable copy of a {@link AtomBasedTorsionAngleType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AtomBasedTorsionAngleType instance
   */
  public static ImmutableAtomBasedTorsionAngleType copyOf(AtomBasedTorsionAngleType instance) {
    if (instance instanceof ImmutableAtomBasedTorsionAngleType) {
      return (ImmutableAtomBasedTorsionAngleType) instance;
    }
    return ImmutableAtomBasedTorsionAngleType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAtomBasedTorsionAngleType ImmutableAtomBasedTorsionAngleType}.
   * <pre>
   * ImmutableAtomBasedTorsionAngleType.builder()
   *    .moleculeType(pl.poznan.put.pdb.analysis.MoleculeType) // required {@link AtomBasedTorsionAngleType#moleculeType() moleculeType}
   *    .shortDisplayName(String) // required {@link AtomBasedTorsionAngleType#shortDisplayName() shortDisplayName}
   *    .exportName(String) // required {@link AtomBasedTorsionAngleType#exportName() exportName}
   *    .atoms(pl.poznan.put.types.Quadruple&amp;lt;pl.poznan.put.atom.AtomName&amp;gt;) // required {@link AtomBasedTorsionAngleType#atoms() atoms}
   *    .residueRule(pl.poznan.put.types.Quadruple&amp;lt;Integer&amp;gt;) // required {@link AtomBasedTorsionAngleType#residueRule() residueRule}
   *    .isPseudoTorsion(boolean) // optional {@link AtomBasedTorsionAngleType#isPseudoTorsion() isPseudoTorsion}
   *    .build();
   * </pre>
   * @return A new ImmutableAtomBasedTorsionAngleType builder
   */
  public static ImmutableAtomBasedTorsionAngleType.Builder builder() {
    return new ImmutableAtomBasedTorsionAngleType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAtomBasedTorsionAngleType ImmutableAtomBasedTorsionAngleType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AtomBasedTorsionAngleType", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_MOLECULE_TYPE = 0x1L;
    private static final long INIT_BIT_SHORT_DISPLAY_NAME = 0x2L;
    private static final long INIT_BIT_EXPORT_NAME = 0x4L;
    private static final long INIT_BIT_ATOMS = 0x8L;
    private static final long INIT_BIT_RESIDUE_RULE = 0x10L;
    private static final long OPT_BIT_IS_PSEUDO_TORSION = 0x1L;
    private long initBits = 0x1fL;
    private long optBits;

    private @Nullable MoleculeType moleculeType;
    private @Nullable String shortDisplayName;
    private @Nullable String exportName;
    private @Nullable Quadruple<AtomName> atoms;
    private @Nullable Quadruple<Integer> residueRule;
    private boolean isPseudoTorsion;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.torsion.AtomBasedTorsionAngleType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AtomBasedTorsionAngleType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.torsion.TorsionAngleType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TorsionAngleType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.interfaces.DisplayableExportable} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DisplayableExportable instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof AtomBasedTorsionAngleType) {
        AtomBasedTorsionAngleType instance = (AtomBasedTorsionAngleType) object;
        if ((bits & 0x1L) == 0) {
          shortDisplayName(instance.shortDisplayName());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          moleculeType(instance.moleculeType());
          bits |= 0x2L;
        }
        residueRule(instance.residueRule());
        if ((bits & 0x4L) == 0) {
          exportName(instance.exportName());
          bits |= 0x4L;
        }
        isPseudoTorsion(instance.isPseudoTorsion());
        atoms(instance.atoms());
      }
      if (object instanceof TorsionAngleType) {
        TorsionAngleType instance = (TorsionAngleType) object;
        if ((bits & 0x2L) == 0) {
          moleculeType(instance.moleculeType());
          bits |= 0x2L;
        }
      }
      if (object instanceof DisplayableExportable) {
        DisplayableExportable instance = (DisplayableExportable) object;
        if ((bits & 0x1L) == 0) {
          shortDisplayName(instance.shortDisplayName());
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          exportName(instance.exportName());
          bits |= 0x4L;
        }
      }
    }

    /**
     * Initializes the value for the {@link AtomBasedTorsionAngleType#moleculeType() moleculeType} attribute.
     * @param moleculeType The value for moleculeType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder moleculeType(MoleculeType moleculeType) {
      this.moleculeType = Objects.requireNonNull(moleculeType, "moleculeType");
      initBits &= ~INIT_BIT_MOLECULE_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link AtomBasedTorsionAngleType#shortDisplayName() shortDisplayName} attribute.
     * @param shortDisplayName The value for shortDisplayName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder shortDisplayName(String shortDisplayName) {
      this.shortDisplayName = Objects.requireNonNull(shortDisplayName, "shortDisplayName");
      initBits &= ~INIT_BIT_SHORT_DISPLAY_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link AtomBasedTorsionAngleType#exportName() exportName} attribute.
     * @param exportName The value for exportName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder exportName(String exportName) {
      this.exportName = Objects.requireNonNull(exportName, "exportName");
      initBits &= ~INIT_BIT_EXPORT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link AtomBasedTorsionAngleType#atoms() atoms} attribute.
     * @param atoms The value for atoms 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder atoms(Quadruple<AtomName> atoms) {
      this.atoms = Objects.requireNonNull(atoms, "atoms");
      initBits &= ~INIT_BIT_ATOMS;
      return this;
    }

    /**
     * Initializes the value for the {@link AtomBasedTorsionAngleType#residueRule() residueRule} attribute.
     * @param residueRule The value for residueRule 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder residueRule(Quadruple<Integer> residueRule) {
      this.residueRule = Objects.requireNonNull(residueRule, "residueRule");
      initBits &= ~INIT_BIT_RESIDUE_RULE;
      return this;
    }

    /**
     * Initializes the value for the {@link AtomBasedTorsionAngleType#isPseudoTorsion() isPseudoTorsion} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AtomBasedTorsionAngleType#isPseudoTorsion() isPseudoTorsion}.</em>
     * @param isPseudoTorsion The value for isPseudoTorsion 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isPseudoTorsion(boolean isPseudoTorsion) {
      this.isPseudoTorsion = isPseudoTorsion;
      optBits |= OPT_BIT_IS_PSEUDO_TORSION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAtomBasedTorsionAngleType ImmutableAtomBasedTorsionAngleType}.
     * @return An immutable instance of AtomBasedTorsionAngleType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAtomBasedTorsionAngleType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAtomBasedTorsionAngleType(this);
    }

    private boolean isPseudoTorsionIsSet() {
      return (optBits & OPT_BIT_IS_PSEUDO_TORSION) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MOLECULE_TYPE) != 0) attributes.add("moleculeType");
      if ((initBits & INIT_BIT_SHORT_DISPLAY_NAME) != 0) attributes.add("shortDisplayName");
      if ((initBits & INIT_BIT_EXPORT_NAME) != 0) attributes.add("exportName");
      if ((initBits & INIT_BIT_ATOMS) != 0) attributes.add("atoms");
      if ((initBits & INIT_BIT_RESIDUE_RULE) != 0) attributes.add("residueRule");
      return "Cannot build AtomBasedTorsionAngleType, some of required attributes are not set " + attributes;
    }
  }
}
