package pl.poznan.put.structure.pseudoknots.dp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.structure.pseudoknots.Region;

/**
 * Immutable implementation of {@link SubSolution}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSubSolution.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableSubSolution.of()}.
 */
@Generated(from = "SubSolution", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
final class ImmutableSubSolution extends SubSolution {
  private final List<Region> regions;

  private ImmutableSubSolution(Iterable<? extends Region> regions) {
    this.regions = createUnmodifiableList(false, createSafeList(regions, true, false));
  }

  private ImmutableSubSolution(ImmutableSubSolution original, List<Region> regions) {
    this.regions = regions;
  }

  /**
   * @return The value of the {@code regions} attribute
   */
  @Override
  public List<Region> regions() {
    return regions;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SubSolution#regions() regions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSubSolution withRegions(Region... elements) {
    List<Region> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableSubSolution(this, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SubSolution#regions() regions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of regions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSubSolution withRegions(Iterable<? extends Region> elements) {
    if (this.regions == elements) return this;
    List<Region> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableSubSolution(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSubSolution} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSubSolution
        && equalTo((ImmutableSubSolution) another);
  }

  private boolean equalTo(ImmutableSubSolution another) {
    return regions.equals(another.regions);
  }

  /**
   * Computes a hash code from attributes: {@code regions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + regions.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SubSolution} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SubSolution{"
        + "regions=" + regions
        + "}";
  }

  private transient volatile long lazyInitBitmap;

  private static final long SCORE_LAZY_INIT_BIT = 0x1L;

  private transient int score;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link SubSolution#score() score} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code score} attribute
   */
  @Override
  public int score() {
    if ((lazyInitBitmap & SCORE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SCORE_LAZY_INIT_BIT) == 0) {
          this.score = super.score();
          lazyInitBitmap |= SCORE_LAZY_INIT_BIT;
        }
      }
    }
    return score;
  }

  private static final long LOWEST_ENDPOINT_LAZY_INIT_BIT = 0x2L;

  private transient int lowestEndpoint;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link SubSolution#lowestEndpoint() lowestEndpoint} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code lowestEndpoint} attribute
   */
  @Override
  public int lowestEndpoint() {
    if ((lazyInitBitmap & LOWEST_ENDPOINT_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & LOWEST_ENDPOINT_LAZY_INIT_BIT) == 0) {
          this.lowestEndpoint = super.lowestEndpoint();
          lazyInitBitmap |= LOWEST_ENDPOINT_LAZY_INIT_BIT;
        }
      }
    }
    return lowestEndpoint;
  }

  private static final long HIGHEST_ENDPOINT_LAZY_INIT_BIT = 0x4L;

  private transient int highestEndpoint;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link SubSolution#highestEndpoint() highestEndpoint} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code highestEndpoint} attribute
   */
  @Override
  public int highestEndpoint() {
    if ((lazyInitBitmap & HIGHEST_ENDPOINT_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & HIGHEST_ENDPOINT_LAZY_INIT_BIT) == 0) {
          this.highestEndpoint = super.highestEndpoint();
          lazyInitBitmap |= HIGHEST_ENDPOINT_LAZY_INIT_BIT;
        }
      }
    }
    return highestEndpoint;
  }

  /**
   * Construct a new immutable {@code SubSolution} instance.
   * @param regions The value for the {@code regions} attribute
   * @return An immutable SubSolution instance
   */
  public static ImmutableSubSolution of(List<Region> regions) {
    return of((Iterable<? extends Region>) regions);
  }

  /**
   * Construct a new immutable {@code SubSolution} instance.
   * @param regions The value for the {@code regions} attribute
   * @return An immutable SubSolution instance
   */
  public static ImmutableSubSolution of(Iterable<? extends Region> regions) {
    return new ImmutableSubSolution(regions);
  }

  /**
   * Creates an immutable copy of a {@link SubSolution} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SubSolution instance
   */
  public static ImmutableSubSolution copyOf(SubSolution instance) {
    if (instance instanceof ImmutableSubSolution) {
      return (ImmutableSubSolution) instance;
    }
    return ImmutableSubSolution.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSubSolution ImmutableSubSolution}.
   * <pre>
   * ImmutableSubSolution.builder()
   *    .addRegions|addAllRegions(pl.poznan.put.structure.pseudoknots.Region) // {@link SubSolution#regions() regions} elements
   *    .build();
   * </pre>
   * @return A new ImmutableSubSolution builder
   */
  public static ImmutableSubSolution.Builder builder() {
    return new ImmutableSubSolution.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSubSolution ImmutableSubSolution}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SubSolution", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<Region> regions = new ArrayList<Region>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SubSolution} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SubSolution instance) {
      Objects.requireNonNull(instance, "instance");
      addAllRegions(instance.regions());
      return this;
    }

    /**
     * Adds one element to {@link SubSolution#regions() regions} list.
     * @param element A regions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRegions(Region element) {
      this.regions.add(Objects.requireNonNull(element, "regions element"));
      return this;
    }

    /**
     * Adds elements to {@link SubSolution#regions() regions} list.
     * @param elements An array of regions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRegions(Region... elements) {
      for (Region element : elements) {
        this.regions.add(Objects.requireNonNull(element, "regions element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SubSolution#regions() regions} list.
     * @param elements An iterable of regions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder regions(Iterable<? extends Region> elements) {
      this.regions.clear();
      return addAllRegions(elements);
    }

    /**
     * Adds elements to {@link SubSolution#regions() regions} list.
     * @param elements An iterable of regions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRegions(Iterable<? extends Region> elements) {
      for (Region element : elements) {
        this.regions.add(Objects.requireNonNull(element, "regions element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableSubSolution ImmutableSubSolution}.
     * @return An immutable instance of SubSolution
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSubSolution build() {
      return new ImmutableSubSolution(null, createUnmodifiableList(true, regions));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
