package pl.poznan.put.structure.pseudoknots.dp;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.structure.pseudoknots.elimination.RegionRemover;

/**
 * Immutable implementation of {@link DynamicProgrammingAll}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDynamicProgrammingAll.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableDynamicProgrammingAll.of()}.
 */
@Generated(from = "DynamicProgrammingAll", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableDynamicProgrammingAll
    extends DynamicProgrammingAll {
  private final @Nullable RegionRemover regionRemover;
  private final int maxCliqueSize;

  private ImmutableDynamicProgrammingAll() {
    this.regionRemover = null;
    this.maxCliqueSize = super.maxCliqueSize();
  }

  private ImmutableDynamicProgrammingAll(ImmutableDynamicProgrammingAll.Builder builder) {
    this.regionRemover = builder.regionRemover;
    this.maxCliqueSize = builder.maxCliqueSizeIsSet()
        ? builder.maxCliqueSize
        : super.maxCliqueSize();
  }

  private ImmutableDynamicProgrammingAll(
      @Nullable RegionRemover regionRemover,
      int maxCliqueSize) {
    this.regionRemover = regionRemover;
    this.maxCliqueSize = maxCliqueSize;
  }

  /**
   * @return An optional region remover to be used if a clique size exceeds {@code maxCliqueSize()}.
   */
  @Override
  protected Optional<RegionRemover> regionRemover() {
    return Optional.ofNullable(regionRemover);
  }

  /**
   * @return The maximum number of conflicts allowed to be in the clique. The algorithm slows down
   *     very much when the cliques are getting bigger, so it is advisable to use a heuristic to
   *     remove a single regions and decrease clique size significantly.
   */
  @Override
  protected int maxCliqueSize() {
    return maxCliqueSize;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link DynamicProgrammingAll#regionRemover() regionRemover} attribute.
   * @param value The value for regionRemover
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDynamicProgrammingAll withRegionRemover(RegionRemover value) {
    @Nullable RegionRemover newValue = Objects.requireNonNull(value, "regionRemover");
    if (this.regionRemover == newValue) return this;
    return validate(new ImmutableDynamicProgrammingAll(newValue, this.maxCliqueSize));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link DynamicProgrammingAll#regionRemover() regionRemover} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for regionRemover
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableDynamicProgrammingAll withRegionRemover(Optional<? extends RegionRemover> optional) {
    @Nullable RegionRemover value = optional.orElse(null);
    if (this.regionRemover == value) return this;
    return validate(new ImmutableDynamicProgrammingAll(value, this.maxCliqueSize));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DynamicProgrammingAll#maxCliqueSize() maxCliqueSize} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxCliqueSize
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDynamicProgrammingAll withMaxCliqueSize(int value) {
    if (this.maxCliqueSize == value) return this;
    return validate(new ImmutableDynamicProgrammingAll(this.regionRemover, value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDynamicProgrammingAll} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDynamicProgrammingAll
        && equalTo((ImmutableDynamicProgrammingAll) another);
  }

  private boolean equalTo(ImmutableDynamicProgrammingAll another) {
    return Objects.equals(regionRemover, another.regionRemover)
        && maxCliqueSize == another.maxCliqueSize;
  }

  /**
   * Computes a hash code from attributes: {@code regionRemover}, {@code maxCliqueSize}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(regionRemover);
    h += (h << 5) + maxCliqueSize;
    return h;
  }

  /**
   * Prints the immutable value {@code DynamicProgrammingAll} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("DynamicProgrammingAll{");
    if (regionRemover != null) {
      builder.append("regionRemover=").append(regionRemover);
    }
    if (builder.length() > 22) builder.append(", ");
    builder.append("maxCliqueSize=").append(maxCliqueSize);
    return builder.append("}").toString();
  }

  private static final ImmutableDynamicProgrammingAll INSTANCE = validate(new ImmutableDynamicProgrammingAll());

  /**
   * Returns the default immutable singleton value of {@code DynamicProgrammingAll}
   * @return An immutable instance of DynamicProgrammingAll
   */
  public static ImmutableDynamicProgrammingAll of() {
    return INSTANCE;
  }

  private static ImmutableDynamicProgrammingAll validate(ImmutableDynamicProgrammingAll instance) {
    return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link DynamicProgrammingAll} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DynamicProgrammingAll instance
   */
  public static ImmutableDynamicProgrammingAll copyOf(DynamicProgrammingAll instance) {
    if (instance instanceof ImmutableDynamicProgrammingAll) {
      return (ImmutableDynamicProgrammingAll) instance;
    }
    return ImmutableDynamicProgrammingAll.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDynamicProgrammingAll ImmutableDynamicProgrammingAll}.
   * <pre>
   * ImmutableDynamicProgrammingAll.builder()
   *    .regionRemover(pl.poznan.put.structure.pseudoknots.elimination.RegionRemover) // optional {@link DynamicProgrammingAll#regionRemover() regionRemover}
   *    .maxCliqueSize(int) // optional {@link DynamicProgrammingAll#maxCliqueSize() maxCliqueSize}
   *    .build();
   * </pre>
   * @return A new ImmutableDynamicProgrammingAll builder
   */
  public static ImmutableDynamicProgrammingAll.Builder builder() {
    return new ImmutableDynamicProgrammingAll.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDynamicProgrammingAll ImmutableDynamicProgrammingAll}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DynamicProgrammingAll", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_MAX_CLIQUE_SIZE = 0x1L;
    private long optBits;

    private @Nullable RegionRemover regionRemover;
    private int maxCliqueSize;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DynamicProgrammingAll} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DynamicProgrammingAll instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<RegionRemover> regionRemoverOptional = instance.regionRemover();
      if (regionRemoverOptional.isPresent()) {
        regionRemover(regionRemoverOptional);
      }
      maxCliqueSize(instance.maxCliqueSize());
      return this;
    }

    /**
     * Initializes the optional value {@link DynamicProgrammingAll#regionRemover() regionRemover} to regionRemover.
     * @param regionRemover The value for regionRemover
     * @return {@code this} builder for chained invocation
     */
    public final Builder regionRemover(RegionRemover regionRemover) {
      this.regionRemover = Objects.requireNonNull(regionRemover, "regionRemover");
      return this;
    }

    /**
     * Initializes the optional value {@link DynamicProgrammingAll#regionRemover() regionRemover} to regionRemover.
     * @param regionRemover The value for regionRemover
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder regionRemover(Optional<? extends RegionRemover> regionRemover) {
      this.regionRemover = regionRemover.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link DynamicProgrammingAll#maxCliqueSize() maxCliqueSize} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DynamicProgrammingAll#maxCliqueSize() maxCliqueSize}.</em>
     * @param maxCliqueSize The value for maxCliqueSize 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder maxCliqueSize(int maxCliqueSize) {
      this.maxCliqueSize = maxCliqueSize;
      optBits |= OPT_BIT_MAX_CLIQUE_SIZE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDynamicProgrammingAll ImmutableDynamicProgrammingAll}.
     * @return An immutable instance of DynamicProgrammingAll
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDynamicProgrammingAll build() {
      return ImmutableDynamicProgrammingAll.validate(new ImmutableDynamicProgrammingAll(this));
    }

    private boolean maxCliqueSizeIsSet() {
      return (optBits & OPT_BIT_MAX_CLIQUE_SIZE) != 0;
    }
  }
}
