package pl.poznan.put.structure.pseudoknots.dp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.structure.pseudoknots.Region;

/**
 * Immutable implementation of {@link ConflictClique}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConflictClique.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableConflictClique.of()}.
 */
@Generated(from = "ConflictClique", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableConflictClique extends ConflictClique {
  private final Set<Region> regions;

  private ImmutableConflictClique(Iterable<? extends Region> regions) {
    this.regions = createUnmodifiableSet(createSafeList(regions, true, false));
  }

  private ImmutableConflictClique(ImmutableConflictClique original, Set<Region> regions) {
    this.regions = regions;
  }

  /**
   *@return The set of regions in this conflict clique. 
   */
  @Override
  public Set<Region> regions() {
    return regions;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConflictClique#regions() regions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConflictClique withRegions(Region... elements) {
    Set<Region> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableConflictClique(this, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConflictClique#regions() regions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of regions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConflictClique withRegions(Iterable<? extends Region> elements) {
    if (this.regions == elements) return this;
    Set<Region> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return new ImmutableConflictClique(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConflictClique} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConflictClique
        && equalTo((ImmutableConflictClique) another);
  }

  private boolean equalTo(ImmutableConflictClique another) {
    return regions.equals(another.regions);
  }

  /**
   * Computes a hash code from attributes: {@code regions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + regions.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConflictClique} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ConflictClique{"
        + "regions=" + regions
        + "}";
  }

  private transient volatile long lazyInitBitmap;

  private static final long SORTED_ENDPOINTS_LAZY_INIT_BIT = 0x1L;

  private transient List<Integer> sortedEndpoints;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ConflictClique#sortedEndpoints() sortedEndpoints} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code sortedEndpoints} attribute
   */
  @Override
  protected List<Integer> sortedEndpoints() {
    if ((lazyInitBitmap & SORTED_ENDPOINTS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SORTED_ENDPOINTS_LAZY_INIT_BIT) == 0) {
          this.sortedEndpoints = Objects.requireNonNull(super.sortedEndpoints(), "sortedEndpoints");
          lazyInitBitmap |= SORTED_ENDPOINTS_LAZY_INIT_BIT;
        }
      }
    }
    return sortedEndpoints;
  }

  /**
   * Construct a new immutable {@code ConflictClique} instance.
   * @param regions The value for the {@code regions} attribute
   * @return An immutable ConflictClique instance
   */
  public static ImmutableConflictClique of(Set<Region> regions) {
    return of((Iterable<? extends Region>) regions);
  }

  /**
   * Construct a new immutable {@code ConflictClique} instance.
   * @param regions The value for the {@code regions} attribute
   * @return An immutable ConflictClique instance
   */
  public static ImmutableConflictClique of(Iterable<? extends Region> regions) {
    return new ImmutableConflictClique(regions);
  }

  /**
   * Creates an immutable copy of a {@link ConflictClique} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConflictClique instance
   */
  public static ImmutableConflictClique copyOf(ConflictClique instance) {
    if (instance instanceof ImmutableConflictClique) {
      return (ImmutableConflictClique) instance;
    }
    return ImmutableConflictClique.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConflictClique ImmutableConflictClique}.
   * <pre>
   * ImmutableConflictClique.builder()
   *    .addRegions|addAllRegions(pl.poznan.put.structure.pseudoknots.Region) // {@link ConflictClique#regions() regions} elements
   *    .build();
   * </pre>
   * @return A new ImmutableConflictClique builder
   */
  public static ImmutableConflictClique.Builder builder() {
    return new ImmutableConflictClique.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableConflictClique ImmutableConflictClique}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ConflictClique", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<Region> regions = new ArrayList<Region>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConflictClique} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConflictClique instance) {
      Objects.requireNonNull(instance, "instance");
      addAllRegions(instance.regions());
      return this;
    }

    /**
     * Adds one element to {@link ConflictClique#regions() regions} set.
     * @param element A regions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRegions(Region element) {
      this.regions.add(Objects.requireNonNull(element, "regions element"));
      return this;
    }

    /**
     * Adds elements to {@link ConflictClique#regions() regions} set.
     * @param elements An array of regions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRegions(Region... elements) {
      for (Region element : elements) {
        this.regions.add(Objects.requireNonNull(element, "regions element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ConflictClique#regions() regions} set.
     * @param elements An iterable of regions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder regions(Iterable<? extends Region> elements) {
      this.regions.clear();
      return addAllRegions(elements);
    }

    /**
     * Adds elements to {@link ConflictClique#regions() regions} set.
     * @param elements An iterable of regions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRegions(Iterable<? extends Region> elements) {
      for (Region element : elements) {
        this.regions.add(Objects.requireNonNull(element, "regions element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableConflictClique ImmutableConflictClique}.
     * @return An immutable instance of ConflictClique
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConflictClique build() {
      return new ImmutableConflictClique(null, createUnmodifiableSet(regions));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }
}
