package pl.poznan.put.structure.pseudoknots;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ConflictGraph}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConflictGraph.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableConflictGraph.of()}.
 */
@Generated(from = "ConflictGraph", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableConflictGraph extends ConflictGraph {
  private final List<Region> regions;

  private ImmutableConflictGraph(Iterable<? extends Region> regions) {
    this.regions = createUnmodifiableList(false, createSafeList(regions, true, false));
  }

  private ImmutableConflictGraph(ImmutableConflictGraph original, List<Region> regions) {
    this.regions = regions;
  }

  /**
   * @return The value of the {@code regions} attribute
   */
  @Override
  protected List<Region> regions() {
    return regions;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConflictGraph#regions() regions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConflictGraph withRegions(Region... elements) {
    List<Region> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableConflictGraph(this, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConflictGraph#regions() regions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of regions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConflictGraph withRegions(Iterable<? extends Region> elements) {
    if (this.regions == elements) return this;
    List<Region> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableConflictGraph(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConflictGraph} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConflictGraph
        && equalTo((ImmutableConflictGraph) another);
  }

  private boolean equalTo(ImmutableConflictGraph another) {
    return regions.equals(another.regions);
  }

  /**
   * Computes a hash code from attributes: {@code regions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + regions.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConflictGraph} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ConflictGraph{"
        + "regions=" + regions
        + "}";
  }

  private transient volatile long lazyInitBitmap;

  private static final long CONFLICTS_LAZY_INIT_BIT = 0x1L;

  private transient Map<Region, Set<Region>> conflicts;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ConflictGraph#conflicts() conflicts} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code conflicts} attribute
   */
  @Override
  protected Map<Region, Set<Region>> conflicts() {
    if ((lazyInitBitmap & CONFLICTS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CONFLICTS_LAZY_INIT_BIT) == 0) {
          this.conflicts = Objects.requireNonNull(super.conflicts(), "conflicts");
          lazyInitBitmap |= CONFLICTS_LAZY_INIT_BIT;
        }
      }
    }
    return conflicts;
  }

  /**
   * Construct a new immutable {@code ConflictGraph} instance.
   * @param regions The value for the {@code regions} attribute
   * @return An immutable ConflictGraph instance
   */
  public static ImmutableConflictGraph of(List<Region> regions) {
    return of((Iterable<? extends Region>) regions);
  }

  /**
   * Construct a new immutable {@code ConflictGraph} instance.
   * @param regions The value for the {@code regions} attribute
   * @return An immutable ConflictGraph instance
   */
  public static ImmutableConflictGraph of(Iterable<? extends Region> regions) {
    return new ImmutableConflictGraph(regions);
  }

  /**
   * Creates an immutable copy of a {@link ConflictGraph} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConflictGraph instance
   */
  public static ImmutableConflictGraph copyOf(ConflictGraph instance) {
    if (instance instanceof ImmutableConflictGraph) {
      return (ImmutableConflictGraph) instance;
    }
    return ImmutableConflictGraph.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConflictGraph ImmutableConflictGraph}.
   * <pre>
   * ImmutableConflictGraph.builder()
   *    .addRegions|addAllRegions(pl.poznan.put.structure.pseudoknots.Region) // {@link ConflictGraph#regions() regions} elements
   *    .build();
   * </pre>
   * @return A new ImmutableConflictGraph builder
   */
  public static ImmutableConflictGraph.Builder builder() {
    return new ImmutableConflictGraph.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableConflictGraph ImmutableConflictGraph}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ConflictGraph", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<Region> regions = new ArrayList<Region>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConflictGraph} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConflictGraph instance) {
      Objects.requireNonNull(instance, "instance");
      addAllRegions(instance.regions());
      return this;
    }

    /**
     * Adds one element to {@link ConflictGraph#regions() regions} list.
     * @param element A regions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRegions(Region element) {
      this.regions.add(Objects.requireNonNull(element, "regions element"));
      return this;
    }

    /**
     * Adds elements to {@link ConflictGraph#regions() regions} list.
     * @param elements An array of regions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRegions(Region... elements) {
      for (Region element : elements) {
        this.regions.add(Objects.requireNonNull(element, "regions element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ConflictGraph#regions() regions} list.
     * @param elements An iterable of regions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder regions(Iterable<? extends Region> elements) {
      this.regions.clear();
      return addAllRegions(elements);
    }

    /**
     * Adds elements to {@link ConflictGraph#regions() regions} list.
     * @param elements An iterable of regions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRegions(Iterable<? extends Region> elements) {
      for (Region element : elements) {
        this.regions.add(Objects.requireNonNull(element, "regions element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableConflictGraph ImmutableConflictGraph}.
     * @return An immutable instance of ConflictGraph
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConflictGraph build() {
      return new ImmutableConflictGraph(null, createUnmodifiableList(true, regions));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
