package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.structure.DotBracketSymbol;

/**
 * Immutable implementation of {@link TerminalMissing}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTerminalMissing.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableTerminalMissing.of()}.
 */
@Generated(from = "TerminalMissing", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableTerminalMissing extends TerminalMissing {
  private final List<DotBracketSymbol> symbols;

  private ImmutableTerminalMissing(Iterable<? extends DotBracketSymbol> symbols) {
    this.symbols = createUnmodifiableList(false, createSafeList(symbols, true, false));
  }

  private ImmutableTerminalMissing(ImmutableTerminalMissing original, List<DotBracketSymbol> symbols) {
    this.symbols = symbols;
  }

  /**
   *@return The list of missing symbols. 
   */
  @Override
  public List<DotBracketSymbol> symbols() {
    return symbols;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TerminalMissing#symbols() symbols}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTerminalMissing withSymbols(DotBracketSymbol... elements) {
    List<DotBracketSymbol> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableTerminalMissing(this, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TerminalMissing#symbols() symbols}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of symbols elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTerminalMissing withSymbols(Iterable<? extends DotBracketSymbol> elements) {
    if (this.symbols == elements) return this;
    List<DotBracketSymbol> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableTerminalMissing(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTerminalMissing} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTerminalMissing
        && equalTo((ImmutableTerminalMissing) another);
  }

  private boolean equalTo(ImmutableTerminalMissing another) {
    return symbols.equals(another.symbols);
  }

  /**
   * Computes a hash code from attributes: {@code symbols}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + symbols.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TerminalMissing} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TerminalMissing{"
        + "symbols=" + symbols
        + "}";
  }

  /**
   * Construct a new immutable {@code TerminalMissing} instance.
   * @param symbols The value for the {@code symbols} attribute
   * @return An immutable TerminalMissing instance
   */
  public static ImmutableTerminalMissing of(List<DotBracketSymbol> symbols) {
    return of((Iterable<? extends DotBracketSymbol>) symbols);
  }

  /**
   * Construct a new immutable {@code TerminalMissing} instance.
   * @param symbols The value for the {@code symbols} attribute
   * @return An immutable TerminalMissing instance
   */
  public static ImmutableTerminalMissing of(Iterable<? extends DotBracketSymbol> symbols) {
    return new ImmutableTerminalMissing(symbols);
  }

  /**
   * Creates an immutable copy of a {@link TerminalMissing} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TerminalMissing instance
   */
  public static ImmutableTerminalMissing copyOf(TerminalMissing instance) {
    if (instance instanceof ImmutableTerminalMissing) {
      return (ImmutableTerminalMissing) instance;
    }
    return ImmutableTerminalMissing.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTerminalMissing ImmutableTerminalMissing}.
   * <pre>
   * ImmutableTerminalMissing.builder()
   *    .addSymbols|addAllSymbols(pl.poznan.put.structure.DotBracketSymbol) // {@link TerminalMissing#symbols() symbols} elements
   *    .build();
   * </pre>
   * @return A new ImmutableTerminalMissing builder
   */
  public static ImmutableTerminalMissing.Builder builder() {
    return new ImmutableTerminalMissing.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTerminalMissing ImmutableTerminalMissing}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TerminalMissing", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<DotBracketSymbol> symbols = new ArrayList<DotBracketSymbol>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TerminalMissing} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TerminalMissing instance) {
      Objects.requireNonNull(instance, "instance");
      addAllSymbols(instance.symbols());
      return this;
    }

    /**
     * Adds one element to {@link TerminalMissing#symbols() symbols} list.
     * @param element A symbols element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSymbols(DotBracketSymbol element) {
      this.symbols.add(Objects.requireNonNull(element, "symbols element"));
      return this;
    }

    /**
     * Adds elements to {@link TerminalMissing#symbols() symbols} list.
     * @param elements An array of symbols elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSymbols(DotBracketSymbol... elements) {
      for (DotBracketSymbol element : elements) {
        this.symbols.add(Objects.requireNonNull(element, "symbols element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link TerminalMissing#symbols() symbols} list.
     * @param elements An iterable of symbols elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder symbols(Iterable<? extends DotBracketSymbol> elements) {
      this.symbols.clear();
      return addAllSymbols(elements);
    }

    /**
     * Adds elements to {@link TerminalMissing#symbols() symbols} list.
     * @param elements An iterable of symbols elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSymbols(Iterable<? extends DotBracketSymbol> elements) {
      for (DotBracketSymbol element : elements) {
        this.symbols.add(Objects.requireNonNull(element, "symbols element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableTerminalMissing ImmutableTerminalMissing}.
     * @return An immutable instance of TerminalMissing
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTerminalMissing build() {
      return new ImmutableTerminalMissing(null, createUnmodifiableList(true, symbols));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
