package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DefaultConverter.State}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableState.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableState.of()}.
 */
@Generated(from = "DefaultConverter.State", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
final class ImmutableState extends DefaultConverter.State {
  private final @Nullable DefaultConverter.State parent;
  private final BpSeq bpSeq;
  private final int level;

  @SuppressWarnings("unchecked") // safe covariant cast
  private ImmutableState(
      Optional<? extends DefaultConverter.State> parent,
      BpSeq bpSeq,
      int level) {
    this.parent = parent.orElse(null);
    this.bpSeq = Objects.requireNonNull(bpSeq, "bpSeq");
    this.level = level;
  }

  private ImmutableState(
      ImmutableState original,
      @Nullable DefaultConverter.State parent,
      BpSeq bpSeq,
      int level) {
    this.parent = parent;
    this.bpSeq = bpSeq;
    this.level = level;
  }

  /**
   * @return The value of the {@code parent} attribute
   */
  @Override
  public Optional<DefaultConverter.State> parent() {
    return Optional.ofNullable(parent);
  }

  /**
   * @return The value of the {@code bpSeq} attribute
   */
  @Override
  public BpSeq bpSeq() {
    return bpSeq;
  }

  /**
   * @return The value of the {@code level} attribute
   */
  @Override
  public int level() {
    return level;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link DefaultConverter.State#parent() parent} attribute.
   * @param value The value for parent
   * @return A modified copy of {@code this} object
   */
  public final ImmutableState withParent(DefaultConverter.State value) {
    @Nullable DefaultConverter.State newValue = Objects.requireNonNull(value, "parent");
    if (this.parent == newValue) return this;
    return new ImmutableState(this, newValue, this.bpSeq, this.level);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link DefaultConverter.State#parent() parent} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for parent
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableState withParent(Optional<? extends DefaultConverter.State> optional) {
    @Nullable DefaultConverter.State value = optional.orElse(null);
    if (this.parent == value) return this;
    return new ImmutableState(this, value, this.bpSeq, this.level);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DefaultConverter.State#bpSeq() bpSeq} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bpSeq
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableState withBpSeq(BpSeq value) {
    if (this.bpSeq == value) return this;
    BpSeq newValue = Objects.requireNonNull(value, "bpSeq");
    return new ImmutableState(this, this.parent, newValue, this.level);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DefaultConverter.State#level() level} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for level
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableState withLevel(int value) {
    if (this.level == value) return this;
    return new ImmutableState(this, this.parent, this.bpSeq, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableState} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableState
        && equalTo((ImmutableState) another);
  }

  private boolean equalTo(ImmutableState another) {
    return Objects.equals(parent, another.parent)
        && bpSeq.equals(another.bpSeq)
        && level == another.level;
  }

  /**
   * Computes a hash code from attributes: {@code parent}, {@code bpSeq}, {@code level}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(parent);
    h += (h << 5) + bpSeq.hashCode();
    h += (h << 5) + level;
    return h;
  }

  /**
   * Prints the immutable value {@code State} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("State{");
    if (parent != null) {
      builder.append("parent=").append(parent);
    }
    if (builder.length() > 6) builder.append(", ");
    builder.append("bpSeq=").append(bpSeq);
    builder.append(", ");
    builder.append("level=").append(level);
    return builder.append("}").toString();
  }

  private transient volatile long lazyInitBitmap;

  private static final long SCORE_LAZY_INIT_BIT = 0x1L;

  private transient int score;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link DefaultConverter.State#score() score} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code score} attribute
   */
  @Override
  public int score() {
    if ((lazyInitBitmap & SCORE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SCORE_LAZY_INIT_BIT) == 0) {
          this.score = super.score();
          lazyInitBitmap |= SCORE_LAZY_INIT_BIT;
        }
      }
    }
    return score;
  }

  /**
   * Construct a new immutable {@code State} instance.
   * @param parent The value for the {@code parent} attribute
   * @param bpSeq The value for the {@code bpSeq} attribute
   * @param level The value for the {@code level} attribute
   * @return An immutable State instance
   */
  public static ImmutableState of(Optional<? extends DefaultConverter.State> parent, BpSeq bpSeq, int level) {
    return new ImmutableState(parent, bpSeq, level);
  }

  /**
   * Creates an immutable copy of a {@link DefaultConverter.State} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable State instance
   */
  public static ImmutableState copyOf(DefaultConverter.State instance) {
    if (instance instanceof ImmutableState) {
      return (ImmutableState) instance;
    }
    return ImmutableState.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableState ImmutableState}.
   * <pre>
   * ImmutableState.builder()
   *    .parent(pl.poznan.put.structure.formats.DefaultConverter.State) // optional {@link DefaultConverter.State#parent() parent}
   *    .bpSeq(pl.poznan.put.structure.formats.BpSeq) // required {@link DefaultConverter.State#bpSeq() bpSeq}
   *    .level(int) // required {@link DefaultConverter.State#level() level}
   *    .build();
   * </pre>
   * @return A new ImmutableState builder
   */
  public static ImmutableState.Builder builder() {
    return new ImmutableState.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableState ImmutableState}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DefaultConverter.State", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_BP_SEQ = 0x1L;
    private static final long INIT_BIT_LEVEL = 0x2L;
    private long initBits = 0x3L;

    private @Nullable DefaultConverter.State parent;
    private @Nullable BpSeq bpSeq;
    private int level;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code State} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DefaultConverter.State instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<DefaultConverter.State> parentOptional = instance.parent();
      if (parentOptional.isPresent()) {
        parent(parentOptional);
      }
      bpSeq(instance.bpSeq());
      level(instance.level());
      return this;
    }

    /**
     * Initializes the optional value {@link DefaultConverter.State#parent() parent} to parent.
     * @param parent The value for parent
     * @return {@code this} builder for chained invocation
     */
    public final Builder parent(DefaultConverter.State parent) {
      this.parent = Objects.requireNonNull(parent, "parent");
      return this;
    }

    /**
     * Initializes the optional value {@link DefaultConverter.State#parent() parent} to parent.
     * @param parent The value for parent
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parent(Optional<? extends DefaultConverter.State> parent) {
      this.parent = parent.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultConverter.State#bpSeq() bpSeq} attribute.
     * @param bpSeq The value for bpSeq 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bpSeq(BpSeq bpSeq) {
      this.bpSeq = Objects.requireNonNull(bpSeq, "bpSeq");
      initBits &= ~INIT_BIT_BP_SEQ;
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultConverter.State#level() level} attribute.
     * @param level The value for level 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder level(int level) {
      this.level = level;
      initBits &= ~INIT_BIT_LEVEL;
      return this;
    }

    /**
     * Builds a new {@link ImmutableState ImmutableState}.
     * @return An immutable instance of State
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableState build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableState(null, parent, bpSeq, level);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BP_SEQ) != 0) attributes.add("bpSeq");
      if ((initBits & INIT_BIT_LEVEL) != 0) attributes.add("level");
      return "Cannot build State, some of required attributes are not set " + attributes;
    }
  }
}
