package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.structure.ClassifiedBasePair;

/**
 * Immutable implementation of {@link MultiLineDotBracket}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMultiLineDotBracket.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableMultiLineDotBracket.of()}.
 */
@Generated(from = "MultiLineDotBracket", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableMultiLineDotBracket extends MultiLineDotBracket {
  private final String sequence;
  private final Collection<? extends ClassifiedBasePair> basePairs;

  private ImmutableMultiLineDotBracket(
      String sequence,
      Collection<? extends ClassifiedBasePair> basePairs) {
    this.sequence = Objects.requireNonNull(sequence, "sequence");
    this.basePairs = Objects.requireNonNull(basePairs, "basePairs");
  }

  private ImmutableMultiLineDotBracket(
      ImmutableMultiLineDotBracket original,
      String sequence,
      Collection<? extends ClassifiedBasePair> basePairs) {
    this.sequence = sequence;
    this.basePairs = basePairs;
  }

  /**
   *@return The sequence of nucleotides. 
   */
  @Override
  public String sequence() {
    return sequence;
  }

  /**
   *@return The list of base pairs. 
   */
  @Override
  public Collection<? extends ClassifiedBasePair> basePairs() {
    return basePairs;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MultiLineDotBracket#sequence() sequence} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sequence
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMultiLineDotBracket withSequence(String value) {
    String newValue = Objects.requireNonNull(value, "sequence");
    if (this.sequence.equals(newValue)) return this;
    return new ImmutableMultiLineDotBracket(this, newValue, this.basePairs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MultiLineDotBracket#basePairs() basePairs} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for basePairs
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMultiLineDotBracket withBasePairs(Collection<? extends ClassifiedBasePair> value) {
    if (this.basePairs == value) return this;
    Collection<? extends ClassifiedBasePair> newValue = Objects.requireNonNull(value, "basePairs");
    return new ImmutableMultiLineDotBracket(this, this.sequence, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMultiLineDotBracket} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMultiLineDotBracket
        && equalTo((ImmutableMultiLineDotBracket) another);
  }

  private boolean equalTo(ImmutableMultiLineDotBracket another) {
    return sequence.equals(another.sequence)
        && basePairs.equals(another.basePairs);
  }

  /**
   * Computes a hash code from attributes: {@code sequence}, {@code basePairs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + sequence.hashCode();
    h += (h << 5) + basePairs.hashCode();
    return h;
  }

  private transient volatile long lazyInitBitmap;

  private static final long BASE_PAIRS5TO3_LAZY_INIT_BIT = 0x1L;

  private transient Collection<ClassifiedBasePair> basePairs5to3;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link MultiLineDotBracket#basePairs5to3() basePairs5to3} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code basePairs5to3} attribute
   */
  @Override
  protected Collection<ClassifiedBasePair> basePairs5to3() {
    if ((lazyInitBitmap & BASE_PAIRS5TO3_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & BASE_PAIRS5TO3_LAZY_INIT_BIT) == 0) {
          this.basePairs5to3 = Objects.requireNonNull(super.basePairs5to3(), "basePairs5to3");
          lazyInitBitmap |= BASE_PAIRS5TO3_LAZY_INIT_BIT;
        }
      }
    }
    return basePairs5to3;
  }

  /**
   * Construct a new immutable {@code MultiLineDotBracket} instance.
   * @param sequence The value for the {@code sequence} attribute
   * @param basePairs The value for the {@code basePairs} attribute
   * @return An immutable MultiLineDotBracket instance
   */
  public static ImmutableMultiLineDotBracket of(String sequence, Collection<? extends ClassifiedBasePair> basePairs) {
    return new ImmutableMultiLineDotBracket(sequence, basePairs);
  }

  /**
   * Creates an immutable copy of a {@link MultiLineDotBracket} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MultiLineDotBracket instance
   */
  public static ImmutableMultiLineDotBracket copyOf(MultiLineDotBracket instance) {
    if (instance instanceof ImmutableMultiLineDotBracket) {
      return (ImmutableMultiLineDotBracket) instance;
    }
    return ImmutableMultiLineDotBracket.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMultiLineDotBracket ImmutableMultiLineDotBracket}.
   * <pre>
   * ImmutableMultiLineDotBracket.builder()
   *    .sequence(String) // required {@link MultiLineDotBracket#sequence() sequence}
   *    .basePairs(Collection&amp;lt;? extends pl.poznan.put.structure.ClassifiedBasePair&amp;gt;) // required {@link MultiLineDotBracket#basePairs() basePairs}
   *    .build();
   * </pre>
   * @return A new ImmutableMultiLineDotBracket builder
   */
  public static ImmutableMultiLineDotBracket.Builder builder() {
    return new ImmutableMultiLineDotBracket.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMultiLineDotBracket ImmutableMultiLineDotBracket}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MultiLineDotBracket", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SEQUENCE = 0x1L;
    private static final long INIT_BIT_BASE_PAIRS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String sequence;
    private @Nullable Collection<? extends ClassifiedBasePair> basePairs;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MultiLineDotBracket} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MultiLineDotBracket instance) {
      Objects.requireNonNull(instance, "instance");
      sequence(instance.sequence());
      basePairs(instance.basePairs());
      return this;
    }

    /**
     * Initializes the value for the {@link MultiLineDotBracket#sequence() sequence} attribute.
     * @param sequence The value for sequence 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sequence(String sequence) {
      this.sequence = Objects.requireNonNull(sequence, "sequence");
      initBits &= ~INIT_BIT_SEQUENCE;
      return this;
    }

    /**
     * Initializes the value for the {@link MultiLineDotBracket#basePairs() basePairs} attribute.
     * @param basePairs The value for basePairs 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder basePairs(Collection<? extends ClassifiedBasePair> basePairs) {
      this.basePairs = Objects.requireNonNull(basePairs, "basePairs");
      initBits &= ~INIT_BIT_BASE_PAIRS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMultiLineDotBracket ImmutableMultiLineDotBracket}.
     * @return An immutable instance of MultiLineDotBracket
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMultiLineDotBracket build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMultiLineDotBracket(null, sequence, basePairs);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SEQUENCE) != 0) attributes.add("sequence");
      if ((initBits & INIT_BIT_BASE_PAIRS) != 0) attributes.add("basePairs");
      return "Cannot build MultiLineDotBracket, some of required attributes are not set " + attributes;
    }
  }
}
