package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link BpSeq.Entry}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEntry.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableEntry.of()}.
 */
@Generated(from = "BpSeq.Entry", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableEntry extends BpSeq.Entry {
  private final int index;
  private final char seq;
  private final int pair;
  private final String comment;

  private ImmutableEntry(int index, char seq, int pair) {
    this.index = index;
    this.seq = seq;
    this.pair = pair;
    this.comment = Objects.requireNonNull(super.comment(), "comment");
  }

  private ImmutableEntry(ImmutableEntry.Builder builder) {
    this.index = builder.index;
    this.seq = builder.seq;
    this.pair = builder.pair;
    this.comment = builder.comment != null
        ? builder.comment
        : Objects.requireNonNull(super.comment(), "comment");
  }

  private ImmutableEntry(int index, char seq, int pair, String comment) {
    this.index = index;
    this.seq = seq;
    this.pair = pair;
    this.comment = comment;
  }

  /**
   *@return The value of index column. 
   */
  @Override
  public int index() {
    return index;
  }

  /**
   *@return The value of sequence column. 
   */
  @Override
  public char seq() {
    return seq;
  }

  /**
   *@return The value of pair column. 
   */
  @Override
  public int pair() {
    return pair;
  }

  /**
   *@return The optional comment. 
   */
  @Override
  public String comment() {
    return comment;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BpSeq.Entry#index() index} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for index
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEntry withIndex(int value) {
    if (this.index == value) return this;
    return new ImmutableEntry(value, this.seq, this.pair, this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BpSeq.Entry#seq() seq} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for seq
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEntry withSeq(char value) {
    if (this.seq == value) return this;
    return new ImmutableEntry(this.index, value, this.pair, this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BpSeq.Entry#pair() pair} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pair
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEntry withPair(int value) {
    if (this.pair == value) return this;
    return new ImmutableEntry(this.index, this.seq, value, this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BpSeq.Entry#comment() comment} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for comment
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEntry withComment(String value) {
    String newValue = Objects.requireNonNull(value, "comment");
    if (this.comment.equals(newValue)) return this;
    return new ImmutableEntry(this.index, this.seq, this.pair, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEntry} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEntry
        && equalTo((ImmutableEntry) another);
  }

  private boolean equalTo(ImmutableEntry another) {
    return index == another.index
        && seq == another.seq
        && pair == another.pair
        && comment.equals(another.comment);
  }

  /**
   * Computes a hash code from attributes: {@code index}, {@code seq}, {@code pair}, {@code comment}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + index;
    h += (h << 5) + Character.hashCode(seq);
    h += (h << 5) + pair;
    h += (h << 5) + comment.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code Entry} instance.
   * @param index The value for the {@code index} attribute
   * @param seq The value for the {@code seq} attribute
   * @param pair The value for the {@code pair} attribute
   * @return An immutable Entry instance
   */
  public static ImmutableEntry of(int index, char seq, int pair) {
    return new ImmutableEntry(index, seq, pair);
  }

  /**
   * Creates an immutable copy of a {@link BpSeq.Entry} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Entry instance
   */
  public static ImmutableEntry copyOf(BpSeq.Entry instance) {
    if (instance instanceof ImmutableEntry) {
      return (ImmutableEntry) instance;
    }
    return ImmutableEntry.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEntry ImmutableEntry}.
   * <pre>
   * ImmutableEntry.builder()
   *    .index(int) // required {@link BpSeq.Entry#index() index}
   *    .seq(char) // required {@link BpSeq.Entry#seq() seq}
   *    .pair(int) // required {@link BpSeq.Entry#pair() pair}
   *    .comment(String) // optional {@link BpSeq.Entry#comment() comment}
   *    .build();
   * </pre>
   * @return A new ImmutableEntry builder
   */
  public static ImmutableEntry.Builder builder() {
    return new ImmutableEntry.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEntry ImmutableEntry}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BpSeq.Entry", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_INDEX = 0x1L;
    private static final long INIT_BIT_SEQ = 0x2L;
    private static final long INIT_BIT_PAIR = 0x4L;
    private long initBits = 0x7L;

    private int index;
    private char seq;
    private int pair;
    private @Nullable String comment;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Entry} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BpSeq.Entry instance) {
      Objects.requireNonNull(instance, "instance");
      index(instance.index());
      seq(instance.seq());
      pair(instance.pair());
      comment(instance.comment());
      return this;
    }

    /**
     * Initializes the value for the {@link BpSeq.Entry#index() index} attribute.
     * @param index The value for index 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder index(int index) {
      this.index = index;
      initBits &= ~INIT_BIT_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link BpSeq.Entry#seq() seq} attribute.
     * @param seq The value for seq 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder seq(char seq) {
      this.seq = seq;
      initBits &= ~INIT_BIT_SEQ;
      return this;
    }

    /**
     * Initializes the value for the {@link BpSeq.Entry#pair() pair} attribute.
     * @param pair The value for pair 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder pair(int pair) {
      this.pair = pair;
      initBits &= ~INIT_BIT_PAIR;
      return this;
    }

    /**
     * Initializes the value for the {@link BpSeq.Entry#comment() comment} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link BpSeq.Entry#comment() comment}.</em>
     * @param comment The value for comment 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder comment(String comment) {
      this.comment = Objects.requireNonNull(comment, "comment");
      return this;
    }

    /**
     * Builds a new {@link ImmutableEntry ImmutableEntry}.
     * @return An immutable instance of Entry
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEntry build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEntry(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_INDEX) != 0) attributes.add("index");
      if ((initBits & INIT_BIT_SEQ) != 0) attributes.add("seq");
      if ((initBits & INIT_BIT_PAIR) != 0) attributes.add("pair");
      return "Cannot build Entry, some of required attributes are not set " + attributes;
    }
  }
}
