package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.structure.DotBracketSymbol;

/**
 * Immutable implementation of {@link DefaultStrand}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDefaultStrand.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDefaultStrand.of()}.
 */
@Generated(from = "DefaultStrand", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableDefaultStrand extends DefaultStrand {
  private final List<DotBracket> combineStrands;
  private final String name;
  private final List<DotBracketSymbol> symbols;

  private ImmutableDefaultStrand(String name, Iterable<? extends DotBracketSymbol> symbols) {
    this.name = Objects.requireNonNull(name, "name");
    this.symbols = createUnmodifiableList(false, createSafeList(symbols, true, false));
    this.combineStrands = Collections.emptyList();
  }

  private ImmutableDefaultStrand(
      List<DotBracket> combineStrands,
      String name,
      List<DotBracketSymbol> symbols) {
    this.combineStrands = combineStrands;
    this.name = name;
    this.symbols = symbols;
  }

  /**
   * Combines strands which share a base pair into a new dot-bracket instance and returns a list of
   * those.
   * @return The list of dot-bracket instances, each containing strands which only pair with each
   *     other.
   */
  @Override
  public List<DotBracket> combineStrands() {
    return combineStrands;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code symbols} attribute
   */
  @Override
  public List<DotBracketSymbol> symbols() {
    return symbols;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DefaultStrand#combineStrands() combineStrands}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefaultStrand withCombineStrands(DotBracket... elements) {
    List<DotBracket> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableDefaultStrand(newValue, this.name, this.symbols);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DefaultStrand#combineStrands() combineStrands}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of combineStrands elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefaultStrand withCombineStrands(Iterable<? extends DotBracket> elements) {
    if (this.combineStrands == elements) return this;
    List<DotBracket> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableDefaultStrand(newValue, this.name, this.symbols);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DefaultStrand#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDefaultStrand withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableDefaultStrand(this.combineStrands, newValue, this.symbols);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DefaultStrand#symbols() symbols}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefaultStrand withSymbols(DotBracketSymbol... elements) {
    List<DotBracketSymbol> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableDefaultStrand(this.combineStrands, this.name, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DefaultStrand#symbols() symbols}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of symbols elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefaultStrand withSymbols(Iterable<? extends DotBracketSymbol> elements) {
    if (this.symbols == elements) return this;
    List<DotBracketSymbol> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableDefaultStrand(this.combineStrands, this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDefaultStrand} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDefaultStrand
        && equalTo((ImmutableDefaultStrand) another);
  }

  private boolean equalTo(ImmutableDefaultStrand another) {
    return combineStrands.equals(another.combineStrands)
        && name.equals(another.name)
        && symbols.equals(another.symbols);
  }

  /**
   * Computes a hash code from attributes: {@code combineStrands}, {@code name}, {@code symbols}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + combineStrands.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + symbols.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code DefaultStrand} instance.
   * @param name The value for the {@code name} attribute
   * @param symbols The value for the {@code symbols} attribute
   * @return An immutable DefaultStrand instance
   */
  public static ImmutableDefaultStrand of(String name, List<DotBracketSymbol> symbols) {
    return of(name, (Iterable<? extends DotBracketSymbol>) symbols);
  }

  /**
   * Construct a new immutable {@code DefaultStrand} instance.
   * @param name The value for the {@code name} attribute
   * @param symbols The value for the {@code symbols} attribute
   * @return An immutable DefaultStrand instance
   */
  public static ImmutableDefaultStrand of(String name, Iterable<? extends DotBracketSymbol> symbols) {
    return new ImmutableDefaultStrand(name, symbols);
  }

  /**
   * Creates an immutable copy of a {@link DefaultStrand} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DefaultStrand instance
   */
  public static ImmutableDefaultStrand copyOf(DefaultStrand instance) {
    if (instance instanceof ImmutableDefaultStrand) {
      return (ImmutableDefaultStrand) instance;
    }
    return ImmutableDefaultStrand.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDefaultStrand ImmutableDefaultStrand}.
   * <pre>
   * ImmutableDefaultStrand.builder()
   *    .addCombineStrands|addAllCombineStrands(pl.poznan.put.structure.formats.DotBracket) // {@link DefaultStrand#combineStrands() combineStrands} elements
   *    .name(String) // required {@link DefaultStrand#name() name}
   *    .addSymbols|addAllSymbols(pl.poznan.put.structure.DotBracketSymbol) // {@link DefaultStrand#symbols() symbols} elements
   *    .build();
   * </pre>
   * @return A new ImmutableDefaultStrand builder
   */
  public static ImmutableDefaultStrand.Builder builder() {
    return new ImmutableDefaultStrand.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDefaultStrand ImmutableDefaultStrand}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DefaultStrand", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private List<DotBracket> combineStrands = new ArrayList<DotBracket>();
    private @Nullable String name;
    private List<DotBracketSymbol> symbols = new ArrayList<DotBracketSymbol>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.structure.formats.DefaultStrand} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DefaultStrand instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.structure.formats.DotBracket} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DotBracket instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.structure.formats.Strand} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Strand instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof DefaultStrand) {
        DefaultStrand instance = (DefaultStrand) object;
        if ((bits & 0x1L) == 0) {
          name(instance.name());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          addAllSymbols(instance.symbols());
          bits |= 0x2L;
        }
      }
      if (object instanceof DotBracket) {
        DotBracket instance = (DotBracket) object;
        addAllCombineStrands(instance.combineStrands());
        if ((bits & 0x2L) == 0) {
          addAllSymbols(instance.symbols());
          bits |= 0x2L;
        }
      }
      if (object instanceof Strand) {
        Strand instance = (Strand) object;
        if ((bits & 0x1L) == 0) {
          name(instance.name());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Adds one element to {@link DefaultStrand#combineStrands() combineStrands} list.
     * @param element A combineStrands element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCombineStrands(DotBracket element) {
      this.combineStrands.add(Objects.requireNonNull(element, "combineStrands element"));
      return this;
    }

    /**
     * Adds elements to {@link DefaultStrand#combineStrands() combineStrands} list.
     * @param elements An array of combineStrands elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCombineStrands(DotBracket... elements) {
      for (DotBracket element : elements) {
        this.combineStrands.add(Objects.requireNonNull(element, "combineStrands element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DefaultStrand#combineStrands() combineStrands} list.
     * @param elements An iterable of combineStrands elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder combineStrands(Iterable<? extends DotBracket> elements) {
      this.combineStrands.clear();
      return addAllCombineStrands(elements);
    }

    /**
     * Adds elements to {@link DefaultStrand#combineStrands() combineStrands} list.
     * @param elements An iterable of combineStrands elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllCombineStrands(Iterable<? extends DotBracket> elements) {
      for (DotBracket element : elements) {
        this.combineStrands.add(Objects.requireNonNull(element, "combineStrands element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultStrand#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link DefaultStrand#symbols() symbols} list.
     * @param element A symbols element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSymbols(DotBracketSymbol element) {
      this.symbols.add(Objects.requireNonNull(element, "symbols element"));
      return this;
    }

    /**
     * Adds elements to {@link DefaultStrand#symbols() symbols} list.
     * @param elements An array of symbols elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSymbols(DotBracketSymbol... elements) {
      for (DotBracketSymbol element : elements) {
        this.symbols.add(Objects.requireNonNull(element, "symbols element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DefaultStrand#symbols() symbols} list.
     * @param elements An iterable of symbols elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder symbols(Iterable<? extends DotBracketSymbol> elements) {
      this.symbols.clear();
      return addAllSymbols(elements);
    }

    /**
     * Adds elements to {@link DefaultStrand#symbols() symbols} list.
     * @param elements An iterable of symbols elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSymbols(Iterable<? extends DotBracketSymbol> elements) {
      for (DotBracketSymbol element : elements) {
        this.symbols.add(Objects.requireNonNull(element, "symbols element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableDefaultStrand ImmutableDefaultStrand}.
     * @return An immutable instance of DefaultStrand
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDefaultStrand build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDefaultStrand(createUnmodifiableList(true, combineStrands), name, createUnmodifiableList(true, symbols));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build DefaultStrand, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
