package pl.poznan.put.structure.formats;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.structure.DotBracketSymbol;

/**
 * Immutable implementation of {@link DefaultDotBracket}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDefaultDotBracket.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDefaultDotBracket.of()}.
 */
@Generated(from = "DefaultDotBracket", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableDefaultDotBracket extends DefaultDotBracket {
  private final List<Strand> strands;
  private final String sequence;
  private final String structure;

  private ImmutableDefaultDotBracket(String sequence, String structure) {
    this.sequence = Objects.requireNonNull(sequence, "sequence");
    this.structure = Objects.requireNonNull(structure, "structure");
    this.strands = createUnmodifiableList(false, createSafeList(super.strands(), true, false));
  }

  private ImmutableDefaultDotBracket(ImmutableDefaultDotBracket.Builder builder) {
    this.sequence = builder.sequence;
    this.structure = builder.structure;
    this.strands = builder.strandsIsSet()
        ? createUnmodifiableList(true, builder.strands)
        : createUnmodifiableList(false, createSafeList(super.strands(), true, false));
  }

  private ImmutableDefaultDotBracket(
      List<Strand> strands,
      String sequence,
      String structure) {
    this.strands = strands;
    this.sequence = sequence;
    this.structure = structure;
  }

  /**
   * @return The value of the {@code strands} attribute
   */
  @Override
  public List<Strand> strands() {
    return strands;
  }

  /**
   * @return The value of the {@code sequence} attribute
   */
  @Override
  public String sequence() {
    return sequence;
  }

  /**
   * @return The value of the {@code structure} attribute
   */
  @Override
  public String structure() {
    return structure;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DefaultDotBracket#strands() strands}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefaultDotBracket withStrands(Strand... elements) {
    List<Strand> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableDefaultDotBracket(newValue, this.sequence, this.structure));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DefaultDotBracket#strands() strands}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of strands elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefaultDotBracket withStrands(Iterable<? extends Strand> elements) {
    if (this.strands == elements) return this;
    List<Strand> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableDefaultDotBracket(newValue, this.sequence, this.structure));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DefaultDotBracket#sequence() sequence} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sequence
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDefaultDotBracket withSequence(String value) {
    String newValue = Objects.requireNonNull(value, "sequence");
    if (this.sequence.equals(newValue)) return this;
    return validate(new ImmutableDefaultDotBracket(this.strands, newValue, this.structure));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DefaultDotBracket#structure() structure} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for structure
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDefaultDotBracket withStructure(String value) {
    String newValue = Objects.requireNonNull(value, "structure");
    if (this.structure.equals(newValue)) return this;
    return validate(new ImmutableDefaultDotBracket(this.strands, this.sequence, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDefaultDotBracket} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDefaultDotBracket
        && equalTo((ImmutableDefaultDotBracket) another);
  }

  private boolean equalTo(ImmutableDefaultDotBracket another) {
    return sequence.equals(another.sequence)
        && structure.equals(another.structure);
  }

  /**
   * Computes a hash code from attributes: {@code sequence}, {@code structure}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + sequence.hashCode();
    h += (h << 5) + structure.hashCode();
    return h;
  }

  private transient volatile long lazyInitBitmap;

  private static final long PAIRS_LAZY_INIT_BIT = 0x1L;

  private transient Map<DotBracketSymbol, DotBracketSymbol> pairs;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link DefaultDotBracket#pairs() pairs} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code pairs} attribute
   */
  @Override
  public Map<DotBracketSymbol, DotBracketSymbol> pairs() {
    if ((lazyInitBitmap & PAIRS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & PAIRS_LAZY_INIT_BIT) == 0) {
          this.pairs = Objects.requireNonNull(super.pairs(), "pairs");
          lazyInitBitmap |= PAIRS_LAZY_INIT_BIT;
        }
      }
    }
    return pairs;
  }

  /**
   * Construct a new immutable {@code DefaultDotBracket} instance.
   * @param sequence The value for the {@code sequence} attribute
   * @param structure The value for the {@code structure} attribute
   * @return An immutable DefaultDotBracket instance
   */
  public static ImmutableDefaultDotBracket of(String sequence, String structure) {
    return validate(new ImmutableDefaultDotBracket(sequence, structure));
  }

  private static ImmutableDefaultDotBracket validate(ImmutableDefaultDotBracket instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link DefaultDotBracket} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DefaultDotBracket instance
   */
  public static ImmutableDefaultDotBracket copyOf(DefaultDotBracket instance) {
    if (instance instanceof ImmutableDefaultDotBracket) {
      return (ImmutableDefaultDotBracket) instance;
    }
    return ImmutableDefaultDotBracket.builder()
        .from(instance)
        .build();
  }

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link ImmutableDefaultDotBracket ImmutableDefaultDotBracket}.
   * <pre>
   * ImmutableDefaultDotBracket.builder()
   *    .addStrands|addAllStrands(pl.poznan.put.structure.formats.Strand) // {@link DefaultDotBracket#strands() strands} elements
   *    .sequence(String) // required {@link DefaultDotBracket#sequence() sequence}
   *    .structure(String) // required {@link DefaultDotBracket#structure() structure}
   *    .build();
   * </pre>
   * @return A new ImmutableDefaultDotBracket builder
   */
  public static ImmutableDefaultDotBracket.Builder builder() {
    return new ImmutableDefaultDotBracket.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDefaultDotBracket ImmutableDefaultDotBracket}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DefaultDotBracket", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SEQUENCE = 0x1L;
    private static final long INIT_BIT_STRUCTURE = 0x2L;
    private static final long OPT_BIT_STRANDS = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private List<Strand> strands = new ArrayList<Strand>();
    private @Nullable String sequence;
    private @Nullable String structure;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.structure.formats.DefaultDotBracket} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DefaultDotBracket instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.structure.formats.DotBracket} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DotBracket instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof DefaultDotBracket) {
        DefaultDotBracket instance = (DefaultDotBracket) object;
        if ((bits & 0x1L) == 0) {
          sequence(instance.sequence());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          structure(instance.structure());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          addAllStrands(instance.strands());
          bits |= 0x4L;
        }
      }
      if (object instanceof DotBracket) {
        DotBracket instance = (DotBracket) object;
        if ((bits & 0x1L) == 0) {
          sequence(instance.sequence());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          structure(instance.structure());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          addAllStrands(instance.strands());
          bits |= 0x4L;
        }
      }
    }

    /**
     * Adds one element to {@link DefaultDotBracket#strands() strands} list.
     * @param element A strands element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addStrands(Strand element) {
      this.strands.add(Objects.requireNonNull(element, "strands element"));
      optBits |= OPT_BIT_STRANDS;
      return this;
    }

    /**
     * Adds elements to {@link DefaultDotBracket#strands() strands} list.
     * @param elements An array of strands elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addStrands(Strand... elements) {
      for (Strand element : elements) {
        this.strands.add(Objects.requireNonNull(element, "strands element"));
      }
      optBits |= OPT_BIT_STRANDS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DefaultDotBracket#strands() strands} list.
     * @param elements An iterable of strands elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder strands(Iterable<? extends Strand> elements) {
      this.strands.clear();
      return addAllStrands(elements);
    }

    /**
     * Adds elements to {@link DefaultDotBracket#strands() strands} list.
     * @param elements An iterable of strands elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStrands(Iterable<? extends Strand> elements) {
      for (Strand element : elements) {
        this.strands.add(Objects.requireNonNull(element, "strands element"));
      }
      optBits |= OPT_BIT_STRANDS;
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultDotBracket#sequence() sequence} attribute.
     * @param sequence The value for sequence 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sequence(String sequence) {
      this.sequence = Objects.requireNonNull(sequence, "sequence");
      initBits &= ~INIT_BIT_SEQUENCE;
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultDotBracket#structure() structure} attribute.
     * @param structure The value for structure 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder structure(String structure) {
      this.structure = Objects.requireNonNull(structure, "structure");
      initBits &= ~INIT_BIT_STRUCTURE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDefaultDotBracket ImmutableDefaultDotBracket}.
     * @return An immutable instance of DefaultDotBracket
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDefaultDotBracket build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableDefaultDotBracket.validate(new ImmutableDefaultDotBracket(this));
    }

    private boolean strandsIsSet() {
      return (optBits & OPT_BIT_STRANDS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SEQUENCE) != 0) attributes.add("sequence");
      if ((initBits & INIT_BIT_STRUCTURE) != 0) attributes.add("structure");
      return "Cannot build DefaultDotBracket, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
