package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.structure.pseudoknots.PseudoknotFinder;

/**
 * Immutable implementation of {@link DefaultConverter}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDefaultConverter.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableDefaultConverter.of()}.
 */
@Generated(from = "DefaultConverter", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableDefaultConverter extends DefaultConverter {
  private final PseudoknotFinder pseudoknotFinder;
  private final int maxSolutions;

  private ImmutableDefaultConverter() {
    this.pseudoknotFinder = initShim.pseudoknotFinder();
    this.maxSolutions = initShim.maxSolutions();
    this.initShim = null;
  }

  private ImmutableDefaultConverter(ImmutableDefaultConverter.Builder builder) {
    if (builder.pseudoknotFinder != null) {
      initShim.pseudoknotFinder(builder.pseudoknotFinder);
    }
    if (builder.maxSolutionsIsSet()) {
      initShim.maxSolutions(builder.maxSolutions);
    }
    this.pseudoknotFinder = initShim.pseudoknotFinder();
    this.maxSolutions = initShim.maxSolutions();
    this.initShim = null;
  }

  private ImmutableDefaultConverter(PseudoknotFinder pseudoknotFinder, int maxSolutions) {
    this.pseudoknotFinder = pseudoknotFinder;
    this.maxSolutions = maxSolutions;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "DefaultConverter", generator = "Immutables")
  private final class InitShim {
    private byte pseudoknotFinderBuildStage = STAGE_UNINITIALIZED;
    private PseudoknotFinder pseudoknotFinder;

    PseudoknotFinder pseudoknotFinder() {
      if (pseudoknotFinderBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (pseudoknotFinderBuildStage == STAGE_UNINITIALIZED) {
        pseudoknotFinderBuildStage = STAGE_INITIALIZING;
        this.pseudoknotFinder = Objects.requireNonNull(ImmutableDefaultConverter.super.pseudoknotFinder(), "pseudoknotFinder");
        pseudoknotFinderBuildStage = STAGE_INITIALIZED;
      }
      return this.pseudoknotFinder;
    }

    void pseudoknotFinder(PseudoknotFinder pseudoknotFinder) {
      this.pseudoknotFinder = pseudoknotFinder;
      pseudoknotFinderBuildStage = STAGE_INITIALIZED;
    }

    private byte maxSolutionsBuildStage = STAGE_UNINITIALIZED;
    private int maxSolutions;

    int maxSolutions() {
      if (maxSolutionsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maxSolutionsBuildStage == STAGE_UNINITIALIZED) {
        maxSolutionsBuildStage = STAGE_INITIALIZING;
        this.maxSolutions = ImmutableDefaultConverter.super.maxSolutions();
        maxSolutionsBuildStage = STAGE_INITIALIZED;
      }
      return this.maxSolutions;
    }

    void maxSolutions(int maxSolutions) {
      this.maxSolutions = maxSolutions;
      maxSolutionsBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (pseudoknotFinderBuildStage == STAGE_INITIALIZING) attributes.add("pseudoknotFinder");
      if (maxSolutionsBuildStage == STAGE_INITIALIZING) attributes.add("maxSolutions");
      return "Cannot build DefaultConverter, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The finder of pseudoknots ({@link
   *     pl.poznan.put.structure.pseudoknots.elimination.MinGain} by default).
   */
  @Override
  public PseudoknotFinder pseudoknotFinder() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.pseudoknotFinder()
        : this.pseudoknotFinder;
  }

  /**
   *@return The number of solutions to return (1 by default). 
   */
  @Override
  public int maxSolutions() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.maxSolutions()
        : this.maxSolutions;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DefaultConverter#pseudoknotFinder() pseudoknotFinder} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pseudoknotFinder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDefaultConverter withPseudoknotFinder(PseudoknotFinder value) {
    if (this.pseudoknotFinder == value) return this;
    PseudoknotFinder newValue = Objects.requireNonNull(value, "pseudoknotFinder");
    return validate(new ImmutableDefaultConverter(newValue, this.maxSolutions));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DefaultConverter#maxSolutions() maxSolutions} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxSolutions
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDefaultConverter withMaxSolutions(int value) {
    if (this.maxSolutions == value) return this;
    return validate(new ImmutableDefaultConverter(this.pseudoknotFinder, value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDefaultConverter} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDefaultConverter
        && equalTo((ImmutableDefaultConverter) another);
  }

  private boolean equalTo(ImmutableDefaultConverter another) {
    return pseudoknotFinder.equals(another.pseudoknotFinder)
        && maxSolutions == another.maxSolutions;
  }

  /**
   * Computes a hash code from attributes: {@code pseudoknotFinder}, {@code maxSolutions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + pseudoknotFinder.hashCode();
    h += (h << 5) + maxSolutions;
    return h;
  }

  /**
   * Prints the immutable value {@code DefaultConverter} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DefaultConverter{"
        + "pseudoknotFinder=" + pseudoknotFinder
        + ", maxSolutions=" + maxSolutions
        + "}";
  }

  private static final ImmutableDefaultConverter INSTANCE = validate(new ImmutableDefaultConverter());

  /**
   * Returns the default immutable singleton value of {@code DefaultConverter}
   * @return An immutable instance of DefaultConverter
   */
  public static ImmutableDefaultConverter of() {
    return INSTANCE;
  }

  private static ImmutableDefaultConverter validate(ImmutableDefaultConverter instance) {
    return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link DefaultConverter} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DefaultConverter instance
   */
  public static ImmutableDefaultConverter copyOf(DefaultConverter instance) {
    if (instance instanceof ImmutableDefaultConverter) {
      return (ImmutableDefaultConverter) instance;
    }
    return ImmutableDefaultConverter.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDefaultConverter ImmutableDefaultConverter}.
   * <pre>
   * ImmutableDefaultConverter.builder()
   *    .pseudoknotFinder(pl.poznan.put.structure.pseudoknots.PseudoknotFinder) // optional {@link DefaultConverter#pseudoknotFinder() pseudoknotFinder}
   *    .maxSolutions(int) // optional {@link DefaultConverter#maxSolutions() maxSolutions}
   *    .build();
   * </pre>
   * @return A new ImmutableDefaultConverter builder
   */
  public static ImmutableDefaultConverter.Builder builder() {
    return new ImmutableDefaultConverter.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDefaultConverter ImmutableDefaultConverter}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DefaultConverter", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_MAX_SOLUTIONS = 0x1L;
    private long optBits;

    private @Nullable PseudoknotFinder pseudoknotFinder;
    private int maxSolutions;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DefaultConverter} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DefaultConverter instance) {
      Objects.requireNonNull(instance, "instance");
      pseudoknotFinder(instance.pseudoknotFinder());
      maxSolutions(instance.maxSolutions());
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultConverter#pseudoknotFinder() pseudoknotFinder} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DefaultConverter#pseudoknotFinder() pseudoknotFinder}.</em>
     * @param pseudoknotFinder The value for pseudoknotFinder 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder pseudoknotFinder(PseudoknotFinder pseudoknotFinder) {
      this.pseudoknotFinder = Objects.requireNonNull(pseudoknotFinder, "pseudoknotFinder");
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultConverter#maxSolutions() maxSolutions} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DefaultConverter#maxSolutions() maxSolutions}.</em>
     * @param maxSolutions The value for maxSolutions 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder maxSolutions(int maxSolutions) {
      this.maxSolutions = maxSolutions;
      optBits |= OPT_BIT_MAX_SOLUTIONS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDefaultConverter ImmutableDefaultConverter}.
     * @return An immutable instance of DefaultConverter
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDefaultConverter build() {
      return ImmutableDefaultConverter.validate(new ImmutableDefaultConverter(this));
    }

    private boolean maxSolutionsIsSet() {
      return (optBits & OPT_BIT_MAX_SOLUTIONS) != 0;
    }
  }
}
