package pl.poznan.put.structure.formats;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Ct}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCt.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableCt.of()}.
 */
@Generated(from = "Ct", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableCt extends Ct {
  private final SortedSet<Ct.ExtendedEntry> entries;

  private ImmutableCt(Iterable<? extends Ct.ExtendedEntry> entries) {
    this.entries = createUnmodifiableSortedSet(false, createSafeList(entries, true, false));
  }

  private ImmutableCt(ImmutableCt original, SortedSet<Ct.ExtendedEntry> entries) {
    this.entries = entries;
  }

  /**
   *@return The list of CT entries. 
   */
  @Override
  public SortedSet<Ct.ExtendedEntry> entries() {
    return entries;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Ct#entries() entries}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCt withEntries(Ct.ExtendedEntry... elements) {
    SortedSet<Ct.ExtendedEntry> newValue = createUnmodifiableSortedSet(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableCt(this, newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Ct#entries() entries}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of entries elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCt withEntries(Iterable<? extends Ct.ExtendedEntry> elements) {
    if (this.entries == elements) return this;
    SortedSet<Ct.ExtendedEntry> newValue = createUnmodifiableSortedSet(false, createSafeList(elements, true, false));
    return validate(new ImmutableCt(this, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCt} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCt
        && equalTo((ImmutableCt) another);
  }

  private boolean equalTo(ImmutableCt another) {
    return entries.equals(another.entries);
  }

  /**
   * Computes a hash code from attributes: {@code entries}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + entries.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code Ct} instance.
   * @param entries The value for the {@code entries} attribute
   * @return An immutable Ct instance
   */
  public static ImmutableCt of(SortedSet<Ct.ExtendedEntry> entries) {
    return of((Iterable<? extends Ct.ExtendedEntry>) entries);
  }

  /**
   * Construct a new immutable {@code Ct} instance.
   * @param entries The value for the {@code entries} attribute
   * @return An immutable Ct instance
   */
  public static ImmutableCt of(Iterable<? extends Ct.ExtendedEntry> entries) {
    return validate(new ImmutableCt(entries));
  }

  private static ImmutableCt validate(ImmutableCt instance) {
    instance = (ImmutableCt) instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Ct} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Ct instance
   */
  public static ImmutableCt copyOf(Ct instance) {
    if (instance instanceof ImmutableCt) {
      return (ImmutableCt) instance;
    }
    return ImmutableCt.builder()
        .from(instance)
        .build();
  }

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link ImmutableCt ImmutableCt}.
   * <pre>
   * ImmutableCt.builder()
   *    .addEntries|addAllEntries(pl.poznan.put.structure.formats.Ct.ExtendedEntry) // {@link Ct#entries() entries} elements
   *    .build();
   * </pre>
   * @return A new ImmutableCt builder
   */
  public static ImmutableCt.Builder builder() {
    return new ImmutableCt.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCt ImmutableCt}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Ct", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<Ct.ExtendedEntry> entries = new ArrayList<Ct.ExtendedEntry>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Ct} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Ct instance) {
      Objects.requireNonNull(instance, "instance");
      addAllEntries(instance.entries());
      return this;
    }

    /**
     * Adds one element to {@link Ct#entries() entries} sortedSet.
     * @param element A entries element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEntries(Ct.ExtendedEntry element) {
      this.entries.add(Objects.requireNonNull(element, "entries element"));
      return this;
    }

    /**
     * Adds elements to {@link Ct#entries() entries} sortedSet.
     * @param elements An array of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEntries(Ct.ExtendedEntry... elements) {
      for (Ct.ExtendedEntry element : elements) {
        this.entries.add(Objects.requireNonNull(element, "entries element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Ct#entries() entries} sortedSet.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder entries(Iterable<? extends Ct.ExtendedEntry> elements) {
      this.entries.clear();
      return addAllEntries(elements);
    }

    /**
     * Adds elements to {@link Ct#entries() entries} sortedSet.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEntries(Iterable<? extends Ct.ExtendedEntry> elements) {
      for (Ct.ExtendedEntry element : elements) {
        this.entries.add(Objects.requireNonNull(element, "entries element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableCt ImmutableCt}.
     * @return An immutable instance of Ct
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCt build() {
      return ImmutableCt.validate(new ImmutableCt(null, createUnmodifiableSortedSet(false, createSafeList(entries, false, false))));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T extends Comparable<T>> NavigableSet<T> createUnmodifiableSortedSet(boolean reverse, List<T> list) {
    TreeSet<T> set = reverse
        ? new TreeSet<>(Collections.reverseOrder())
        : new TreeSet<>();
    set.addAll(list);
    return Collections.unmodifiableNavigableSet(set);
  }
}
