package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.collections4.BidiMap;
import org.immutables.value.Generated;
import pl.poznan.put.pdb.PdbResidueIdentifier;
import pl.poznan.put.structure.DotBracketSymbol;

/**
 * Immutable implementation of {@link CombinedStrandFromPdb}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCombinedStrandFromPdb.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableCombinedStrandFromPdb.of()}.
 */
@Generated(from = "CombinedStrandFromPdb", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableCombinedStrandFromPdb
    extends CombinedStrandFromPdb {
  private final List<DotBracket> combineStrands;
  private final List<Strand> inputStrands;
  private final Map<DotBracketSymbol, PdbResidueIdentifier> inputSymbolToResidue;

  private ImmutableCombinedStrandFromPdb(
      Iterable<? extends Strand> inputStrands,
      Map<? extends DotBracketSymbol, ? extends PdbResidueIdentifier> inputSymbolToResidue) {
    this.inputStrands = createUnmodifiableList(false, createSafeList(inputStrands, true, false));
    this.inputSymbolToResidue = createUnmodifiableMap(true, false, inputSymbolToResidue);
    this.combineStrands = Collections.emptyList();
  }

  private ImmutableCombinedStrandFromPdb(
      List<DotBracket> combineStrands,
      List<Strand> inputStrands,
      Map<DotBracketSymbol, PdbResidueIdentifier> inputSymbolToResidue) {
    this.combineStrands = combineStrands;
    this.inputStrands = inputStrands;
    this.inputSymbolToResidue = inputSymbolToResidue;
  }

  /**
   * Combines strands which share a base pair into a new dot-bracket instance and returns a list of
   * those.
   * @return The list of dot-bracket instances, each containing strands which only pair with each
   *     other.
   */
  @Override
  public List<DotBracket> combineStrands() {
    return combineStrands;
  }

  /**
   *@return The list of input strands. 
   */
  @Override
  protected List<Strand> inputStrands() {
    return inputStrands;
  }

  /**
   *@return The mapping of dot-bracket symbols with corresponding PDB identifiers. 
   */
  @Override
  protected Map<DotBracketSymbol, PdbResidueIdentifier> inputSymbolToResidue() {
    return inputSymbolToResidue;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CombinedStrandFromPdb#combineStrands() combineStrands}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCombinedStrandFromPdb withCombineStrands(DotBracket... elements) {
    List<DotBracket> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableCombinedStrandFromPdb(newValue, this.inputStrands, this.inputSymbolToResidue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CombinedStrandFromPdb#combineStrands() combineStrands}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of combineStrands elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCombinedStrandFromPdb withCombineStrands(Iterable<? extends DotBracket> elements) {
    if (this.combineStrands == elements) return this;
    List<DotBracket> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableCombinedStrandFromPdb(newValue, this.inputStrands, this.inputSymbolToResidue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CombinedStrandFromPdb#inputStrands() inputStrands}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCombinedStrandFromPdb withInputStrands(Strand... elements) {
    List<Strand> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableCombinedStrandFromPdb(this.combineStrands, newValue, this.inputSymbolToResidue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CombinedStrandFromPdb#inputStrands() inputStrands}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of inputStrands elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCombinedStrandFromPdb withInputStrands(Iterable<? extends Strand> elements) {
    if (this.inputStrands == elements) return this;
    List<Strand> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableCombinedStrandFromPdb(this.combineStrands, newValue, this.inputSymbolToResidue);
  }

  /**
   * Copy the current immutable object by replacing the {@link CombinedStrandFromPdb#inputSymbolToResidue() inputSymbolToResidue} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the inputSymbolToResidue map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCombinedStrandFromPdb withInputSymbolToResidue(Map<? extends DotBracketSymbol, ? extends PdbResidueIdentifier> entries) {
    if (this.inputSymbolToResidue == entries) return this;
    Map<DotBracketSymbol, PdbResidueIdentifier> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableCombinedStrandFromPdb(this.combineStrands, this.inputStrands, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCombinedStrandFromPdb} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCombinedStrandFromPdb
        && equalTo((ImmutableCombinedStrandFromPdb) another);
  }

  private boolean equalTo(ImmutableCombinedStrandFromPdb another) {
    return combineStrands.equals(another.combineStrands)
        && inputStrands.equals(another.inputStrands)
        && inputSymbolToResidue.equals(another.inputSymbolToResidue);
  }

  /**
   * Computes a hash code from attributes: {@code combineStrands}, {@code inputStrands}, {@code inputSymbolToResidue}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + combineStrands.hashCode();
    h += (h << 5) + inputStrands.hashCode();
    h += (h << 5) + inputSymbolToResidue.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CombinedStrandFromPdb} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CombinedStrandFromPdb{"
        + "combineStrands=" + combineStrands
        + ", inputStrands=" + inputStrands
        + ", inputSymbolToResidue=" + inputSymbolToResidue
        + "}";
  }

  private transient volatile long lazyInitBitmap;

  private static final long SYMBOLS_LAZY_INIT_BIT = 0x1L;

  private transient List<DotBracketSymbol> symbols;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link CombinedStrandFromPdb#symbols() symbols} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code symbols} attribute
   */
  @Override
  public List<DotBracketSymbol> symbols() {
    if ((lazyInitBitmap & SYMBOLS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SYMBOLS_LAZY_INIT_BIT) == 0) {
          this.symbols = Objects.requireNonNull(super.symbols(), "symbols");
          lazyInitBitmap |= SYMBOLS_LAZY_INIT_BIT;
        }
      }
    }
    return symbols;
  }

  private static final long STRANDS_LAZY_INIT_BIT = 0x2L;

  private transient List<Strand> strands;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link CombinedStrandFromPdb#strands() strands} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code strands} attribute
   */
  @Override
  public List<Strand> strands() {
    if ((lazyInitBitmap & STRANDS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & STRANDS_LAZY_INIT_BIT) == 0) {
          this.strands = Objects.requireNonNull(super.strands(), "strands");
          lazyInitBitmap |= STRANDS_LAZY_INIT_BIT;
        }
      }
    }
    return strands;
  }

  private static final long PAIRS_LAZY_INIT_BIT = 0x4L;

  private transient Map<DotBracketSymbol, DotBracketSymbol> pairs;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link CombinedStrandFromPdb#pairs() pairs} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code pairs} attribute
   */
  @Override
  public Map<DotBracketSymbol, DotBracketSymbol> pairs() {
    if ((lazyInitBitmap & PAIRS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & PAIRS_LAZY_INIT_BIT) == 0) {
          this.pairs = Objects.requireNonNull(super.pairs(), "pairs");
          lazyInitBitmap |= PAIRS_LAZY_INIT_BIT;
        }
      }
    }
    return pairs;
  }

  private static final long SYMBOL_TO_RESIDUE_LAZY_INIT_BIT = 0x8L;

  private transient Map<DotBracketSymbol, PdbResidueIdentifier> symbolToResidue;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link CombinedStrandFromPdb#symbolToResidue() symbolToResidue} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code symbolToResidue} attribute
   */
  @Override
  protected Map<DotBracketSymbol, PdbResidueIdentifier> symbolToResidue() {
    if ((lazyInitBitmap & SYMBOL_TO_RESIDUE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SYMBOL_TO_RESIDUE_LAZY_INIT_BIT) == 0) {
          this.symbolToResidue = Objects.requireNonNull(super.symbolToResidue(), "symbolToResidue");
          lazyInitBitmap |= SYMBOL_TO_RESIDUE_LAZY_INIT_BIT;
        }
      }
    }
    return symbolToResidue;
  }

  private static final long MAPPING_LAZY_INIT_BIT = 0x10L;

  private transient BidiMap<DotBracketSymbol, PdbResidueIdentifier> mapping;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link CombinedStrandFromPdb#mapping() mapping} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code mapping} attribute
   */
  @Override
  protected BidiMap<DotBracketSymbol, PdbResidueIdentifier> mapping() {
    if ((lazyInitBitmap & MAPPING_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & MAPPING_LAZY_INIT_BIT) == 0) {
          this.mapping = Objects.requireNonNull(super.mapping(), "mapping");
          lazyInitBitmap |= MAPPING_LAZY_INIT_BIT;
        }
      }
    }
    return mapping;
  }

  /**
   * Construct a new immutable {@code CombinedStrandFromPdb} instance.
   * @param inputStrands The value for the {@code inputStrands} attribute
   * @param inputSymbolToResidue The value for the {@code inputSymbolToResidue} attribute
   * @return An immutable CombinedStrandFromPdb instance
   */
  public static ImmutableCombinedStrandFromPdb of(List<Strand> inputStrands, Map<DotBracketSymbol, PdbResidueIdentifier> inputSymbolToResidue) {
    return of((Iterable<? extends Strand>) inputStrands, inputSymbolToResidue);
  }

  /**
   * Construct a new immutable {@code CombinedStrandFromPdb} instance.
   * @param inputStrands The value for the {@code inputStrands} attribute
   * @param inputSymbolToResidue The value for the {@code inputSymbolToResidue} attribute
   * @return An immutable CombinedStrandFromPdb instance
   */
  public static ImmutableCombinedStrandFromPdb of(Iterable<? extends Strand> inputStrands, Map<? extends DotBracketSymbol, ? extends PdbResidueIdentifier> inputSymbolToResidue) {
    return new ImmutableCombinedStrandFromPdb(inputStrands, inputSymbolToResidue);
  }

  /**
   * Creates an immutable copy of a {@link CombinedStrandFromPdb} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CombinedStrandFromPdb instance
   */
  public static ImmutableCombinedStrandFromPdb copyOf(CombinedStrandFromPdb instance) {
    if (instance instanceof ImmutableCombinedStrandFromPdb) {
      return (ImmutableCombinedStrandFromPdb) instance;
    }
    return ImmutableCombinedStrandFromPdb.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCombinedStrandFromPdb ImmutableCombinedStrandFromPdb}.
   * <pre>
   * ImmutableCombinedStrandFromPdb.builder()
   *    .addCombineStrands|addAllCombineStrands(pl.poznan.put.structure.formats.DotBracket) // {@link CombinedStrandFromPdb#combineStrands() combineStrands} elements
   *    .addInputStrands|addAllInputStrands(pl.poznan.put.structure.formats.Strand) // {@link CombinedStrandFromPdb#inputStrands() inputStrands} elements
   *    .putInputSymbolToResidue|putAllInputSymbolToResidue(pl.poznan.put.structure.DotBracketSymbol =&gt; pl.poznan.put.pdb.PdbResidueIdentifier) // {@link CombinedStrandFromPdb#inputSymbolToResidue() inputSymbolToResidue} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableCombinedStrandFromPdb builder
   */
  public static ImmutableCombinedStrandFromPdb.Builder builder() {
    return new ImmutableCombinedStrandFromPdb.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCombinedStrandFromPdb ImmutableCombinedStrandFromPdb}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CombinedStrandFromPdb", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<DotBracket> combineStrands = new ArrayList<DotBracket>();
    private List<Strand> inputStrands = new ArrayList<Strand>();
    private Map<DotBracketSymbol, PdbResidueIdentifier> inputSymbolToResidue = new LinkedHashMap<DotBracketSymbol, PdbResidueIdentifier>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.structure.formats.CombinedStrandFromPdb} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CombinedStrandFromPdb instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.structure.formats.AbstractCombinedStrand} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractCombinedStrand instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.structure.formats.DotBracket} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DotBracket instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof CombinedStrandFromPdb) {
        CombinedStrandFromPdb instance = (CombinedStrandFromPdb) object;
        putAllInputSymbolToResidue(instance.inputSymbolToResidue());
        if ((bits & 0x1L) == 0) {
          addAllInputStrands(instance.inputStrands());
          bits |= 0x1L;
        }
      }
      if (object instanceof AbstractCombinedStrand) {
        AbstractCombinedStrand instance = (AbstractCombinedStrand) object;
        if ((bits & 0x1L) == 0) {
          addAllInputStrands(instance.inputStrands());
          bits |= 0x1L;
        }
      }
      if (object instanceof DotBracket) {
        DotBracket instance = (DotBracket) object;
        addAllCombineStrands(instance.combineStrands());
      }
    }

    /**
     * Adds one element to {@link CombinedStrandFromPdb#combineStrands() combineStrands} list.
     * @param element A combineStrands element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCombineStrands(DotBracket element) {
      this.combineStrands.add(Objects.requireNonNull(element, "combineStrands element"));
      return this;
    }

    /**
     * Adds elements to {@link CombinedStrandFromPdb#combineStrands() combineStrands} list.
     * @param elements An array of combineStrands elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCombineStrands(DotBracket... elements) {
      for (DotBracket element : elements) {
        this.combineStrands.add(Objects.requireNonNull(element, "combineStrands element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CombinedStrandFromPdb#combineStrands() combineStrands} list.
     * @param elements An iterable of combineStrands elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder combineStrands(Iterable<? extends DotBracket> elements) {
      this.combineStrands.clear();
      return addAllCombineStrands(elements);
    }

    /**
     * Adds elements to {@link CombinedStrandFromPdb#combineStrands() combineStrands} list.
     * @param elements An iterable of combineStrands elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllCombineStrands(Iterable<? extends DotBracket> elements) {
      for (DotBracket element : elements) {
        this.combineStrands.add(Objects.requireNonNull(element, "combineStrands element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link CombinedStrandFromPdb#inputStrands() inputStrands} list.
     * @param element A inputStrands element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addInputStrands(Strand element) {
      this.inputStrands.add(Objects.requireNonNull(element, "inputStrands element"));
      return this;
    }

    /**
     * Adds elements to {@link CombinedStrandFromPdb#inputStrands() inputStrands} list.
     * @param elements An array of inputStrands elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addInputStrands(Strand... elements) {
      for (Strand element : elements) {
        this.inputStrands.add(Objects.requireNonNull(element, "inputStrands element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CombinedStrandFromPdb#inputStrands() inputStrands} list.
     * @param elements An iterable of inputStrands elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder inputStrands(Iterable<? extends Strand> elements) {
      this.inputStrands.clear();
      return addAllInputStrands(elements);
    }

    /**
     * Adds elements to {@link CombinedStrandFromPdb#inputStrands() inputStrands} list.
     * @param elements An iterable of inputStrands elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllInputStrands(Iterable<? extends Strand> elements) {
      for (Strand element : elements) {
        this.inputStrands.add(Objects.requireNonNull(element, "inputStrands element"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link CombinedStrandFromPdb#inputSymbolToResidue() inputSymbolToResidue} map.
     * @param key The key in the inputSymbolToResidue map
     * @param value The associated value in the inputSymbolToResidue map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putInputSymbolToResidue(DotBracketSymbol key, PdbResidueIdentifier value) {
      this.inputSymbolToResidue.put(
          Objects.requireNonNull(key, "inputSymbolToResidue key"),
          Objects.requireNonNull(value, "inputSymbolToResidue value"));
      return this;
    }

    /**
     * Put one entry to the {@link CombinedStrandFromPdb#inputSymbolToResidue() inputSymbolToResidue} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putInputSymbolToResidue(Map.Entry<? extends DotBracketSymbol, ? extends PdbResidueIdentifier> entry) {
      DotBracketSymbol k = entry.getKey();
      PdbResidueIdentifier v = entry.getValue();
      this.inputSymbolToResidue.put(
          Objects.requireNonNull(k, "inputSymbolToResidue key"),
          Objects.requireNonNull(v, "inputSymbolToResidue value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CombinedStrandFromPdb#inputSymbolToResidue() inputSymbolToResidue} map. Nulls are not permitted
     * @param entries The entries that will be added to the inputSymbolToResidue map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder inputSymbolToResidue(Map<? extends DotBracketSymbol, ? extends PdbResidueIdentifier> entries) {
      this.inputSymbolToResidue.clear();
      return putAllInputSymbolToResidue(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CombinedStrandFromPdb#inputSymbolToResidue() inputSymbolToResidue} map. Nulls are not permitted
     * @param entries The entries that will be added to the inputSymbolToResidue map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllInputSymbolToResidue(Map<? extends DotBracketSymbol, ? extends PdbResidueIdentifier> entries) {
      for (Map.Entry<? extends DotBracketSymbol, ? extends PdbResidueIdentifier> e : entries.entrySet()) {
        DotBracketSymbol k = e.getKey();
        PdbResidueIdentifier v = e.getValue();
        this.inputSymbolToResidue.put(
            Objects.requireNonNull(k, "inputSymbolToResidue key"),
            Objects.requireNonNull(v, "inputSymbolToResidue value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableCombinedStrandFromPdb ImmutableCombinedStrandFromPdb}.
     * @return An immutable instance of CombinedStrandFromPdb
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCombinedStrandFromPdb build() {
      return new ImmutableCombinedStrandFromPdb(
          createUnmodifiableList(true, combineStrands),
          createUnmodifiableList(true, inputStrands),
          createUnmodifiableMap(false, false, inputSymbolToResidue));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
