package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.structure.DotBracketSymbol;

/**
 * Immutable implementation of {@link CombinedStrand}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCombinedStrand.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableCombinedStrand.of()}.
 */
@Generated(from = "CombinedStrand", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableCombinedStrand extends CombinedStrand {
  private final List<Strand> inputStrands;

  private ImmutableCombinedStrand(Iterable<? extends Strand> inputStrands) {
    this.inputStrands = createUnmodifiableList(false, createSafeList(inputStrands, true, false));
  }

  private ImmutableCombinedStrand(
      ImmutableCombinedStrand original,
      List<Strand> inputStrands) {
    this.inputStrands = inputStrands;
  }

  /**
   *@return The list of input strands. 
   */
  @Override
  protected List<Strand> inputStrands() {
    return inputStrands;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CombinedStrand#inputStrands() inputStrands}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCombinedStrand withInputStrands(Strand... elements) {
    List<Strand> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableCombinedStrand(this, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CombinedStrand#inputStrands() inputStrands}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of inputStrands elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCombinedStrand withInputStrands(Iterable<? extends Strand> elements) {
    if (this.inputStrands == elements) return this;
    List<Strand> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableCombinedStrand(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCombinedStrand} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCombinedStrand
        && equalTo((ImmutableCombinedStrand) another);
  }

  private boolean equalTo(ImmutableCombinedStrand another) {
    return inputStrands.equals(another.inputStrands);
  }

  /**
   * Computes a hash code from attributes: {@code inputStrands}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + inputStrands.hashCode();
    return h;
  }

  private transient volatile long lazyInitBitmap;

  private static final long SYMBOLS_LAZY_INIT_BIT = 0x1L;

  private transient List<DotBracketSymbol> symbols;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link CombinedStrand#symbols() symbols} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code symbols} attribute
   */
  @Override
  public List<DotBracketSymbol> symbols() {
    if ((lazyInitBitmap & SYMBOLS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SYMBOLS_LAZY_INIT_BIT) == 0) {
          this.symbols = Objects.requireNonNull(super.symbols(), "symbols");
          lazyInitBitmap |= SYMBOLS_LAZY_INIT_BIT;
        }
      }
    }
    return symbols;
  }

  private static final long STRANDS_LAZY_INIT_BIT = 0x2L;

  private transient List<Strand> strands;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link CombinedStrand#strands() strands} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code strands} attribute
   */
  @Override
  public List<Strand> strands() {
    if ((lazyInitBitmap & STRANDS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & STRANDS_LAZY_INIT_BIT) == 0) {
          this.strands = Objects.requireNonNull(super.strands(), "strands");
          lazyInitBitmap |= STRANDS_LAZY_INIT_BIT;
        }
      }
    }
    return strands;
  }

  private static final long PAIRS_LAZY_INIT_BIT = 0x4L;

  private transient Map<DotBracketSymbol, DotBracketSymbol> pairs;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link CombinedStrand#pairs() pairs} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code pairs} attribute
   */
  @Override
  public Map<DotBracketSymbol, DotBracketSymbol> pairs() {
    if ((lazyInitBitmap & PAIRS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & PAIRS_LAZY_INIT_BIT) == 0) {
          this.pairs = Objects.requireNonNull(super.pairs(), "pairs");
          lazyInitBitmap |= PAIRS_LAZY_INIT_BIT;
        }
      }
    }
    return pairs;
  }

  /**
   * Construct a new immutable {@code CombinedStrand} instance.
   * @param inputStrands The value for the {@code inputStrands} attribute
   * @return An immutable CombinedStrand instance
   */
  public static ImmutableCombinedStrand of(List<Strand> inputStrands) {
    return of((Iterable<? extends Strand>) inputStrands);
  }

  /**
   * Construct a new immutable {@code CombinedStrand} instance.
   * @param inputStrands The value for the {@code inputStrands} attribute
   * @return An immutable CombinedStrand instance
   */
  public static ImmutableCombinedStrand of(Iterable<? extends Strand> inputStrands) {
    return new ImmutableCombinedStrand(inputStrands);
  }

  /**
   * Creates an immutable copy of a {@link CombinedStrand} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CombinedStrand instance
   */
  public static ImmutableCombinedStrand copyOf(CombinedStrand instance) {
    if (instance instanceof ImmutableCombinedStrand) {
      return (ImmutableCombinedStrand) instance;
    }
    return ImmutableCombinedStrand.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCombinedStrand ImmutableCombinedStrand}.
   * <pre>
   * ImmutableCombinedStrand.builder()
   *    .addInputStrands|addAllInputStrands(pl.poznan.put.structure.formats.Strand) // {@link CombinedStrand#inputStrands() inputStrands} elements
   *    .build();
   * </pre>
   * @return A new ImmutableCombinedStrand builder
   */
  public static ImmutableCombinedStrand.Builder builder() {
    return new ImmutableCombinedStrand.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCombinedStrand ImmutableCombinedStrand}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CombinedStrand", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<Strand> inputStrands = new ArrayList<Strand>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.structure.formats.AbstractCombinedStrand} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractCombinedStrand instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.structure.formats.CombinedStrand} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CombinedStrand instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof AbstractCombinedStrand) {
        AbstractCombinedStrand instance = (AbstractCombinedStrand) object;
        if ((bits & 0x1L) == 0) {
          addAllInputStrands(instance.inputStrands());
          bits |= 0x1L;
        }
      }
      if (object instanceof CombinedStrand) {
        CombinedStrand instance = (CombinedStrand) object;
        if ((bits & 0x1L) == 0) {
          addAllInputStrands(instance.inputStrands());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Adds one element to {@link CombinedStrand#inputStrands() inputStrands} list.
     * @param element A inputStrands element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addInputStrands(Strand element) {
      this.inputStrands.add(Objects.requireNonNull(element, "inputStrands element"));
      return this;
    }

    /**
     * Adds elements to {@link CombinedStrand#inputStrands() inputStrands} list.
     * @param elements An array of inputStrands elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addInputStrands(Strand... elements) {
      for (Strand element : elements) {
        this.inputStrands.add(Objects.requireNonNull(element, "inputStrands element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CombinedStrand#inputStrands() inputStrands} list.
     * @param elements An iterable of inputStrands elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder inputStrands(Iterable<? extends Strand> elements) {
      this.inputStrands.clear();
      return addAllInputStrands(elements);
    }

    /**
     * Adds elements to {@link CombinedStrand#inputStrands() inputStrands} list.
     * @param elements An iterable of inputStrands elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllInputStrands(Iterable<? extends Strand> elements) {
      for (Strand element : elements) {
        this.inputStrands.add(Objects.requireNonNull(element, "inputStrands element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableCombinedStrand ImmutableCombinedStrand}.
     * @return An immutable instance of CombinedStrand
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCombinedStrand build() {
      return new ImmutableCombinedStrand(null, createUnmodifiableList(true, inputStrands));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
