package pl.poznan.put.structure.formats;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link BpSeq}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBpSeq.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableBpSeq.of()}.
 */
@Generated(from = "BpSeq", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableBpSeq extends BpSeq {
  private final SortedSet<BpSeq.Entry> entries;

  private ImmutableBpSeq(Iterable<? extends BpSeq.Entry> entries) {
    this.entries = createUnmodifiableSortedSet(false, createSafeList(entries, true, false));
  }

  private ImmutableBpSeq(ImmutableBpSeq original, SortedSet<BpSeq.Entry> entries) {
    this.entries = entries;
  }

  /**
   *@return The list of BPSEQ entries. 
   */
  @Override
  public SortedSet<BpSeq.Entry> entries() {
    return entries;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BpSeq#entries() entries}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBpSeq withEntries(BpSeq.Entry... elements) {
    SortedSet<BpSeq.Entry> newValue = createUnmodifiableSortedSet(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableBpSeq(this, newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BpSeq#entries() entries}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of entries elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBpSeq withEntries(Iterable<? extends BpSeq.Entry> elements) {
    if (this.entries == elements) return this;
    SortedSet<BpSeq.Entry> newValue = createUnmodifiableSortedSet(false, createSafeList(elements, true, false));
    return validate(new ImmutableBpSeq(this, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBpSeq} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBpSeq
        && equalTo((ImmutableBpSeq) another);
  }

  private boolean equalTo(ImmutableBpSeq another) {
    return entries.equals(another.entries);
  }

  /**
   * Computes a hash code from attributes: {@code entries}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + entries.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code BpSeq} instance.
   * @param entries The value for the {@code entries} attribute
   * @return An immutable BpSeq instance
   */
  public static ImmutableBpSeq of(SortedSet<BpSeq.Entry> entries) {
    return of((Iterable<? extends BpSeq.Entry>) entries);
  }

  /**
   * Construct a new immutable {@code BpSeq} instance.
   * @param entries The value for the {@code entries} attribute
   * @return An immutable BpSeq instance
   */
  public static ImmutableBpSeq of(Iterable<? extends BpSeq.Entry> entries) {
    return validate(new ImmutableBpSeq(entries));
  }

  private static ImmutableBpSeq validate(ImmutableBpSeq instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link BpSeq} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BpSeq instance
   */
  public static ImmutableBpSeq copyOf(BpSeq instance) {
    if (instance instanceof ImmutableBpSeq) {
      return (ImmutableBpSeq) instance;
    }
    return ImmutableBpSeq.builder()
        .from(instance)
        .build();
  }

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link ImmutableBpSeq ImmutableBpSeq}.
   * <pre>
   * ImmutableBpSeq.builder()
   *    .addEntries|addAllEntries(pl.poznan.put.structure.formats.BpSeq.Entry) // {@link BpSeq#entries() entries} elements
   *    .build();
   * </pre>
   * @return A new ImmutableBpSeq builder
   */
  public static ImmutableBpSeq.Builder builder() {
    return new ImmutableBpSeq.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBpSeq ImmutableBpSeq}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BpSeq", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<BpSeq.Entry> entries = new ArrayList<BpSeq.Entry>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BpSeq} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BpSeq instance) {
      Objects.requireNonNull(instance, "instance");
      addAllEntries(instance.entries());
      return this;
    }

    /**
     * Adds one element to {@link BpSeq#entries() entries} sortedSet.
     * @param element A entries element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEntries(BpSeq.Entry element) {
      this.entries.add(Objects.requireNonNull(element, "entries element"));
      return this;
    }

    /**
     * Adds elements to {@link BpSeq#entries() entries} sortedSet.
     * @param elements An array of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEntries(BpSeq.Entry... elements) {
      for (BpSeq.Entry element : elements) {
        this.entries.add(Objects.requireNonNull(element, "entries element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BpSeq#entries() entries} sortedSet.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder entries(Iterable<? extends BpSeq.Entry> elements) {
      this.entries.clear();
      return addAllEntries(elements);
    }

    /**
     * Adds elements to {@link BpSeq#entries() entries} sortedSet.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEntries(Iterable<? extends BpSeq.Entry> elements) {
      for (BpSeq.Entry element : elements) {
        this.entries.add(Objects.requireNonNull(element, "entries element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableBpSeq ImmutableBpSeq}.
     * @return An immutable instance of BpSeq
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBpSeq build() {
      return ImmutableBpSeq.validate(new ImmutableBpSeq(null, createUnmodifiableSortedSet(false, createSafeList(entries, false, false))));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T extends Comparable<T>> NavigableSet<T> createUnmodifiableSortedSet(boolean reverse, List<T> list) {
    TreeSet<T> set = reverse
        ? new TreeSet<>(Collections.reverseOrder())
        : new TreeSet<>();
    set.addAll(list);
    return Collections.unmodifiableNavigableSet(set);
  }
}
