package pl.poznan.put.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.notation.BPh;
import pl.poznan.put.notation.BR;
import pl.poznan.put.notation.LeontisWesthof;
import pl.poznan.put.notation.Saenger;
import pl.poznan.put.rna.InteractionType;

/**
 * Immutable implementation of {@link QuantifiedBasePair}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQuantifiedBasePair.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableQuantifiedBasePair.of()}.
 */
@Generated(from = "QuantifiedBasePair", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableQuantifiedBasePair extends QuantifiedBasePair {
  private final BasePair basePair;
  private final InteractionType interactionType;
  private final Saenger saenger;
  private final LeontisWesthof leontisWesthof;
  private final BPh bph;
  private final BR br;
  private final boolean isRepresented;
  private final double shear;
  private final double stretch;
  private final double stagger;
  private final double buckle;
  private final double propeller;
  private final double opening;

  private ImmutableQuantifiedBasePair(
      BasePair basePair,
      double shear,
      double stretch,
      double stagger,
      double buckle,
      double propeller,
      double opening) {
    this.basePair = Objects.requireNonNull(basePair, "basePair");
    this.shear = shear;
    this.stretch = stretch;
    this.stagger = stagger;
    this.buckle = buckle;
    this.propeller = propeller;
    this.opening = opening;
    this.interactionType = initShim.interactionType();
    this.saenger = initShim.saenger();
    this.leontisWesthof = initShim.leontisWesthof();
    this.bph = initShim.bph();
    this.br = initShim.br();
    this.isRepresented = initShim.isRepresented();
    this.initShim = null;
  }

  private ImmutableQuantifiedBasePair(ImmutableQuantifiedBasePair.Builder builder) {
    this.basePair = builder.basePair;
    this.shear = builder.shear;
    this.stretch = builder.stretch;
    this.stagger = builder.stagger;
    this.buckle = builder.buckle;
    this.propeller = builder.propeller;
    this.opening = builder.opening;
    if (builder.interactionType != null) {
      initShim.interactionType(builder.interactionType);
    }
    if (builder.saenger != null) {
      initShim.saenger(builder.saenger);
    }
    if (builder.leontisWesthof != null) {
      initShim.leontisWesthof(builder.leontisWesthof);
    }
    if (builder.bph != null) {
      initShim.bph(builder.bph);
    }
    if (builder.br != null) {
      initShim.br(builder.br);
    }
    if (builder.isRepresentedIsSet()) {
      initShim.isRepresented(builder.isRepresented);
    }
    this.interactionType = initShim.interactionType();
    this.saenger = initShim.saenger();
    this.leontisWesthof = initShim.leontisWesthof();
    this.bph = initShim.bph();
    this.br = initShim.br();
    this.isRepresented = initShim.isRepresented();
    this.initShim = null;
  }

  private ImmutableQuantifiedBasePair(
      BasePair basePair,
      InteractionType interactionType,
      Saenger saenger,
      LeontisWesthof leontisWesthof,
      BPh bph,
      BR br,
      boolean isRepresented,
      double shear,
      double stretch,
      double stagger,
      double buckle,
      double propeller,
      double opening) {
    this.basePair = basePair;
    this.interactionType = interactionType;
    this.saenger = saenger;
    this.leontisWesthof = leontisWesthof;
    this.bph = bph;
    this.br = br;
    this.isRepresented = isRepresented;
    this.shear = shear;
    this.stretch = stretch;
    this.stagger = stagger;
    this.buckle = buckle;
    this.propeller = propeller;
    this.opening = opening;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "QuantifiedBasePair", generator = "Immutables")
  private final class InitShim {
    private byte interactionTypeBuildStage = STAGE_UNINITIALIZED;
    private InteractionType interactionType;

    InteractionType interactionType() {
      if (interactionTypeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (interactionTypeBuildStage == STAGE_UNINITIALIZED) {
        interactionTypeBuildStage = STAGE_INITIALIZING;
        this.interactionType = Objects.requireNonNull(ImmutableQuantifiedBasePair.super.interactionType(), "interactionType");
        interactionTypeBuildStage = STAGE_INITIALIZED;
      }
      return this.interactionType;
    }

    void interactionType(InteractionType interactionType) {
      this.interactionType = interactionType;
      interactionTypeBuildStage = STAGE_INITIALIZED;
    }

    private byte saengerBuildStage = STAGE_UNINITIALIZED;
    private Saenger saenger;

    Saenger saenger() {
      if (saengerBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (saengerBuildStage == STAGE_UNINITIALIZED) {
        saengerBuildStage = STAGE_INITIALIZING;
        this.saenger = Objects.requireNonNull(ImmutableQuantifiedBasePair.super.saenger(), "saenger");
        saengerBuildStage = STAGE_INITIALIZED;
      }
      return this.saenger;
    }

    void saenger(Saenger saenger) {
      this.saenger = saenger;
      saengerBuildStage = STAGE_INITIALIZED;
    }

    private byte leontisWesthofBuildStage = STAGE_UNINITIALIZED;
    private LeontisWesthof leontisWesthof;

    LeontisWesthof leontisWesthof() {
      if (leontisWesthofBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (leontisWesthofBuildStage == STAGE_UNINITIALIZED) {
        leontisWesthofBuildStage = STAGE_INITIALIZING;
        this.leontisWesthof = Objects.requireNonNull(ImmutableQuantifiedBasePair.super.leontisWesthof(), "leontisWesthof");
        leontisWesthofBuildStage = STAGE_INITIALIZED;
      }
      return this.leontisWesthof;
    }

    void leontisWesthof(LeontisWesthof leontisWesthof) {
      this.leontisWesthof = leontisWesthof;
      leontisWesthofBuildStage = STAGE_INITIALIZED;
    }

    private byte bphBuildStage = STAGE_UNINITIALIZED;
    private BPh bph;

    BPh bph() {
      if (bphBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (bphBuildStage == STAGE_UNINITIALIZED) {
        bphBuildStage = STAGE_INITIALIZING;
        this.bph = Objects.requireNonNull(ImmutableQuantifiedBasePair.super.bph(), "bph");
        bphBuildStage = STAGE_INITIALIZED;
      }
      return this.bph;
    }

    void bph(BPh bph) {
      this.bph = bph;
      bphBuildStage = STAGE_INITIALIZED;
    }

    private byte brBuildStage = STAGE_UNINITIALIZED;
    private BR br;

    BR br() {
      if (brBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (brBuildStage == STAGE_UNINITIALIZED) {
        brBuildStage = STAGE_INITIALIZING;
        this.br = Objects.requireNonNull(ImmutableQuantifiedBasePair.super.br(), "br");
        brBuildStage = STAGE_INITIALIZED;
      }
      return this.br;
    }

    void br(BR br) {
      this.br = br;
      brBuildStage = STAGE_INITIALIZED;
    }

    private byte isRepresentedBuildStage = STAGE_UNINITIALIZED;
    private boolean isRepresented;

    boolean isRepresented() {
      if (isRepresentedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isRepresentedBuildStage == STAGE_UNINITIALIZED) {
        isRepresentedBuildStage = STAGE_INITIALIZING;
        this.isRepresented = ImmutableQuantifiedBasePair.super.isRepresented();
        isRepresentedBuildStage = STAGE_INITIALIZED;
      }
      return this.isRepresented;
    }

    void isRepresented(boolean isRepresented) {
      this.isRepresented = isRepresented;
      isRepresentedBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (interactionTypeBuildStage == STAGE_INITIALIZING) attributes.add("interactionType");
      if (saengerBuildStage == STAGE_INITIALIZING) attributes.add("saenger");
      if (leontisWesthofBuildStage == STAGE_INITIALIZING) attributes.add("leontisWesthof");
      if (bphBuildStage == STAGE_INITIALIZING) attributes.add("bph");
      if (brBuildStage == STAGE_INITIALIZING) attributes.add("br");
      if (isRepresentedBuildStage == STAGE_INITIALIZING) attributes.add("isRepresented");
      return "Cannot build QuantifiedBasePair, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code basePair} attribute
   */
  @Override
  public BasePair basePair() {
    return basePair;
  }

  /**
   * @return The value of the {@code interactionType} attribute
   */
  @Override
  public InteractionType interactionType() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.interactionType()
        : this.interactionType;
  }

  /**
   * @return The value of the {@code saenger} attribute
   */
  @Override
  public Saenger saenger() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.saenger()
        : this.saenger;
  }

  /**
   * @return The value of the {@code leontisWesthof} attribute
   */
  @Override
  public LeontisWesthof leontisWesthof() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.leontisWesthof()
        : this.leontisWesthof;
  }

  /**
   * @return The value of the {@code bph} attribute
   */
  @Override
  public BPh bph() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.bph()
        : this.bph;
  }

  /**
   * @return The value of the {@code br} attribute
   */
  @Override
  public BR br() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.br()
        : this.br;
  }

  /**
   * @return The value of the {@code isRepresented} attribute
   */
  @Override
  public boolean isRepresented() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isRepresented()
        : this.isRepresented;
  }

  /**
   *@return The value of shear parameter. 
   */
  @Override
  public double shear() {
    return shear;
  }

  /**
   *@return The value of stretch parameter. 
   */
  @Override
  public double stretch() {
    return stretch;
  }

  /**
   *@return The value of stagger parameter. 
   */
  @Override
  public double stagger() {
    return stagger;
  }

  /**
   *@return The value of buckle parameter. 
   */
  @Override
  public double buckle() {
    return buckle;
  }

  /**
   *@return The value of propeller parameter. 
   */
  @Override
  public double propeller() {
    return propeller;
  }

  /**
   *@return The value of opening parameter. 
   */
  @Override
  public double opening() {
    return opening;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuantifiedBasePair#basePair() basePair} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for basePair
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuantifiedBasePair withBasePair(BasePair value) {
    if (this.basePair == value) return this;
    BasePair newValue = Objects.requireNonNull(value, "basePair");
    return new ImmutableQuantifiedBasePair(
        newValue,
        this.interactionType,
        this.saenger,
        this.leontisWesthof,
        this.bph,
        this.br,
        this.isRepresented,
        this.shear,
        this.stretch,
        this.stagger,
        this.buckle,
        this.propeller,
        this.opening);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuantifiedBasePair#interactionType() interactionType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for interactionType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuantifiedBasePair withInteractionType(InteractionType value) {
    if (this.interactionType == value) return this;
    InteractionType newValue = Objects.requireNonNull(value, "interactionType");
    return new ImmutableQuantifiedBasePair(
        this.basePair,
        newValue,
        this.saenger,
        this.leontisWesthof,
        this.bph,
        this.br,
        this.isRepresented,
        this.shear,
        this.stretch,
        this.stagger,
        this.buckle,
        this.propeller,
        this.opening);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuantifiedBasePair#saenger() saenger} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for saenger
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuantifiedBasePair withSaenger(Saenger value) {
    if (this.saenger == value) return this;
    Saenger newValue = Objects.requireNonNull(value, "saenger");
    if (this.saenger.equals(newValue)) return this;
    return new ImmutableQuantifiedBasePair(
        this.basePair,
        this.interactionType,
        newValue,
        this.leontisWesthof,
        this.bph,
        this.br,
        this.isRepresented,
        this.shear,
        this.stretch,
        this.stagger,
        this.buckle,
        this.propeller,
        this.opening);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuantifiedBasePair#leontisWesthof() leontisWesthof} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for leontisWesthof
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuantifiedBasePair withLeontisWesthof(LeontisWesthof value) {
    if (this.leontisWesthof == value) return this;
    LeontisWesthof newValue = Objects.requireNonNull(value, "leontisWesthof");
    if (this.leontisWesthof.equals(newValue)) return this;
    return new ImmutableQuantifiedBasePair(
        this.basePair,
        this.interactionType,
        this.saenger,
        newValue,
        this.bph,
        this.br,
        this.isRepresented,
        this.shear,
        this.stretch,
        this.stagger,
        this.buckle,
        this.propeller,
        this.opening);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuantifiedBasePair#bph() bph} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bph
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuantifiedBasePair withBph(BPh value) {
    if (this.bph == value) return this;
    BPh newValue = Objects.requireNonNull(value, "bph");
    if (this.bph.equals(newValue)) return this;
    return new ImmutableQuantifiedBasePair(
        this.basePair,
        this.interactionType,
        this.saenger,
        this.leontisWesthof,
        newValue,
        this.br,
        this.isRepresented,
        this.shear,
        this.stretch,
        this.stagger,
        this.buckle,
        this.propeller,
        this.opening);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuantifiedBasePair#br() br} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for br
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuantifiedBasePair withBr(BR value) {
    if (this.br == value) return this;
    BR newValue = Objects.requireNonNull(value, "br");
    if (this.br.equals(newValue)) return this;
    return new ImmutableQuantifiedBasePair(
        this.basePair,
        this.interactionType,
        this.saenger,
        this.leontisWesthof,
        this.bph,
        newValue,
        this.isRepresented,
        this.shear,
        this.stretch,
        this.stagger,
        this.buckle,
        this.propeller,
        this.opening);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuantifiedBasePair#isRepresented() isRepresented} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isRepresented
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuantifiedBasePair withIsRepresented(boolean value) {
    if (this.isRepresented == value) return this;
    return new ImmutableQuantifiedBasePair(
        this.basePair,
        this.interactionType,
        this.saenger,
        this.leontisWesthof,
        this.bph,
        this.br,
        value,
        this.shear,
        this.stretch,
        this.stagger,
        this.buckle,
        this.propeller,
        this.opening);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuantifiedBasePair#shear() shear} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for shear
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuantifiedBasePair withShear(double value) {
    if (Double.doubleToLongBits(this.shear) == Double.doubleToLongBits(value)) return this;
    return new ImmutableQuantifiedBasePair(
        this.basePair,
        this.interactionType,
        this.saenger,
        this.leontisWesthof,
        this.bph,
        this.br,
        this.isRepresented,
        value,
        this.stretch,
        this.stagger,
        this.buckle,
        this.propeller,
        this.opening);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuantifiedBasePair#stretch() stretch} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stretch
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuantifiedBasePair withStretch(double value) {
    if (Double.doubleToLongBits(this.stretch) == Double.doubleToLongBits(value)) return this;
    return new ImmutableQuantifiedBasePair(
        this.basePair,
        this.interactionType,
        this.saenger,
        this.leontisWesthof,
        this.bph,
        this.br,
        this.isRepresented,
        this.shear,
        value,
        this.stagger,
        this.buckle,
        this.propeller,
        this.opening);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuantifiedBasePair#stagger() stagger} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stagger
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuantifiedBasePair withStagger(double value) {
    if (Double.doubleToLongBits(this.stagger) == Double.doubleToLongBits(value)) return this;
    return new ImmutableQuantifiedBasePair(
        this.basePair,
        this.interactionType,
        this.saenger,
        this.leontisWesthof,
        this.bph,
        this.br,
        this.isRepresented,
        this.shear,
        this.stretch,
        value,
        this.buckle,
        this.propeller,
        this.opening);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuantifiedBasePair#buckle() buckle} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for buckle
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuantifiedBasePair withBuckle(double value) {
    if (Double.doubleToLongBits(this.buckle) == Double.doubleToLongBits(value)) return this;
    return new ImmutableQuantifiedBasePair(
        this.basePair,
        this.interactionType,
        this.saenger,
        this.leontisWesthof,
        this.bph,
        this.br,
        this.isRepresented,
        this.shear,
        this.stretch,
        this.stagger,
        value,
        this.propeller,
        this.opening);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuantifiedBasePair#propeller() propeller} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for propeller
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuantifiedBasePair withPropeller(double value) {
    if (Double.doubleToLongBits(this.propeller) == Double.doubleToLongBits(value)) return this;
    return new ImmutableQuantifiedBasePair(
        this.basePair,
        this.interactionType,
        this.saenger,
        this.leontisWesthof,
        this.bph,
        this.br,
        this.isRepresented,
        this.shear,
        this.stretch,
        this.stagger,
        this.buckle,
        value,
        this.opening);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuantifiedBasePair#opening() opening} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for opening
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuantifiedBasePair withOpening(double value) {
    if (Double.doubleToLongBits(this.opening) == Double.doubleToLongBits(value)) return this;
    return new ImmutableQuantifiedBasePair(
        this.basePair,
        this.interactionType,
        this.saenger,
        this.leontisWesthof,
        this.bph,
        this.br,
        this.isRepresented,
        this.shear,
        this.stretch,
        this.stagger,
        this.buckle,
        this.propeller,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQuantifiedBasePair} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQuantifiedBasePair
        && equalTo((ImmutableQuantifiedBasePair) another);
  }

  private boolean equalTo(ImmutableQuantifiedBasePair another) {
    return basePair.equals(another.basePair)
        && interactionType.equals(another.interactionType)
        && saenger.equals(another.saenger)
        && leontisWesthof.equals(another.leontisWesthof)
        && bph.equals(another.bph)
        && br.equals(another.br);
  }

  /**
   * Computes a hash code from attributes: {@code basePair}, {@code interactionType}, {@code saenger}, {@code leontisWesthof}, {@code bph}, {@code br}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + basePair.hashCode();
    h += (h << 5) + interactionType.hashCode();
    h += (h << 5) + saenger.hashCode();
    h += (h << 5) + leontisWesthof.hashCode();
    h += (h << 5) + bph.hashCode();
    h += (h << 5) + br.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code QuantifiedBasePair} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "QuantifiedBasePair{"
        + "basePair=" + basePair
        + ", interactionType=" + interactionType
        + ", saenger=" + saenger
        + ", leontisWesthof=" + leontisWesthof
        + ", bph=" + bph
        + ", br=" + br
        + "}";
  }

  /**
   * Construct a new immutable {@code QuantifiedBasePair} instance.
   * @param basePair The value for the {@code basePair} attribute
   * @param shear The value for the {@code shear} attribute
   * @param stretch The value for the {@code stretch} attribute
   * @param stagger The value for the {@code stagger} attribute
   * @param buckle The value for the {@code buckle} attribute
   * @param propeller The value for the {@code propeller} attribute
   * @param opening The value for the {@code opening} attribute
   * @return An immutable QuantifiedBasePair instance
   */
  public static ImmutableQuantifiedBasePair of(BasePair basePair, double shear, double stretch, double stagger, double buckle, double propeller, double opening) {
    return new ImmutableQuantifiedBasePair(basePair, shear, stretch, stagger, buckle, propeller, opening);
  }

  /**
   * Creates an immutable copy of a {@link QuantifiedBasePair} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable QuantifiedBasePair instance
   */
  public static ImmutableQuantifiedBasePair copyOf(QuantifiedBasePair instance) {
    if (instance instanceof ImmutableQuantifiedBasePair) {
      return (ImmutableQuantifiedBasePair) instance;
    }
    return ImmutableQuantifiedBasePair.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQuantifiedBasePair ImmutableQuantifiedBasePair}.
   * <pre>
   * ImmutableQuantifiedBasePair.builder()
   *    .basePair(pl.poznan.put.structure.BasePair) // required {@link QuantifiedBasePair#basePair() basePair}
   *    .interactionType(pl.poznan.put.rna.InteractionType) // optional {@link QuantifiedBasePair#interactionType() interactionType}
   *    .saenger(pl.poznan.put.notation.Saenger) // optional {@link QuantifiedBasePair#saenger() saenger}
   *    .leontisWesthof(pl.poznan.put.notation.LeontisWesthof) // optional {@link QuantifiedBasePair#leontisWesthof() leontisWesthof}
   *    .bph(pl.poznan.put.notation.BPh) // optional {@link QuantifiedBasePair#bph() bph}
   *    .br(pl.poznan.put.notation.BR) // optional {@link QuantifiedBasePair#br() br}
   *    .isRepresented(boolean) // optional {@link QuantifiedBasePair#isRepresented() isRepresented}
   *    .shear(double) // required {@link QuantifiedBasePair#shear() shear}
   *    .stretch(double) // required {@link QuantifiedBasePair#stretch() stretch}
   *    .stagger(double) // required {@link QuantifiedBasePair#stagger() stagger}
   *    .buckle(double) // required {@link QuantifiedBasePair#buckle() buckle}
   *    .propeller(double) // required {@link QuantifiedBasePair#propeller() propeller}
   *    .opening(double) // required {@link QuantifiedBasePair#opening() opening}
   *    .build();
   * </pre>
   * @return A new ImmutableQuantifiedBasePair builder
   */
  public static ImmutableQuantifiedBasePair.Builder builder() {
    return new ImmutableQuantifiedBasePair.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQuantifiedBasePair ImmutableQuantifiedBasePair}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "QuantifiedBasePair", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_BASE_PAIR = 0x1L;
    private static final long INIT_BIT_SHEAR = 0x2L;
    private static final long INIT_BIT_STRETCH = 0x4L;
    private static final long INIT_BIT_STAGGER = 0x8L;
    private static final long INIT_BIT_BUCKLE = 0x10L;
    private static final long INIT_BIT_PROPELLER = 0x20L;
    private static final long INIT_BIT_OPENING = 0x40L;
    private static final long OPT_BIT_IS_REPRESENTED = 0x1L;
    private long initBits = 0x7fL;
    private long optBits;

    private @Nullable BasePair basePair;
    private @Nullable InteractionType interactionType;
    private @Nullable Saenger saenger;
    private @Nullable LeontisWesthof leontisWesthof;
    private @Nullable BPh bph;
    private @Nullable BR br;
    private boolean isRepresented;
    private double shear;
    private double stretch;
    private double stagger;
    private double buckle;
    private double propeller;
    private double opening;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.structure.ClassifiedBasePair} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ClassifiedBasePair instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.structure.QuantifiedBasePair} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(QuantifiedBasePair instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof ClassifiedBasePair) {
        ClassifiedBasePair instance = (ClassifiedBasePair) object;
        if ((bits & 0x8L) == 0) {
          br(instance.br());
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          interactionType(instance.interactionType());
          bits |= 0x10L;
        }
        if ((bits & 0x1L) == 0) {
          saenger(instance.saenger());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          basePair(instance.basePair());
          bits |= 0x2L;
        }
        if ((bits & 0x20L) == 0) {
          leontisWesthof(instance.leontisWesthof());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          bph(instance.bph());
          bits |= 0x40L;
        }
        if ((bits & 0x4L) == 0) {
          isRepresented(instance.isRepresented());
          bits |= 0x4L;
        }
      }
      if (object instanceof QuantifiedBasePair) {
        QuantifiedBasePair instance = (QuantifiedBasePair) object;
        shear(instance.shear());
        propeller(instance.propeller());
        if ((bits & 0x1L) == 0) {
          saenger(instance.saenger());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          basePair(instance.basePair());
          bits |= 0x2L;
        }
        stagger(instance.stagger());
        opening(instance.opening());
        buckle(instance.buckle());
        if ((bits & 0x4L) == 0) {
          isRepresented(instance.isRepresented());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          br(instance.br());
          bits |= 0x8L;
        }
        stretch(instance.stretch());
        if ((bits & 0x10L) == 0) {
          interactionType(instance.interactionType());
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          leontisWesthof(instance.leontisWesthof());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          bph(instance.bph());
          bits |= 0x40L;
        }
      }
    }

    /**
     * Initializes the value for the {@link QuantifiedBasePair#basePair() basePair} attribute.
     * @param basePair The value for basePair 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder basePair(BasePair basePair) {
      this.basePair = Objects.requireNonNull(basePair, "basePair");
      initBits &= ~INIT_BIT_BASE_PAIR;
      return this;
    }

    /**
     * Initializes the value for the {@link QuantifiedBasePair#interactionType() interactionType} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link QuantifiedBasePair#interactionType() interactionType}.</em>
     * @param interactionType The value for interactionType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder interactionType(InteractionType interactionType) {
      this.interactionType = Objects.requireNonNull(interactionType, "interactionType");
      return this;
    }

    /**
     * Initializes the value for the {@link QuantifiedBasePair#saenger() saenger} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link QuantifiedBasePair#saenger() saenger}.</em>
     * @param saenger The value for saenger 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder saenger(Saenger saenger) {
      this.saenger = Objects.requireNonNull(saenger, "saenger");
      return this;
    }

    /**
     * Initializes the value for the {@link QuantifiedBasePair#leontisWesthof() leontisWesthof} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link QuantifiedBasePair#leontisWesthof() leontisWesthof}.</em>
     * @param leontisWesthof The value for leontisWesthof 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder leontisWesthof(LeontisWesthof leontisWesthof) {
      this.leontisWesthof = Objects.requireNonNull(leontisWesthof, "leontisWesthof");
      return this;
    }

    /**
     * Initializes the value for the {@link QuantifiedBasePair#bph() bph} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link QuantifiedBasePair#bph() bph}.</em>
     * @param bph The value for bph 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bph(BPh bph) {
      this.bph = Objects.requireNonNull(bph, "bph");
      return this;
    }

    /**
     * Initializes the value for the {@link QuantifiedBasePair#br() br} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link QuantifiedBasePair#br() br}.</em>
     * @param br The value for br 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder br(BR br) {
      this.br = Objects.requireNonNull(br, "br");
      return this;
    }

    /**
     * Initializes the value for the {@link QuantifiedBasePair#isRepresented() isRepresented} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link QuantifiedBasePair#isRepresented() isRepresented}.</em>
     * @param isRepresented The value for isRepresented 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isRepresented(boolean isRepresented) {
      this.isRepresented = isRepresented;
      optBits |= OPT_BIT_IS_REPRESENTED;
      return this;
    }

    /**
     * Initializes the value for the {@link QuantifiedBasePair#shear() shear} attribute.
     * @param shear The value for shear 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder shear(double shear) {
      this.shear = shear;
      initBits &= ~INIT_BIT_SHEAR;
      return this;
    }

    /**
     * Initializes the value for the {@link QuantifiedBasePair#stretch() stretch} attribute.
     * @param stretch The value for stretch 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stretch(double stretch) {
      this.stretch = stretch;
      initBits &= ~INIT_BIT_STRETCH;
      return this;
    }

    /**
     * Initializes the value for the {@link QuantifiedBasePair#stagger() stagger} attribute.
     * @param stagger The value for stagger 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stagger(double stagger) {
      this.stagger = stagger;
      initBits &= ~INIT_BIT_STAGGER;
      return this;
    }

    /**
     * Initializes the value for the {@link QuantifiedBasePair#buckle() buckle} attribute.
     * @param buckle The value for buckle 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buckle(double buckle) {
      this.buckle = buckle;
      initBits &= ~INIT_BIT_BUCKLE;
      return this;
    }

    /**
     * Initializes the value for the {@link QuantifiedBasePair#propeller() propeller} attribute.
     * @param propeller The value for propeller 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder propeller(double propeller) {
      this.propeller = propeller;
      initBits &= ~INIT_BIT_PROPELLER;
      return this;
    }

    /**
     * Initializes the value for the {@link QuantifiedBasePair#opening() opening} attribute.
     * @param opening The value for opening 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder opening(double opening) {
      this.opening = opening;
      initBits &= ~INIT_BIT_OPENING;
      return this;
    }

    /**
     * Builds a new {@link ImmutableQuantifiedBasePair ImmutableQuantifiedBasePair}.
     * @return An immutable instance of QuantifiedBasePair
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQuantifiedBasePair build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableQuantifiedBasePair(this);
    }

    private boolean isRepresentedIsSet() {
      return (optBits & OPT_BIT_IS_REPRESENTED) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BASE_PAIR) != 0) attributes.add("basePair");
      if ((initBits & INIT_BIT_SHEAR) != 0) attributes.add("shear");
      if ((initBits & INIT_BIT_STRETCH) != 0) attributes.add("stretch");
      if ((initBits & INIT_BIT_STAGGER) != 0) attributes.add("stagger");
      if ((initBits & INIT_BIT_BUCKLE) != 0) attributes.add("buckle");
      if ((initBits & INIT_BIT_PROPELLER) != 0) attributes.add("propeller");
      if ((initBits & INIT_BIT_OPENING) != 0) attributes.add("opening");
      return "Cannot build QuantifiedBasePair, some of required attributes are not set " + attributes;
    }
  }
}
