package pl.poznan.put.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DotBracketSymbol}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDotBracketSymbol.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDotBracketSymbol.of()}.
 */
@Generated(from = "DotBracketSymbol", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableDotBracketSymbol extends DotBracketSymbol {
  private final char sequence;
  private final char structure;
  private final int index;

  private ImmutableDotBracketSymbol(char sequence, char structure, int index) {
    this.sequence = sequence;
    this.structure = structure;
    this.index = index;
  }

  private ImmutableDotBracketSymbol(ImmutableDotBracketSymbol original, char sequence, char structure, int index) {
    this.sequence = sequence;
    this.structure = structure;
    this.index = index;
  }

  /**
   *@return The sequence character. 
   */
  @Override
  public char sequence() {
    return sequence;
  }

  /**
   *@return The structure character (dot or bracket). 
   */
  @Override
  public char structure() {
    return structure;
  }

  /**
   *@return The index of this symbol. 
   */
  @Override
  public int index() {
    return index;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DotBracketSymbol#sequence() sequence} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sequence
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDotBracketSymbol withSequence(char value) {
    if (this.sequence == value) return this;
    return new ImmutableDotBracketSymbol(this, value, this.structure, this.index);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DotBracketSymbol#structure() structure} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for structure
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDotBracketSymbol withStructure(char value) {
    if (this.structure == value) return this;
    return new ImmutableDotBracketSymbol(this, this.sequence, value, this.index);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DotBracketSymbol#index() index} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for index
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDotBracketSymbol withIndex(int value) {
    if (this.index == value) return this;
    return new ImmutableDotBracketSymbol(this, this.sequence, this.structure, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDotBracketSymbol} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDotBracketSymbol
        && equalTo((ImmutableDotBracketSymbol) another);
  }

  private boolean equalTo(ImmutableDotBracketSymbol another) {
    return sequence == another.sequence
        && structure == another.structure
        && index == another.index;
  }

  /**
   * Computes a hash code from attributes: {@code sequence}, {@code structure}, {@code index}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Character.hashCode(sequence);
    h += (h << 5) + Character.hashCode(structure);
    h += (h << 5) + index;
    return h;
  }

  /**
   * Construct a new immutable {@code DotBracketSymbol} instance.
   * @param sequence The value for the {@code sequence} attribute
   * @param structure The value for the {@code structure} attribute
   * @param index The value for the {@code index} attribute
   * @return An immutable DotBracketSymbol instance
   */
  public static ImmutableDotBracketSymbol of(char sequence, char structure, int index) {
    return new ImmutableDotBracketSymbol(sequence, structure, index);
  }

  /**
   * Creates an immutable copy of a {@link DotBracketSymbol} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DotBracketSymbol instance
   */
  public static ImmutableDotBracketSymbol copyOf(DotBracketSymbol instance) {
    if (instance instanceof ImmutableDotBracketSymbol) {
      return (ImmutableDotBracketSymbol) instance;
    }
    return ImmutableDotBracketSymbol.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDotBracketSymbol ImmutableDotBracketSymbol}.
   * <pre>
   * ImmutableDotBracketSymbol.builder()
   *    .sequence(char) // required {@link DotBracketSymbol#sequence() sequence}
   *    .structure(char) // required {@link DotBracketSymbol#structure() structure}
   *    .index(int) // required {@link DotBracketSymbol#index() index}
   *    .build();
   * </pre>
   * @return A new ImmutableDotBracketSymbol builder
   */
  public static ImmutableDotBracketSymbol.Builder builder() {
    return new ImmutableDotBracketSymbol.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDotBracketSymbol ImmutableDotBracketSymbol}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DotBracketSymbol", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SEQUENCE = 0x1L;
    private static final long INIT_BIT_STRUCTURE = 0x2L;
    private static final long INIT_BIT_INDEX = 0x4L;
    private long initBits = 0x7L;

    private char sequence;
    private char structure;
    private int index;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DotBracketSymbol} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DotBracketSymbol instance) {
      Objects.requireNonNull(instance, "instance");
      sequence(instance.sequence());
      structure(instance.structure());
      index(instance.index());
      return this;
    }

    /**
     * Initializes the value for the {@link DotBracketSymbol#sequence() sequence} attribute.
     * @param sequence The value for sequence 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sequence(char sequence) {
      this.sequence = sequence;
      initBits &= ~INIT_BIT_SEQUENCE;
      return this;
    }

    /**
     * Initializes the value for the {@link DotBracketSymbol#structure() structure} attribute.
     * @param structure The value for structure 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder structure(char structure) {
      this.structure = structure;
      initBits &= ~INIT_BIT_STRUCTURE;
      return this;
    }

    /**
     * Initializes the value for the {@link DotBracketSymbol#index() index} attribute.
     * @param index The value for index 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder index(int index) {
      this.index = index;
      initBits &= ~INIT_BIT_INDEX;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDotBracketSymbol ImmutableDotBracketSymbol}.
     * @return An immutable instance of DotBracketSymbol
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDotBracketSymbol build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDotBracketSymbol(null, sequence, structure, index);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SEQUENCE) != 0) attributes.add("sequence");
      if ((initBits & INIT_BIT_STRUCTURE) != 0) attributes.add("structure");
      if ((initBits & INIT_BIT_INDEX) != 0) attributes.add("index");
      return "Cannot build DotBracketSymbol, some of required attributes are not set " + attributes;
    }
  }
}
