package pl.poznan.put.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.pdb.PdbNamedResidueIdentifier;

/**
 * Immutable implementation of {@link BasePair}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBasePair.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableBasePair.of()}.
 */
@Generated(from = "BasePair", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableBasePair extends BasePair {
  private final PdbNamedResidueIdentifier left;
  private final PdbNamedResidueIdentifier right;

  private ImmutableBasePair(PdbNamedResidueIdentifier left, PdbNamedResidueIdentifier right) {
    this.left = Objects.requireNonNull(left, "left");
    this.right = Objects.requireNonNull(right, "right");
  }

  private ImmutableBasePair(
      ImmutableBasePair original,
      PdbNamedResidueIdentifier left,
      PdbNamedResidueIdentifier right) {
    this.left = left;
    this.right = right;
  }

  /**
   *@return The first residue. 
   */
  @Override
  public PdbNamedResidueIdentifier left() {
    return left;
  }

  /**
   *@return The second residue. 
   */
  @Override
  public PdbNamedResidueIdentifier right() {
    return right;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BasePair#left() left} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBasePair withLeft(PdbNamedResidueIdentifier value) {
    if (this.left == value) return this;
    PdbNamedResidueIdentifier newValue = Objects.requireNonNull(value, "left");
    return new ImmutableBasePair(this, newValue, this.right);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BasePair#right() right} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for right
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBasePair withRight(PdbNamedResidueIdentifier value) {
    if (this.right == value) return this;
    PdbNamedResidueIdentifier newValue = Objects.requireNonNull(value, "right");
    return new ImmutableBasePair(this, this.left, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBasePair} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBasePair
        && equalTo((ImmutableBasePair) another);
  }

  private boolean equalTo(ImmutableBasePair another) {
    return left.equals(another.left)
        && right.equals(another.right);
  }

  /**
   * Computes a hash code from attributes: {@code left}, {@code right}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + left.hashCode();
    h += (h << 5) + right.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code BasePair} instance.
   * @param left The value for the {@code left} attribute
   * @param right The value for the {@code right} attribute
   * @return An immutable BasePair instance
   */
  public static ImmutableBasePair of(PdbNamedResidueIdentifier left, PdbNamedResidueIdentifier right) {
    return new ImmutableBasePair(left, right);
  }

  /**
   * Creates an immutable copy of a {@link BasePair} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BasePair instance
   */
  public static ImmutableBasePair copyOf(BasePair instance) {
    if (instance instanceof ImmutableBasePair) {
      return (ImmutableBasePair) instance;
    }
    return ImmutableBasePair.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBasePair ImmutableBasePair}.
   * <pre>
   * ImmutableBasePair.builder()
   *    .left(pl.poznan.put.pdb.PdbNamedResidueIdentifier) // required {@link BasePair#left() left}
   *    .right(pl.poznan.put.pdb.PdbNamedResidueIdentifier) // required {@link BasePair#right() right}
   *    .build();
   * </pre>
   * @return A new ImmutableBasePair builder
   */
  public static ImmutableBasePair.Builder builder() {
    return new ImmutableBasePair.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBasePair ImmutableBasePair}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BasePair", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_LEFT = 0x1L;
    private static final long INIT_BIT_RIGHT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable PdbNamedResidueIdentifier left;
    private @Nullable PdbNamedResidueIdentifier right;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BasePair} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BasePair instance) {
      Objects.requireNonNull(instance, "instance");
      left(instance.left());
      right(instance.right());
      return this;
    }

    /**
     * Initializes the value for the {@link BasePair#left() left} attribute.
     * @param left The value for left 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder left(PdbNamedResidueIdentifier left) {
      this.left = Objects.requireNonNull(left, "left");
      initBits &= ~INIT_BIT_LEFT;
      return this;
    }

    /**
     * Initializes the value for the {@link BasePair#right() right} attribute.
     * @param right The value for right 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder right(PdbNamedResidueIdentifier right) {
      this.right = Objects.requireNonNull(right, "right");
      initBits &= ~INIT_BIT_RIGHT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBasePair ImmutableBasePair}.
     * @return An immutable instance of BasePair
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBasePair build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBasePair(null, left, right);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LEFT) != 0) attributes.add("left");
      if ((initBits & INIT_BIT_RIGHT) != 0) attributes.add("right");
      return "Cannot build BasePair, some of required attributes are not set " + attributes;
    }
  }
}
