package pl.poznan.put.rna;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.immutables.value.Generated;
import pl.poznan.put.pdb.PdbAtomLine;

/**
 * Immutable implementation of {@link StandardReferenceFrame}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStandardReferenceFrame.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableStandardReferenceFrame.of()}.
 */
@Generated(from = "StandardReferenceFrame", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableStandardReferenceFrame extends StandardReferenceFrame {
  private final Vector3D origin;
  private final Vector3D x;
  private final Vector3D y;
  private final Vector3D z;
  private final Optional<PdbAtomLine> longAxisAtom;

  private ImmutableStandardReferenceFrame(
      Vector3D origin,
      Vector3D x,
      Vector3D y,
      Vector3D z) {
    this.origin = Objects.requireNonNull(origin, "origin");
    this.x = Objects.requireNonNull(x, "x");
    this.y = Objects.requireNonNull(y, "y");
    this.z = Objects.requireNonNull(z, "z");
    this.longAxisAtom = Objects.requireNonNull(super.longAxisAtom(), "longAxisAtom");
  }

  private ImmutableStandardReferenceFrame(ImmutableStandardReferenceFrame.Builder builder) {
    this.origin = builder.origin;
    this.x = builder.x;
    this.y = builder.y;
    this.z = builder.z;
    this.longAxisAtom = builder.longAxisAtom != null
        ? builder.longAxisAtom
        : Objects.requireNonNull(super.longAxisAtom(), "longAxisAtom");
  }

  private ImmutableStandardReferenceFrame(
      Vector3D origin,
      Vector3D x,
      Vector3D y,
      Vector3D z,
      Optional<PdbAtomLine> longAxisAtom) {
    this.origin = origin;
    this.x = x;
    this.y = y;
    this.z = z;
    this.longAxisAtom = longAxisAtom;
  }

  /**
   * @return The value of the {@code origin} attribute
   */
  @Override
  public Vector3D origin() {
    return origin;
  }

  /**
   * @return The value of the {@code x} attribute
   */
  @Override
  public Vector3D x() {
    return x;
  }

  /**
   * @return The value of the {@code y} attribute
   */
  @Override
  public Vector3D y() {
    return y;
  }

  /**
   * @return The value of the {@code z} attribute
   */
  @Override
  public Vector3D z() {
    return z;
  }

  /**
   * @return The value of the {@code longAxisAtom} attribute
   */
  @Override
  public Optional<PdbAtomLine> longAxisAtom() {
    return longAxisAtom;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StandardReferenceFrame#origin() origin} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for origin
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStandardReferenceFrame withOrigin(Vector3D value) {
    if (this.origin == value) return this;
    Vector3D newValue = Objects.requireNonNull(value, "origin");
    return new ImmutableStandardReferenceFrame(newValue, this.x, this.y, this.z, this.longAxisAtom);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StandardReferenceFrame#x() x} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for x
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStandardReferenceFrame withX(Vector3D value) {
    if (this.x == value) return this;
    Vector3D newValue = Objects.requireNonNull(value, "x");
    return new ImmutableStandardReferenceFrame(this.origin, newValue, this.y, this.z, this.longAxisAtom);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StandardReferenceFrame#y() y} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for y
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStandardReferenceFrame withY(Vector3D value) {
    if (this.y == value) return this;
    Vector3D newValue = Objects.requireNonNull(value, "y");
    return new ImmutableStandardReferenceFrame(this.origin, this.x, newValue, this.z, this.longAxisAtom);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StandardReferenceFrame#z() z} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for z
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStandardReferenceFrame withZ(Vector3D value) {
    if (this.z == value) return this;
    Vector3D newValue = Objects.requireNonNull(value, "z");
    return new ImmutableStandardReferenceFrame(this.origin, this.x, this.y, newValue, this.longAxisAtom);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StandardReferenceFrame#longAxisAtom() longAxisAtom} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for longAxisAtom
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStandardReferenceFrame withLongAxisAtom(Optional<PdbAtomLine> value) {
    Optional<PdbAtomLine> newValue = Objects.requireNonNull(value, "longAxisAtom");
    if (this.longAxisAtom.equals(newValue)) return this;
    return new ImmutableStandardReferenceFrame(this.origin, this.x, this.y, this.z, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStandardReferenceFrame} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStandardReferenceFrame
        && equalTo((ImmutableStandardReferenceFrame) another);
  }

  private boolean equalTo(ImmutableStandardReferenceFrame another) {
    return origin.equals(another.origin)
        && x.equals(another.x)
        && y.equals(another.y)
        && z.equals(another.z)
        && longAxisAtom.equals(another.longAxisAtom);
  }

  /**
   * Computes a hash code from attributes: {@code origin}, {@code x}, {@code y}, {@code z}, {@code longAxisAtom}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + origin.hashCode();
    h += (h << 5) + x.hashCode();
    h += (h << 5) + y.hashCode();
    h += (h << 5) + z.hashCode();
    h += (h << 5) + longAxisAtom.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StandardReferenceFrame} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StandardReferenceFrame{"
        + "origin=" + origin
        + ", x=" + x
        + ", y=" + y
        + ", z=" + z
        + ", longAxisAtom=" + longAxisAtom
        + "}";
  }

  /**
   * Construct a new immutable {@code StandardReferenceFrame} instance.
   * @param origin The value for the {@code origin} attribute
   * @param x The value for the {@code x} attribute
   * @param y The value for the {@code y} attribute
   * @param z The value for the {@code z} attribute
   * @return An immutable StandardReferenceFrame instance
   */
  public static ImmutableStandardReferenceFrame of(Vector3D origin, Vector3D x, Vector3D y, Vector3D z) {
    return new ImmutableStandardReferenceFrame(origin, x, y, z);
  }

  /**
   * Creates an immutable copy of a {@link StandardReferenceFrame} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StandardReferenceFrame instance
   */
  public static ImmutableStandardReferenceFrame copyOf(StandardReferenceFrame instance) {
    if (instance instanceof ImmutableStandardReferenceFrame) {
      return (ImmutableStandardReferenceFrame) instance;
    }
    return ImmutableStandardReferenceFrame.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStandardReferenceFrame ImmutableStandardReferenceFrame}.
   * <pre>
   * ImmutableStandardReferenceFrame.builder()
   *    .origin(org.apache.commons.math3.geometry.euclidean.threed.Vector3D) // required {@link StandardReferenceFrame#origin() origin}
   *    .x(org.apache.commons.math3.geometry.euclidean.threed.Vector3D) // required {@link StandardReferenceFrame#x() x}
   *    .y(org.apache.commons.math3.geometry.euclidean.threed.Vector3D) // required {@link StandardReferenceFrame#y() y}
   *    .z(org.apache.commons.math3.geometry.euclidean.threed.Vector3D) // required {@link StandardReferenceFrame#z() z}
   *    .longAxisAtom(Optional&amp;lt;pl.poznan.put.pdb.PdbAtomLine&amp;gt;) // optional {@link StandardReferenceFrame#longAxisAtom() longAxisAtom}
   *    .build();
   * </pre>
   * @return A new ImmutableStandardReferenceFrame builder
   */
  public static ImmutableStandardReferenceFrame.Builder builder() {
    return new ImmutableStandardReferenceFrame.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStandardReferenceFrame ImmutableStandardReferenceFrame}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StandardReferenceFrame", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ORIGIN = 0x1L;
    private static final long INIT_BIT_X = 0x2L;
    private static final long INIT_BIT_Y = 0x4L;
    private static final long INIT_BIT_Z = 0x8L;
    private long initBits = 0xfL;

    private @Nullable Vector3D origin;
    private @Nullable Vector3D x;
    private @Nullable Vector3D y;
    private @Nullable Vector3D z;
    private @Nullable Optional<PdbAtomLine> longAxisAtom;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StandardReferenceFrame} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(StandardReferenceFrame instance) {
      Objects.requireNonNull(instance, "instance");
      origin(instance.origin());
      x(instance.x());
      y(instance.y());
      z(instance.z());
      longAxisAtom(instance.longAxisAtom());
      return this;
    }

    /**
     * Initializes the value for the {@link StandardReferenceFrame#origin() origin} attribute.
     * @param origin The value for origin 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder origin(Vector3D origin) {
      this.origin = Objects.requireNonNull(origin, "origin");
      initBits &= ~INIT_BIT_ORIGIN;
      return this;
    }

    /**
     * Initializes the value for the {@link StandardReferenceFrame#x() x} attribute.
     * @param x The value for x 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder x(Vector3D x) {
      this.x = Objects.requireNonNull(x, "x");
      initBits &= ~INIT_BIT_X;
      return this;
    }

    /**
     * Initializes the value for the {@link StandardReferenceFrame#y() y} attribute.
     * @param y The value for y 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder y(Vector3D y) {
      this.y = Objects.requireNonNull(y, "y");
      initBits &= ~INIT_BIT_Y;
      return this;
    }

    /**
     * Initializes the value for the {@link StandardReferenceFrame#z() z} attribute.
     * @param z The value for z 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder z(Vector3D z) {
      this.z = Objects.requireNonNull(z, "z");
      initBits &= ~INIT_BIT_Z;
      return this;
    }

    /**
     * Initializes the value for the {@link StandardReferenceFrame#longAxisAtom() longAxisAtom} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link StandardReferenceFrame#longAxisAtom() longAxisAtom}.</em>
     * @param longAxisAtom The value for longAxisAtom 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder longAxisAtom(Optional<PdbAtomLine> longAxisAtom) {
      this.longAxisAtom = Objects.requireNonNull(longAxisAtom, "longAxisAtom");
      return this;
    }

    /**
     * Builds a new {@link ImmutableStandardReferenceFrame ImmutableStandardReferenceFrame}.
     * @return An immutable instance of StandardReferenceFrame
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStandardReferenceFrame build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStandardReferenceFrame(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORIGIN) != 0) attributes.add("origin");
      if ((initBits & INIT_BIT_X) != 0) attributes.add("x");
      if ((initBits & INIT_BIT_Y) != 0) attributes.add("y");
      if ((initBits & INIT_BIT_Z) != 0) attributes.add("z");
      return "Cannot build StandardReferenceFrame, some of required attributes are not set " + attributes;
    }
  }
}
