package pl.poznan.put.rna;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link InteractionType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableInteractionType.builder()}.
 */
@Generated(from = "InteractionType", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableInteractionType extends InteractionType {
  private final NucleotideComponentType left;
  private final NucleotideComponentType right;
  private final boolean isPairing;
  private final String description;

  private ImmutableInteractionType(ImmutableInteractionType.Builder builder) {
    this.left = builder.left;
    this.right = builder.right;
    this.isPairing = builder.isPairing;
    this.description = builder.description != null
        ? builder.description
        : Objects.requireNonNull(super.description(), "description");
  }

  private ImmutableInteractionType(
      NucleotideComponentType left,
      NucleotideComponentType right,
      boolean isPairing,
      String description) {
    this.left = left;
    this.right = right;
    this.isPairing = isPairing;
    this.description = description;
  }

  /**
   *@return The first interacting partner. 
   */
  @Override
  public NucleotideComponentType left() {
    return left;
  }

  /**
   *@return The second interacting partner. 
   */
  @Override
  public NucleotideComponentType right() {
    return right;
  }

  /**
   * Checks if this interaction is a basis for base pairing.
   * @return True for {@code BASE_BASE}, false for all other types.
   */
  @Override
  public boolean isPairing() {
    return isPairing;
  }

  /**
   *@return The description of this interaction type. 
   */
  @Override
  public String description() {
    return description;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractionType#left() left} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInteractionType withLeft(NucleotideComponentType value) {
    if (this.left == value) return this;
    NucleotideComponentType newValue = Objects.requireNonNull(value, "left");
    if (this.left.equals(newValue)) return this;
    return new ImmutableInteractionType(newValue, this.right, this.isPairing, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractionType#right() right} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for right
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInteractionType withRight(NucleotideComponentType value) {
    if (this.right == value) return this;
    NucleotideComponentType newValue = Objects.requireNonNull(value, "right");
    if (this.right.equals(newValue)) return this;
    return new ImmutableInteractionType(this.left, newValue, this.isPairing, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractionType#isPairing() isPairing} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isPairing
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInteractionType withIsPairing(boolean value) {
    if (this.isPairing == value) return this;
    return new ImmutableInteractionType(this.left, this.right, value, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractionType#description() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInteractionType withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (this.description.equals(newValue)) return this;
    return new ImmutableInteractionType(this.left, this.right, this.isPairing, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableInteractionType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableInteractionType
        && equalTo((ImmutableInteractionType) another);
  }

  private boolean equalTo(ImmutableInteractionType another) {
    return left.equals(another.left)
        && right.equals(another.right)
        && isPairing == another.isPairing
        && description.equals(another.description);
  }

  /**
   * Computes a hash code from attributes: {@code left}, {@code right}, {@code isPairing}, {@code description}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + left.hashCode();
    h += (h << 5) + right.hashCode();
    h += (h << 5) + Boolean.hashCode(isPairing);
    h += (h << 5) + description.hashCode();
    return h;
  }

  /**
   * Creates an immutable copy of a {@link InteractionType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InteractionType instance
   */
  public static ImmutableInteractionType copyOf(InteractionType instance) {
    if (instance instanceof ImmutableInteractionType) {
      return (ImmutableInteractionType) instance;
    }
    return ImmutableInteractionType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableInteractionType ImmutableInteractionType}.
   * <pre>
   * ImmutableInteractionType.builder()
   *    .left(pl.poznan.put.rna.NucleotideComponentType) // required {@link InteractionType#left() left}
   *    .right(pl.poznan.put.rna.NucleotideComponentType) // required {@link InteractionType#right() right}
   *    .isPairing(boolean) // required {@link InteractionType#isPairing() isPairing}
   *    .description(String) // optional {@link InteractionType#description() description}
   *    .build();
   * </pre>
   * @return A new ImmutableInteractionType builder
   */
  public static ImmutableInteractionType.Builder builder() {
    return new ImmutableInteractionType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableInteractionType ImmutableInteractionType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "InteractionType", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_LEFT = 0x1L;
    private static final long INIT_BIT_RIGHT = 0x2L;
    private static final long INIT_BIT_IS_PAIRING = 0x4L;
    private long initBits = 0x7L;

    private @Nullable NucleotideComponentType left;
    private @Nullable NucleotideComponentType right;
    private boolean isPairing;
    private @Nullable String description;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InteractionType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InteractionType instance) {
      Objects.requireNonNull(instance, "instance");
      left(instance.left());
      right(instance.right());
      isPairing(instance.isPairing());
      description(instance.description());
      return this;
    }

    /**
     * Initializes the value for the {@link InteractionType#left() left} attribute.
     * @param left The value for left 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder left(NucleotideComponentType left) {
      this.left = Objects.requireNonNull(left, "left");
      initBits &= ~INIT_BIT_LEFT;
      return this;
    }

    /**
     * Initializes the value for the {@link InteractionType#right() right} attribute.
     * @param right The value for right 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder right(NucleotideComponentType right) {
      this.right = Objects.requireNonNull(right, "right");
      initBits &= ~INIT_BIT_RIGHT;
      return this;
    }

    /**
     * Initializes the value for the {@link InteractionType#isPairing() isPairing} attribute.
     * @param isPairing The value for isPairing 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isPairing(boolean isPairing) {
      this.isPairing = isPairing;
      initBits &= ~INIT_BIT_IS_PAIRING;
      return this;
    }

    /**
     * Initializes the value for the {@link InteractionType#description() description} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link InteractionType#description() description}.</em>
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      return this;
    }

    /**
     * Builds a new {@link ImmutableInteractionType ImmutableInteractionType}.
     * @return An immutable instance of InteractionType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableInteractionType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableInteractionType(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LEFT) != 0) attributes.add("left");
      if ((initBits & INIT_BIT_RIGHT) != 0) attributes.add("right");
      if ((initBits & INIT_BIT_IS_PAIRING) != 0) attributes.add("isPairing");
      return "Cannot build InteractionType, some of required attributes are not set " + attributes;
    }
  }
}
