package pl.poznan.put.rna;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.circular.Angle;

/**
 * Immutable implementation of {@link BasePairParameters}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBasePairParameters.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableBasePairParameters.of()}.
 */
@Generated(from = "BasePairParameters", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableBasePairParameters extends BasePairParameters {
  private final double shear;
  private final double stretch;
  private final double stagger;
  private final Angle buckle;
  private final Angle propeller;
  private final Angle opening;
  private final Angle interBaseAngle;

  private ImmutableBasePairParameters(
      double shear,
      double stretch,
      double stagger,
      Angle buckle,
      Angle propeller,
      Angle opening,
      Angle interBaseAngle) {
    this.shear = shear;
    this.stretch = stretch;
    this.stagger = stagger;
    this.buckle = Objects.requireNonNull(buckle, "buckle");
    this.propeller = Objects.requireNonNull(propeller, "propeller");
    this.opening = Objects.requireNonNull(opening, "opening");
    this.interBaseAngle = Objects.requireNonNull(interBaseAngle, "interBaseAngle");
  }

  private ImmutableBasePairParameters(
      ImmutableBasePairParameters original,
      double shear,
      double stretch,
      double stagger,
      Angle buckle,
      Angle propeller,
      Angle opening,
      Angle interBaseAngle) {
    this.shear = shear;
    this.stretch = stretch;
    this.stagger = stagger;
    this.buckle = buckle;
    this.propeller = propeller;
    this.opening = opening;
    this.interBaseAngle = interBaseAngle;
  }

  /**
   * @return The value of the {@code shear} attribute
   */
  @Override
  public double shear() {
    return shear;
  }

  /**
   * @return The value of the {@code stretch} attribute
   */
  @Override
  public double stretch() {
    return stretch;
  }

  /**
   * @return The value of the {@code stagger} attribute
   */
  @Override
  public double stagger() {
    return stagger;
  }

  /**
   * @return The value of the {@code buckle} attribute
   */
  @Override
  public Angle buckle() {
    return buckle;
  }

  /**
   * @return The value of the {@code propeller} attribute
   */
  @Override
  public Angle propeller() {
    return propeller;
  }

  /**
   * @return The value of the {@code opening} attribute
   */
  @Override
  public Angle opening() {
    return opening;
  }

  /**
   * @return The value of the {@code interBaseAngle} attribute
   */
  @Override
  public Angle interBaseAngle() {
    return interBaseAngle;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BasePairParameters#shear() shear} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for shear
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBasePairParameters withShear(double value) {
    if (Double.doubleToLongBits(this.shear) == Double.doubleToLongBits(value)) return this;
    return new ImmutableBasePairParameters(
        this,
        value,
        this.stretch,
        this.stagger,
        this.buckle,
        this.propeller,
        this.opening,
        this.interBaseAngle);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BasePairParameters#stretch() stretch} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stretch
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBasePairParameters withStretch(double value) {
    if (Double.doubleToLongBits(this.stretch) == Double.doubleToLongBits(value)) return this;
    return new ImmutableBasePairParameters(
        this,
        this.shear,
        value,
        this.stagger,
        this.buckle,
        this.propeller,
        this.opening,
        this.interBaseAngle);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BasePairParameters#stagger() stagger} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stagger
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBasePairParameters withStagger(double value) {
    if (Double.doubleToLongBits(this.stagger) == Double.doubleToLongBits(value)) return this;
    return new ImmutableBasePairParameters(
        this,
        this.shear,
        this.stretch,
        value,
        this.buckle,
        this.propeller,
        this.opening,
        this.interBaseAngle);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BasePairParameters#buckle() buckle} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for buckle
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBasePairParameters withBuckle(Angle value) {
    if (this.buckle == value) return this;
    Angle newValue = Objects.requireNonNull(value, "buckle");
    return new ImmutableBasePairParameters(
        this,
        this.shear,
        this.stretch,
        this.stagger,
        newValue,
        this.propeller,
        this.opening,
        this.interBaseAngle);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BasePairParameters#propeller() propeller} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for propeller
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBasePairParameters withPropeller(Angle value) {
    if (this.propeller == value) return this;
    Angle newValue = Objects.requireNonNull(value, "propeller");
    return new ImmutableBasePairParameters(
        this,
        this.shear,
        this.stretch,
        this.stagger,
        this.buckle,
        newValue,
        this.opening,
        this.interBaseAngle);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BasePairParameters#opening() opening} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for opening
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBasePairParameters withOpening(Angle value) {
    if (this.opening == value) return this;
    Angle newValue = Objects.requireNonNull(value, "opening");
    return new ImmutableBasePairParameters(
        this,
        this.shear,
        this.stretch,
        this.stagger,
        this.buckle,
        this.propeller,
        newValue,
        this.interBaseAngle);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BasePairParameters#interBaseAngle() interBaseAngle} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for interBaseAngle
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBasePairParameters withInterBaseAngle(Angle value) {
    if (this.interBaseAngle == value) return this;
    Angle newValue = Objects.requireNonNull(value, "interBaseAngle");
    return new ImmutableBasePairParameters(
        this,
        this.shear,
        this.stretch,
        this.stagger,
        this.buckle,
        this.propeller,
        this.opening,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBasePairParameters} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBasePairParameters
        && equalTo((ImmutableBasePairParameters) another);
  }

  private boolean equalTo(ImmutableBasePairParameters another) {
    return Double.doubleToLongBits(shear) == Double.doubleToLongBits(another.shear)
        && Double.doubleToLongBits(stretch) == Double.doubleToLongBits(another.stretch)
        && Double.doubleToLongBits(stagger) == Double.doubleToLongBits(another.stagger)
        && buckle.equals(another.buckle)
        && propeller.equals(another.propeller)
        && opening.equals(another.opening)
        && interBaseAngle.equals(another.interBaseAngle);
  }

  /**
   * Computes a hash code from attributes: {@code shear}, {@code stretch}, {@code stagger}, {@code buckle}, {@code propeller}, {@code opening}, {@code interBaseAngle}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Double.hashCode(shear);
    h += (h << 5) + Double.hashCode(stretch);
    h += (h << 5) + Double.hashCode(stagger);
    h += (h << 5) + buckle.hashCode();
    h += (h << 5) + propeller.hashCode();
    h += (h << 5) + opening.hashCode();
    h += (h << 5) + interBaseAngle.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BasePairParameters} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BasePairParameters{"
        + "shear=" + shear
        + ", stretch=" + stretch
        + ", stagger=" + stagger
        + ", buckle=" + buckle
        + ", propeller=" + propeller
        + ", opening=" + opening
        + ", interBaseAngle=" + interBaseAngle
        + "}";
  }

  /**
   * Construct a new immutable {@code BasePairParameters} instance.
   * @param shear The value for the {@code shear} attribute
   * @param stretch The value for the {@code stretch} attribute
   * @param stagger The value for the {@code stagger} attribute
   * @param buckle The value for the {@code buckle} attribute
   * @param propeller The value for the {@code propeller} attribute
   * @param opening The value for the {@code opening} attribute
   * @param interBaseAngle The value for the {@code interBaseAngle} attribute
   * @return An immutable BasePairParameters instance
   */
  public static ImmutableBasePairParameters of(double shear, double stretch, double stagger, Angle buckle, Angle propeller, Angle opening, Angle interBaseAngle) {
    return new ImmutableBasePairParameters(shear, stretch, stagger, buckle, propeller, opening, interBaseAngle);
  }

  /**
   * Creates an immutable copy of a {@link BasePairParameters} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BasePairParameters instance
   */
  public static ImmutableBasePairParameters copyOf(BasePairParameters instance) {
    if (instance instanceof ImmutableBasePairParameters) {
      return (ImmutableBasePairParameters) instance;
    }
    return ImmutableBasePairParameters.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBasePairParameters ImmutableBasePairParameters}.
   * <pre>
   * ImmutableBasePairParameters.builder()
   *    .shear(double) // required {@link BasePairParameters#shear() shear}
   *    .stretch(double) // required {@link BasePairParameters#stretch() stretch}
   *    .stagger(double) // required {@link BasePairParameters#stagger() stagger}
   *    .buckle(pl.poznan.put.circular.Angle) // required {@link BasePairParameters#buckle() buckle}
   *    .propeller(pl.poznan.put.circular.Angle) // required {@link BasePairParameters#propeller() propeller}
   *    .opening(pl.poznan.put.circular.Angle) // required {@link BasePairParameters#opening() opening}
   *    .interBaseAngle(pl.poznan.put.circular.Angle) // required {@link BasePairParameters#interBaseAngle() interBaseAngle}
   *    .build();
   * </pre>
   * @return A new ImmutableBasePairParameters builder
   */
  public static ImmutableBasePairParameters.Builder builder() {
    return new ImmutableBasePairParameters.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBasePairParameters ImmutableBasePairParameters}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BasePairParameters", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SHEAR = 0x1L;
    private static final long INIT_BIT_STRETCH = 0x2L;
    private static final long INIT_BIT_STAGGER = 0x4L;
    private static final long INIT_BIT_BUCKLE = 0x8L;
    private static final long INIT_BIT_PROPELLER = 0x10L;
    private static final long INIT_BIT_OPENING = 0x20L;
    private static final long INIT_BIT_INTER_BASE_ANGLE = 0x40L;
    private long initBits = 0x7fL;

    private double shear;
    private double stretch;
    private double stagger;
    private @Nullable Angle buckle;
    private @Nullable Angle propeller;
    private @Nullable Angle opening;
    private @Nullable Angle interBaseAngle;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BasePairParameters} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BasePairParameters instance) {
      Objects.requireNonNull(instance, "instance");
      shear(instance.shear());
      stretch(instance.stretch());
      stagger(instance.stagger());
      buckle(instance.buckle());
      propeller(instance.propeller());
      opening(instance.opening());
      interBaseAngle(instance.interBaseAngle());
      return this;
    }

    /**
     * Initializes the value for the {@link BasePairParameters#shear() shear} attribute.
     * @param shear The value for shear 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder shear(double shear) {
      this.shear = shear;
      initBits &= ~INIT_BIT_SHEAR;
      return this;
    }

    /**
     * Initializes the value for the {@link BasePairParameters#stretch() stretch} attribute.
     * @param stretch The value for stretch 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stretch(double stretch) {
      this.stretch = stretch;
      initBits &= ~INIT_BIT_STRETCH;
      return this;
    }

    /**
     * Initializes the value for the {@link BasePairParameters#stagger() stagger} attribute.
     * @param stagger The value for stagger 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stagger(double stagger) {
      this.stagger = stagger;
      initBits &= ~INIT_BIT_STAGGER;
      return this;
    }

    /**
     * Initializes the value for the {@link BasePairParameters#buckle() buckle} attribute.
     * @param buckle The value for buckle 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buckle(Angle buckle) {
      this.buckle = Objects.requireNonNull(buckle, "buckle");
      initBits &= ~INIT_BIT_BUCKLE;
      return this;
    }

    /**
     * Initializes the value for the {@link BasePairParameters#propeller() propeller} attribute.
     * @param propeller The value for propeller 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder propeller(Angle propeller) {
      this.propeller = Objects.requireNonNull(propeller, "propeller");
      initBits &= ~INIT_BIT_PROPELLER;
      return this;
    }

    /**
     * Initializes the value for the {@link BasePairParameters#opening() opening} attribute.
     * @param opening The value for opening 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder opening(Angle opening) {
      this.opening = Objects.requireNonNull(opening, "opening");
      initBits &= ~INIT_BIT_OPENING;
      return this;
    }

    /**
     * Initializes the value for the {@link BasePairParameters#interBaseAngle() interBaseAngle} attribute.
     * @param interBaseAngle The value for interBaseAngle 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder interBaseAngle(Angle interBaseAngle) {
      this.interBaseAngle = Objects.requireNonNull(interBaseAngle, "interBaseAngle");
      initBits &= ~INIT_BIT_INTER_BASE_ANGLE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBasePairParameters ImmutableBasePairParameters}.
     * @return An immutable instance of BasePairParameters
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBasePairParameters build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBasePairParameters(null, shear, stretch, stagger, buckle, propeller, opening, interBaseAngle);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SHEAR) != 0) attributes.add("shear");
      if ((initBits & INIT_BIT_STRETCH) != 0) attributes.add("stretch");
      if ((initBits & INIT_BIT_STAGGER) != 0) attributes.add("stagger");
      if ((initBits & INIT_BIT_BUCKLE) != 0) attributes.add("buckle");
      if ((initBits & INIT_BIT_PROPELLER) != 0) attributes.add("propeller");
      if ((initBits & INIT_BIT_OPENING) != 0) attributes.add("opening");
      if ((initBits & INIT_BIT_INTER_BASE_ANGLE) != 0) attributes.add("interBaseAngle");
      return "Cannot build BasePairParameters, some of required attributes are not set " + attributes;
    }
  }
}
