package pl.poznan.put.protein;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Cysteine}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCysteine.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableCysteine.of()}.
 */
@Generated(from = "Cysteine", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
final class ImmutableCysteine extends Cysteine {

  private ImmutableCysteine() {}

  /**
   * This instance is equal to all instances of {@code ImmutableCysteine} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCysteine
        && equalTo((ImmutableCysteine) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(ImmutableCysteine another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 0;
  }

  /**
   * Prints the immutable value {@code Cysteine}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Cysteine{}";
  }

  private static final ImmutableCysteine INSTANCE = validate(new ImmutableCysteine());

  /**
   * Returns the default immutable singleton value of {@code Cysteine}
   * @return An immutable instance of Cysteine
   */
  public static ImmutableCysteine of() {
    return INSTANCE;
  }

  private static ImmutableCysteine validate(ImmutableCysteine instance) {
    return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link Cysteine} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Cysteine instance
   */
  public static ImmutableCysteine copyOf(Cysteine instance) {
    if (instance instanceof ImmutableCysteine) {
      return (ImmutableCysteine) instance;
    }
    return ImmutableCysteine.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCysteine ImmutableCysteine}.
   * <pre>
   * ImmutableCysteine.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableCysteine builder
   */
  public static ImmutableCysteine.Builder builder() {
    return new ImmutableCysteine.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCysteine ImmutableCysteine}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Cysteine", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Cysteine} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Cysteine instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableCysteine ImmutableCysteine}.
     * @return An immutable instance of Cysteine
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCysteine build() {
      return ImmutableCysteine.of();
    }
  }
}
