package pl.poznan.put.protein;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Backbone}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBackbone.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableBackbone.of()}.
 */
@Generated(from = "Backbone", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableBackbone implements Backbone {

  private ImmutableBackbone() {}

  /**
   * This instance is equal to all instances of {@code ImmutableBackbone} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBackbone
        && equalTo((ImmutableBackbone) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(ImmutableBackbone another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 0;
  }

  /**
   * Prints the immutable value {@code Backbone}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Backbone{}";
  }

  private static final ImmutableBackbone INSTANCE = validate(new ImmutableBackbone());

  /**
   * Returns the default immutable singleton value of {@code Backbone}
   * @return An immutable instance of Backbone
   */
  public static ImmutableBackbone of() {
    return INSTANCE;
  }

  private static ImmutableBackbone validate(ImmutableBackbone instance) {
    return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link Backbone} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Backbone instance
   */
  public static ImmutableBackbone copyOf(Backbone instance) {
    if (instance instanceof ImmutableBackbone) {
      return (ImmutableBackbone) instance;
    }
    return ImmutableBackbone.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBackbone ImmutableBackbone}.
   * <pre>
   * ImmutableBackbone.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableBackbone builder
   */
  public static ImmutableBackbone.Builder builder() {
    return new ImmutableBackbone.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBackbone ImmutableBackbone}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Backbone", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Backbone} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Backbone instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableBackbone ImmutableBackbone}.
     * @return An immutable instance of Backbone
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBackbone build() {
      return ImmutableBackbone.of();
    }
  }
}
