package pl.poznan.put.pdb.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.pdb.PdbResidueIdentifier;
import pl.poznan.put.torsion.TorsionAngleValue;

/**
 * Immutable implementation of {@link ResidueTorsionAngles}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableResidueTorsionAngles.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableResidueTorsionAngles.of()}.
 */
@Generated(from = "ResidueTorsionAngles", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableResidueTorsionAngles extends ResidueTorsionAngles {
  private final PdbResidueIdentifier identifier;
  private final List<TorsionAngleValue> values;

  private ImmutableResidueTorsionAngles(
      PdbResidueIdentifier identifier,
      Iterable<? extends TorsionAngleValue> values) {
    this.identifier = Objects.requireNonNull(identifier, "identifier");
    this.values = createUnmodifiableList(false, createSafeList(values, true, false));
  }

  private ImmutableResidueTorsionAngles(
      ImmutableResidueTorsionAngles original,
      PdbResidueIdentifier identifier,
      List<TorsionAngleValue> values) {
    this.identifier = identifier;
    this.values = values;
  }

  /**
   *@return The residue identifier. 
   */
  @Override
  public PdbResidueIdentifier identifier() {
    return identifier;
  }

  /**
   *@return The list of torsion angles' values. 
   */
  @Override
  protected List<TorsionAngleValue> values() {
    return values;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ResidueTorsionAngles#identifier() identifier} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for identifier
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableResidueTorsionAngles withIdentifier(PdbResidueIdentifier value) {
    if (this.identifier == value) return this;
    PdbResidueIdentifier newValue = Objects.requireNonNull(value, "identifier");
    return new ImmutableResidueTorsionAngles(this, newValue, this.values);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ResidueTorsionAngles#values() values}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableResidueTorsionAngles withValues(TorsionAngleValue... elements) {
    List<TorsionAngleValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableResidueTorsionAngles(this, this.identifier, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ResidueTorsionAngles#values() values}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of values elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableResidueTorsionAngles withValues(Iterable<? extends TorsionAngleValue> elements) {
    if (this.values == elements) return this;
    List<TorsionAngleValue> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableResidueTorsionAngles(this, this.identifier, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableResidueTorsionAngles} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableResidueTorsionAngles
        && equalTo((ImmutableResidueTorsionAngles) another);
  }

  private boolean equalTo(ImmutableResidueTorsionAngles another) {
    return identifier.equals(another.identifier)
        && values.equals(another.values);
  }

  /**
   * Computes a hash code from attributes: {@code identifier}, {@code values}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + identifier.hashCode();
    h += (h << 5) + values.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ResidueTorsionAngles} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ResidueTorsionAngles{"
        + "identifier=" + identifier
        + ", values=" + values
        + "}";
  }

  /**
   * Construct a new immutable {@code ResidueTorsionAngles} instance.
   * @param identifier The value for the {@code identifier} attribute
   * @param values The value for the {@code values} attribute
   * @return An immutable ResidueTorsionAngles instance
   */
  public static ImmutableResidueTorsionAngles of(PdbResidueIdentifier identifier, List<TorsionAngleValue> values) {
    return of(identifier, (Iterable<? extends TorsionAngleValue>) values);
  }

  /**
   * Construct a new immutable {@code ResidueTorsionAngles} instance.
   * @param identifier The value for the {@code identifier} attribute
   * @param values The value for the {@code values} attribute
   * @return An immutable ResidueTorsionAngles instance
   */
  public static ImmutableResidueTorsionAngles of(PdbResidueIdentifier identifier, Iterable<? extends TorsionAngleValue> values) {
    return new ImmutableResidueTorsionAngles(identifier, values);
  }

  /**
   * Creates an immutable copy of a {@link ResidueTorsionAngles} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ResidueTorsionAngles instance
   */
  public static ImmutableResidueTorsionAngles copyOf(ResidueTorsionAngles instance) {
    if (instance instanceof ImmutableResidueTorsionAngles) {
      return (ImmutableResidueTorsionAngles) instance;
    }
    return ImmutableResidueTorsionAngles.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableResidueTorsionAngles ImmutableResidueTorsionAngles}.
   * <pre>
   * ImmutableResidueTorsionAngles.builder()
   *    .identifier(pl.poznan.put.pdb.PdbResidueIdentifier) // required {@link ResidueTorsionAngles#identifier() identifier}
   *    .addValues|addAllValues(pl.poznan.put.torsion.TorsionAngleValue) // {@link ResidueTorsionAngles#values() values} elements
   *    .build();
   * </pre>
   * @return A new ImmutableResidueTorsionAngles builder
   */
  public static ImmutableResidueTorsionAngles.Builder builder() {
    return new ImmutableResidueTorsionAngles.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableResidueTorsionAngles ImmutableResidueTorsionAngles}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ResidueTorsionAngles", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_IDENTIFIER = 0x1L;
    private long initBits = 0x1L;

    private @Nullable PdbResidueIdentifier identifier;
    private List<TorsionAngleValue> values = new ArrayList<TorsionAngleValue>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ResidueTorsionAngles} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ResidueTorsionAngles instance) {
      Objects.requireNonNull(instance, "instance");
      identifier(instance.identifier());
      addAllValues(instance.values());
      return this;
    }

    /**
     * Initializes the value for the {@link ResidueTorsionAngles#identifier() identifier} attribute.
     * @param identifier The value for identifier 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identifier(PdbResidueIdentifier identifier) {
      this.identifier = Objects.requireNonNull(identifier, "identifier");
      initBits &= ~INIT_BIT_IDENTIFIER;
      return this;
    }

    /**
     * Adds one element to {@link ResidueTorsionAngles#values() values} list.
     * @param element A values element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addValues(TorsionAngleValue element) {
      this.values.add(Objects.requireNonNull(element, "values element"));
      return this;
    }

    /**
     * Adds elements to {@link ResidueTorsionAngles#values() values} list.
     * @param elements An array of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addValues(TorsionAngleValue... elements) {
      for (TorsionAngleValue element : elements) {
        this.values.add(Objects.requireNonNull(element, "values element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ResidueTorsionAngles#values() values} list.
     * @param elements An iterable of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder values(Iterable<? extends TorsionAngleValue> elements) {
      this.values.clear();
      return addAllValues(elements);
    }

    /**
     * Adds elements to {@link ResidueTorsionAngles#values() values} list.
     * @param elements An iterable of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllValues(Iterable<? extends TorsionAngleValue> elements) {
      for (TorsionAngleValue element : elements) {
        this.values.add(Objects.requireNonNull(element, "values element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableResidueTorsionAngles ImmutableResidueTorsionAngles}.
     * @return An immutable instance of ResidueTorsionAngles
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableResidueTorsionAngles build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableResidueTorsionAngles(null, identifier, createUnmodifiableList(true, values));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_IDENTIFIER) != 0) attributes.add("identifier");
      return "Cannot build ResidueTorsionAngles, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
