package pl.poznan.put.pdb.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.torsion.TorsionAngleType;

/**
 * Immutable implementation of {@link PdbCompactFragment}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePdbCompactFragment.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutablePdbCompactFragment.of()}.
 */
@Generated(from = "PdbCompactFragment", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutablePdbCompactFragment extends PdbCompactFragment {
  private final List<PdbResidue> residues;
  private final String name;

  private ImmutablePdbCompactFragment(Iterable<? extends PdbResidue> residues) {
    this.residues = createUnmodifiableList(false, createSafeList(residues, true, false));
    this.name = Objects.requireNonNull(super.name(), "name");
  }

  private ImmutablePdbCompactFragment(ImmutablePdbCompactFragment.Builder builder) {
    this.residues = createUnmodifiableList(true, builder.residues);
    this.name = builder.name != null
        ? builder.name
        : Objects.requireNonNull(super.name(), "name");
  }

  private ImmutablePdbCompactFragment(List<PdbResidue> residues, String name) {
    this.residues = residues;
    this.name = name;
  }

  /**
   * @return The value of the {@code residues} attribute
   */
  @Override
  public List<PdbResidue> residues() {
    return residues;
  }

  /**
   *@return The name of this compact fragment. 
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PdbCompactFragment#residues() residues}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePdbCompactFragment withResidues(PdbResidue... elements) {
    List<PdbResidue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutablePdbCompactFragment(newValue, this.name);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PdbCompactFragment#residues() residues}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of residues elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePdbCompactFragment withResidues(Iterable<? extends PdbResidue> elements) {
    if (this.residues == elements) return this;
    List<PdbResidue> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutablePdbCompactFragment(newValue, this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbCompactFragment#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbCompactFragment withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutablePdbCompactFragment(this.residues, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePdbCompactFragment} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePdbCompactFragment
        && equalTo((ImmutablePdbCompactFragment) another);
  }

  private boolean equalTo(ImmutablePdbCompactFragment another) {
    return residues.equals(another.residues)
        && name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code residues}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + residues.hashCode();
    h += (h << 5) + name.hashCode();
    return h;
  }

  private transient volatile long lazyInitBitmap;

  private static final long ANGLE_TYPES_LAZY_INIT_BIT = 0x1L;

  private transient Set<TorsionAngleType> angleTypes;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link PdbCompactFragment#angleTypes() angleTypes} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code angleTypes} attribute
   */
  @Override
  protected Set<TorsionAngleType> angleTypes() {
    if ((lazyInitBitmap & ANGLE_TYPES_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & ANGLE_TYPES_LAZY_INIT_BIT) == 0) {
          this.angleTypes = Objects.requireNonNull(super.angleTypes(), "angleTypes");
          lazyInitBitmap |= ANGLE_TYPES_LAZY_INIT_BIT;
        }
      }
    }
    return angleTypes;
  }

  private static final long ANGLE_VALUES_LAZY_INIT_BIT = 0x2L;

  private transient List<ResidueTorsionAngles> angleValues;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link PdbCompactFragment#angleValues() angleValues} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code angleValues} attribute
   */
  @Override
  protected List<ResidueTorsionAngles> angleValues() {
    if ((lazyInitBitmap & ANGLE_VALUES_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & ANGLE_VALUES_LAZY_INIT_BIT) == 0) {
          this.angleValues = Objects.requireNonNull(super.angleValues(), "angleValues");
          lazyInitBitmap |= ANGLE_VALUES_LAZY_INIT_BIT;
        }
      }
    }
    return angleValues;
  }

  /**
   * Construct a new immutable {@code PdbCompactFragment} instance.
   * @param residues The value for the {@code residues} attribute
   * @return An immutable PdbCompactFragment instance
   */
  public static ImmutablePdbCompactFragment of(List<PdbResidue> residues) {
    return of((Iterable<? extends PdbResidue>) residues);
  }

  /**
   * Construct a new immutable {@code PdbCompactFragment} instance.
   * @param residues The value for the {@code residues} attribute
   * @return An immutable PdbCompactFragment instance
   */
  public static ImmutablePdbCompactFragment of(Iterable<? extends PdbResidue> residues) {
    return new ImmutablePdbCompactFragment(residues);
  }

  /**
   * Creates an immutable copy of a {@link PdbCompactFragment} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PdbCompactFragment instance
   */
  public static ImmutablePdbCompactFragment copyOf(PdbCompactFragment instance) {
    if (instance instanceof ImmutablePdbCompactFragment) {
      return (ImmutablePdbCompactFragment) instance;
    }
    return ImmutablePdbCompactFragment.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePdbCompactFragment ImmutablePdbCompactFragment}.
   * <pre>
   * ImmutablePdbCompactFragment.builder()
   *    .addResidues|addAllResidues(pl.poznan.put.pdb.analysis.PdbResidue) // {@link PdbCompactFragment#residues() residues} elements
   *    .name(String) // optional {@link PdbCompactFragment#name() name}
   *    .build();
   * </pre>
   * @return A new ImmutablePdbCompactFragment builder
   */
  public static ImmutablePdbCompactFragment.Builder builder() {
    return new ImmutablePdbCompactFragment.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePdbCompactFragment ImmutablePdbCompactFragment}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PdbCompactFragment", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<PdbResidue> residues = new ArrayList<PdbResidue>();
    private @Nullable String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.pdb.analysis.PdbCompactFragment} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PdbCompactFragment instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.pdb.analysis.ResidueCollection} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ResidueCollection instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof PdbCompactFragment) {
        PdbCompactFragment instance = (PdbCompactFragment) object;
        name(instance.name());
        if ((bits & 0x1L) == 0) {
          addAllResidues(instance.residues());
          bits |= 0x1L;
        }
      }
      if (object instanceof ResidueCollection) {
        ResidueCollection instance = (ResidueCollection) object;
        if ((bits & 0x1L) == 0) {
          addAllResidues(instance.residues());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Adds one element to {@link PdbCompactFragment#residues() residues} list.
     * @param element A residues element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addResidues(PdbResidue element) {
      this.residues.add(Objects.requireNonNull(element, "residues element"));
      return this;
    }

    /**
     * Adds elements to {@link PdbCompactFragment#residues() residues} list.
     * @param elements An array of residues elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addResidues(PdbResidue... elements) {
      for (PdbResidue element : elements) {
        this.residues.add(Objects.requireNonNull(element, "residues element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PdbCompactFragment#residues() residues} list.
     * @param elements An iterable of residues elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder residues(Iterable<? extends PdbResidue> elements) {
      this.residues.clear();
      return addAllResidues(elements);
    }

    /**
     * Adds elements to {@link PdbCompactFragment#residues() residues} list.
     * @param elements An iterable of residues elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllResidues(Iterable<? extends PdbResidue> elements) {
      for (PdbResidue element : elements) {
        this.residues.add(Objects.requireNonNull(element, "residues element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link PdbCompactFragment#name() name} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link PdbCompactFragment#name() name}.</em>
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      return this;
    }

    /**
     * Builds a new {@link ImmutablePdbCompactFragment ImmutablePdbCompactFragment}.
     * @return An immutable instance of PdbCompactFragment
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePdbCompactFragment build() {
      return new ImmutablePdbCompactFragment(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
