package pl.poznan.put.pdb.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PdbChain}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePdbChain.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutablePdbChain.of()}.
 */
@Generated(from = "PdbChain", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutablePdbChain extends PdbChain {
  private final String identifier;
  private final List<PdbResidue> residues;

  private ImmutablePdbChain(String identifier, Iterable<? extends PdbResidue> residues) {
    this.identifier = Objects.requireNonNull(identifier, "identifier");
    this.residues = createUnmodifiableList(false, createSafeList(residues, true, false));
  }

  private ImmutablePdbChain(
      ImmutablePdbChain original,
      String identifier,
      List<PdbResidue> residues) {
    this.identifier = identifier;
    this.residues = residues;
  }

  /**
   *@return The chain identifier. 
   */
  @Override
  public String identifier() {
    return identifier;
  }

  /**
   * @return The value of the {@code residues} attribute
   */
  @Override
  public List<PdbResidue> residues() {
    return residues;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbChain#identifier() identifier} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for identifier
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbChain withIdentifier(String value) {
    String newValue = Objects.requireNonNull(value, "identifier");
    if (this.identifier.equals(newValue)) return this;
    return new ImmutablePdbChain(this, newValue, this.residues);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PdbChain#residues() residues}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePdbChain withResidues(PdbResidue... elements) {
    List<PdbResidue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutablePdbChain(this, this.identifier, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PdbChain#residues() residues}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of residues elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePdbChain withResidues(Iterable<? extends PdbResidue> elements) {
    if (this.residues == elements) return this;
    List<PdbResidue> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutablePdbChain(this, this.identifier, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePdbChain} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePdbChain
        && equalTo((ImmutablePdbChain) another);
  }

  private boolean equalTo(ImmutablePdbChain another) {
    return identifier.equals(another.identifier)
        && residues.equals(another.residues);
  }

  /**
   * Computes a hash code from attributes: {@code identifier}, {@code residues}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + identifier.hashCode();
    h += (h << 5) + residues.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PdbChain} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PdbChain{"
        + "identifier=" + identifier
        + ", residues=" + residues
        + "}";
  }

  /**
   * Construct a new immutable {@code PdbChain} instance.
   * @param identifier The value for the {@code identifier} attribute
   * @param residues The value for the {@code residues} attribute
   * @return An immutable PdbChain instance
   */
  public static ImmutablePdbChain of(String identifier, List<PdbResidue> residues) {
    return of(identifier, (Iterable<? extends PdbResidue>) residues);
  }

  /**
   * Construct a new immutable {@code PdbChain} instance.
   * @param identifier The value for the {@code identifier} attribute
   * @param residues The value for the {@code residues} attribute
   * @return An immutable PdbChain instance
   */
  public static ImmutablePdbChain of(String identifier, Iterable<? extends PdbResidue> residues) {
    return new ImmutablePdbChain(identifier, residues);
  }

  /**
   * Creates an immutable copy of a {@link PdbChain} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PdbChain instance
   */
  public static ImmutablePdbChain copyOf(PdbChain instance) {
    if (instance instanceof ImmutablePdbChain) {
      return (ImmutablePdbChain) instance;
    }
    return ImmutablePdbChain.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePdbChain ImmutablePdbChain}.
   * <pre>
   * ImmutablePdbChain.builder()
   *    .identifier(String) // required {@link PdbChain#identifier() identifier}
   *    .addResidues|addAllResidues(pl.poznan.put.pdb.analysis.PdbResidue) // {@link PdbChain#residues() residues} elements
   *    .build();
   * </pre>
   * @return A new ImmutablePdbChain builder
   */
  public static ImmutablePdbChain.Builder builder() {
    return new ImmutablePdbChain.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePdbChain ImmutablePdbChain}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PdbChain", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_IDENTIFIER = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String identifier;
    private List<PdbResidue> residues = new ArrayList<PdbResidue>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.pdb.analysis.PdbChain} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PdbChain instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.pdb.analysis.ResidueCollection} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ResidueCollection instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof PdbChain) {
        PdbChain instance = (PdbChain) object;
        identifier(instance.identifier());
        if ((bits & 0x1L) == 0) {
          addAllResidues(instance.residues());
          bits |= 0x1L;
        }
      }
      if (object instanceof ResidueCollection) {
        ResidueCollection instance = (ResidueCollection) object;
        if ((bits & 0x1L) == 0) {
          addAllResidues(instance.residues());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link PdbChain#identifier() identifier} attribute.
     * @param identifier The value for identifier 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identifier(String identifier) {
      this.identifier = Objects.requireNonNull(identifier, "identifier");
      initBits &= ~INIT_BIT_IDENTIFIER;
      return this;
    }

    /**
     * Adds one element to {@link PdbChain#residues() residues} list.
     * @param element A residues element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addResidues(PdbResidue element) {
      this.residues.add(Objects.requireNonNull(element, "residues element"));
      return this;
    }

    /**
     * Adds elements to {@link PdbChain#residues() residues} list.
     * @param elements An array of residues elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addResidues(PdbResidue... elements) {
      for (PdbResidue element : elements) {
        this.residues.add(Objects.requireNonNull(element, "residues element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PdbChain#residues() residues} list.
     * @param elements An iterable of residues elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder residues(Iterable<? extends PdbResidue> elements) {
      this.residues.clear();
      return addAllResidues(elements);
    }

    /**
     * Adds elements to {@link PdbChain#residues() residues} list.
     * @param elements An iterable of residues elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllResidues(Iterable<? extends PdbResidue> elements) {
      for (PdbResidue element : elements) {
        this.residues.add(Objects.requireNonNull(element, "residues element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutablePdbChain ImmutablePdbChain}.
     * @return An immutable instance of PdbChain
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePdbChain build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePdbChain(null, identifier, createUnmodifiableList(true, residues));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_IDENTIFIER) != 0) attributes.add("identifier");
      return "Cannot build PdbChain, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
