package pl.poznan.put.pdb.analysis;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link InvalidResidueInformationProvider}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableInvalidResidueInformationProvider.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableInvalidResidueInformationProvider.of()}.
 */
@Generated(from = "InvalidResidueInformationProvider", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
final class ImmutableInvalidResidueInformationProvider
    extends InvalidResidueInformationProvider {
  private final String residueName;

  private ImmutableInvalidResidueInformationProvider(String residueName) {
    this.residueName = Objects.requireNonNull(residueName, "residueName");
  }

  private ImmutableInvalidResidueInformationProvider(ImmutableInvalidResidueInformationProvider original, String residueName) {
    this.residueName = residueName;
  }

  /**
   * @return The value of the {@code residueName} attribute
   */
  @Override
  public String residueName() {
    return residueName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InvalidResidueInformationProvider#residueName() residueName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for residueName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInvalidResidueInformationProvider withResidueName(String value) {
    String newValue = Objects.requireNonNull(value, "residueName");
    if (this.residueName.equals(newValue)) return this;
    return new ImmutableInvalidResidueInformationProvider(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableInvalidResidueInformationProvider} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableInvalidResidueInformationProvider
        && equalTo((ImmutableInvalidResidueInformationProvider) another);
  }

  private boolean equalTo(ImmutableInvalidResidueInformationProvider another) {
    return residueName.equals(another.residueName);
  }

  /**
   * Computes a hash code from attributes: {@code residueName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + residueName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code InvalidResidueInformationProvider} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InvalidResidueInformationProvider{"
        + "residueName=" + residueName
        + "}";
  }

  /**
   * Construct a new immutable {@code InvalidResidueInformationProvider} instance.
   * @param residueName The value for the {@code residueName} attribute
   * @return An immutable InvalidResidueInformationProvider instance
   */
  public static ImmutableInvalidResidueInformationProvider of(String residueName) {
    return new ImmutableInvalidResidueInformationProvider(residueName);
  }

  /**
   * Creates an immutable copy of a {@link InvalidResidueInformationProvider} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InvalidResidueInformationProvider instance
   */
  public static ImmutableInvalidResidueInformationProvider copyOf(InvalidResidueInformationProvider instance) {
    if (instance instanceof ImmutableInvalidResidueInformationProvider) {
      return (ImmutableInvalidResidueInformationProvider) instance;
    }
    return ImmutableInvalidResidueInformationProvider.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableInvalidResidueInformationProvider ImmutableInvalidResidueInformationProvider}.
   * <pre>
   * ImmutableInvalidResidueInformationProvider.builder()
   *    .residueName(String) // required {@link InvalidResidueInformationProvider#residueName() residueName}
   *    .build();
   * </pre>
   * @return A new ImmutableInvalidResidueInformationProvider builder
   */
  public static ImmutableInvalidResidueInformationProvider.Builder builder() {
    return new ImmutableInvalidResidueInformationProvider.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableInvalidResidueInformationProvider ImmutableInvalidResidueInformationProvider}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "InvalidResidueInformationProvider", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_RESIDUE_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String residueName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InvalidResidueInformationProvider} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InvalidResidueInformationProvider instance) {
      Objects.requireNonNull(instance, "instance");
      residueName(instance.residueName());
      return this;
    }

    /**
     * Initializes the value for the {@link InvalidResidueInformationProvider#residueName() residueName} attribute.
     * @param residueName The value for residueName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder residueName(String residueName) {
      this.residueName = Objects.requireNonNull(residueName, "residueName");
      initBits &= ~INIT_BIT_RESIDUE_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableInvalidResidueInformationProvider ImmutableInvalidResidueInformationProvider}.
     * @return An immutable instance of InvalidResidueInformationProvider
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableInvalidResidueInformationProvider build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableInvalidResidueInformationProvider(null, residueName);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RESIDUE_NAME) != 0) attributes.add("residueName");
      return "Cannot build InvalidResidueInformationProvider, some of required attributes are not set " + attributes;
    }
  }
}
