package pl.poznan.put.pdb.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DefaultResidueCollection}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDefaultResidueCollection.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDefaultResidueCollection.of()}.
 */
@Generated(from = "DefaultResidueCollection", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableDefaultResidueCollection
    extends DefaultResidueCollection {
  private final List<PdbResidue> residues;

  private ImmutableDefaultResidueCollection(Iterable<? extends PdbResidue> residues) {
    this.residues = createUnmodifiableList(false, createSafeList(residues, true, false));
  }

  private ImmutableDefaultResidueCollection(
      ImmutableDefaultResidueCollection original,
      List<PdbResidue> residues) {
    this.residues = residues;
  }

  /**
   * @return The value of the {@code residues} attribute
   */
  @Override
  public List<PdbResidue> residues() {
    return residues;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DefaultResidueCollection#residues() residues}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefaultResidueCollection withResidues(PdbResidue... elements) {
    List<PdbResidue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableDefaultResidueCollection(this, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DefaultResidueCollection#residues() residues}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of residues elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefaultResidueCollection withResidues(Iterable<? extends PdbResidue> elements) {
    if (this.residues == elements) return this;
    List<PdbResidue> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableDefaultResidueCollection(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDefaultResidueCollection} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDefaultResidueCollection
        && equalTo((ImmutableDefaultResidueCollection) another);
  }

  private boolean equalTo(ImmutableDefaultResidueCollection another) {
    return residues.equals(another.residues);
  }

  /**
   * Computes a hash code from attributes: {@code residues}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + residues.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DefaultResidueCollection} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DefaultResidueCollection{"
        + "residues=" + residues
        + "}";
  }

  /**
   * Construct a new immutable {@code DefaultResidueCollection} instance.
   * @param residues The value for the {@code residues} attribute
   * @return An immutable DefaultResidueCollection instance
   */
  public static ImmutableDefaultResidueCollection of(List<PdbResidue> residues) {
    return of((Iterable<? extends PdbResidue>) residues);
  }

  /**
   * Construct a new immutable {@code DefaultResidueCollection} instance.
   * @param residues The value for the {@code residues} attribute
   * @return An immutable DefaultResidueCollection instance
   */
  public static ImmutableDefaultResidueCollection of(Iterable<? extends PdbResidue> residues) {
    return new ImmutableDefaultResidueCollection(residues);
  }

  /**
   * Creates an immutable copy of a {@link DefaultResidueCollection} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DefaultResidueCollection instance
   */
  public static ImmutableDefaultResidueCollection copyOf(DefaultResidueCollection instance) {
    if (instance instanceof ImmutableDefaultResidueCollection) {
      return (ImmutableDefaultResidueCollection) instance;
    }
    return ImmutableDefaultResidueCollection.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDefaultResidueCollection ImmutableDefaultResidueCollection}.
   * <pre>
   * ImmutableDefaultResidueCollection.builder()
   *    .addResidues|addAllResidues(pl.poznan.put.pdb.analysis.PdbResidue) // {@link DefaultResidueCollection#residues() residues} elements
   *    .build();
   * </pre>
   * @return A new ImmutableDefaultResidueCollection builder
   */
  public static ImmutableDefaultResidueCollection.Builder builder() {
    return new ImmutableDefaultResidueCollection.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDefaultResidueCollection ImmutableDefaultResidueCollection}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DefaultResidueCollection", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<PdbResidue> residues = new ArrayList<PdbResidue>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.pdb.analysis.ResidueCollection} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ResidueCollection instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.pdb.analysis.DefaultResidueCollection} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DefaultResidueCollection instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof ResidueCollection) {
        ResidueCollection instance = (ResidueCollection) object;
        if ((bits & 0x1L) == 0) {
          addAllResidues(instance.residues());
          bits |= 0x1L;
        }
      }
      if (object instanceof DefaultResidueCollection) {
        DefaultResidueCollection instance = (DefaultResidueCollection) object;
        if ((bits & 0x1L) == 0) {
          addAllResidues(instance.residues());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Adds one element to {@link DefaultResidueCollection#residues() residues} list.
     * @param element A residues element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addResidues(PdbResidue element) {
      this.residues.add(Objects.requireNonNull(element, "residues element"));
      return this;
    }

    /**
     * Adds elements to {@link DefaultResidueCollection#residues() residues} list.
     * @param elements An array of residues elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addResidues(PdbResidue... elements) {
      for (PdbResidue element : elements) {
        this.residues.add(Objects.requireNonNull(element, "residues element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DefaultResidueCollection#residues() residues} list.
     * @param elements An iterable of residues elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder residues(Iterable<? extends PdbResidue> elements) {
      this.residues.clear();
      return addAllResidues(elements);
    }

    /**
     * Adds elements to {@link DefaultResidueCollection#residues() residues} list.
     * @param elements An iterable of residues elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllResidues(Iterable<? extends PdbResidue> elements) {
      for (PdbResidue element : elements) {
        this.residues.add(Objects.requireNonNull(element, "residues element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableDefaultResidueCollection ImmutableDefaultResidueCollection}.
     * @return An immutable instance of DefaultResidueCollection
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDefaultResidueCollection build() {
      return new ImmutableDefaultResidueCollection(null, createUnmodifiableList(true, residues));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
