package pl.poznan.put.pdb.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.pdb.PdbAtomLine;
import pl.poznan.put.pdb.PdbResidueIdentifier;

/**
 * Immutable implementation of {@link DefaultPdbResidue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDefaultPdbResidue.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDefaultPdbResidue.of()}.
 */
@Generated(from = "DefaultPdbResidue", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableDefaultPdbResidue extends DefaultPdbResidue {
  private final PdbResidueIdentifier identifier;
  private final String standardResidueName;
  private final String modifiedResidueName;
  private final List<PdbAtomLine> atoms;

  private ImmutableDefaultPdbResidue(
      PdbResidueIdentifier identifier,
      String standardResidueName,
      String modifiedResidueName,
      Iterable<? extends PdbAtomLine> atoms) {
    this.identifier = Objects.requireNonNull(identifier, "identifier");
    this.standardResidueName = Objects.requireNonNull(standardResidueName, "standardResidueName");
    this.modifiedResidueName = Objects.requireNonNull(modifiedResidueName, "modifiedResidueName");
    this.atoms = createUnmodifiableList(false, createSafeList(atoms, true, false));
  }

  private ImmutableDefaultPdbResidue(
      ImmutableDefaultPdbResidue original,
      PdbResidueIdentifier identifier,
      String standardResidueName,
      String modifiedResidueName,
      List<PdbAtomLine> atoms) {
    this.identifier = identifier;
    this.standardResidueName = standardResidueName;
    this.modifiedResidueName = modifiedResidueName;
    this.atoms = atoms;
  }

  /**
   * @return The value of the {@code identifier} attribute
   */
  @Override
  public PdbResidueIdentifier identifier() {
    return identifier;
  }

  /**
   * @return The value of the {@code standardResidueName} attribute
   */
  @Override
  public String standardResidueName() {
    return standardResidueName;
  }

  /**
   * @return The value of the {@code modifiedResidueName} attribute
   */
  @Override
  public String modifiedResidueName() {
    return modifiedResidueName;
  }

  /**
   * @return The value of the {@code atoms} attribute
   */
  @Override
  public List<PdbAtomLine> atoms() {
    return atoms;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DefaultPdbResidue#identifier() identifier} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for identifier
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDefaultPdbResidue withIdentifier(PdbResidueIdentifier value) {
    if (this.identifier == value) return this;
    PdbResidueIdentifier newValue = Objects.requireNonNull(value, "identifier");
    return new ImmutableDefaultPdbResidue(this, newValue, this.standardResidueName, this.modifiedResidueName, this.atoms);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DefaultPdbResidue#standardResidueName() standardResidueName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for standardResidueName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDefaultPdbResidue withStandardResidueName(String value) {
    String newValue = Objects.requireNonNull(value, "standardResidueName");
    if (this.standardResidueName.equals(newValue)) return this;
    return new ImmutableDefaultPdbResidue(this, this.identifier, newValue, this.modifiedResidueName, this.atoms);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DefaultPdbResidue#modifiedResidueName() modifiedResidueName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modifiedResidueName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDefaultPdbResidue withModifiedResidueName(String value) {
    String newValue = Objects.requireNonNull(value, "modifiedResidueName");
    if (this.modifiedResidueName.equals(newValue)) return this;
    return new ImmutableDefaultPdbResidue(this, this.identifier, this.standardResidueName, newValue, this.atoms);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DefaultPdbResidue#atoms() atoms}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefaultPdbResidue withAtoms(PdbAtomLine... elements) {
    List<PdbAtomLine> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableDefaultPdbResidue(this, this.identifier, this.standardResidueName, this.modifiedResidueName, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DefaultPdbResidue#atoms() atoms}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of atoms elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefaultPdbResidue withAtoms(Iterable<? extends PdbAtomLine> elements) {
    if (this.atoms == elements) return this;
    List<PdbAtomLine> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableDefaultPdbResidue(this, this.identifier, this.standardResidueName, this.modifiedResidueName, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDefaultPdbResidue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDefaultPdbResidue
        && equalTo((ImmutableDefaultPdbResidue) another);
  }

  private boolean equalTo(ImmutableDefaultPdbResidue another) {
    return identifier.equals(another.identifier)
        && standardResidueName.equals(another.standardResidueName)
        && modifiedResidueName.equals(another.modifiedResidueName)
        && atoms.equals(another.atoms);
  }

  /**
   * Computes a hash code from attributes: {@code identifier}, {@code standardResidueName}, {@code modifiedResidueName}, {@code atoms}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + identifier.hashCode();
    h += (h << 5) + standardResidueName.hashCode();
    h += (h << 5) + modifiedResidueName.hashCode();
    h += (h << 5) + atoms.hashCode();
    return h;
  }

  private transient volatile long lazyInitBitmap;

  private static final long RESIDUE_INFORMATION_PROVIDER_LAZY_INIT_BIT = 0x1L;

  private transient ResidueInformationProvider residueInformationProvider;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link DefaultPdbResidue#residueInformationProvider() residueInformationProvider} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code residueInformationProvider} attribute
   */
  @Override
  public ResidueInformationProvider residueInformationProvider() {
    if ((lazyInitBitmap & RESIDUE_INFORMATION_PROVIDER_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & RESIDUE_INFORMATION_PROVIDER_LAZY_INIT_BIT) == 0) {
          this.residueInformationProvider = Objects.requireNonNull(super.residueInformationProvider(), "residueInformationProvider");
          lazyInitBitmap |= RESIDUE_INFORMATION_PROVIDER_LAZY_INIT_BIT;
        }
      }
    }
    return residueInformationProvider;
  }

  private static final long ATOM_NAMES_LAZY_INIT_BIT = 0x2L;

  private transient Set<AtomName> atomNames;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link DefaultPdbResidue#atomNames() atomNames} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code atomNames} attribute
   */
  @Override
  public Set<AtomName> atomNames() {
    if ((lazyInitBitmap & ATOM_NAMES_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & ATOM_NAMES_LAZY_INIT_BIT) == 0) {
          this.atomNames = Objects.requireNonNull(super.atomNames(), "atomNames");
          lazyInitBitmap |= ATOM_NAMES_LAZY_INIT_BIT;
        }
      }
    }
    return atomNames;
  }

  private static final long HAS_ALL_HEAVY_ATOMS_LAZY_INIT_BIT = 0x4L;

  private transient boolean hasAllHeavyAtoms;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link DefaultPdbResidue#hasAllHeavyAtoms() hasAllHeavyAtoms} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code hasAllHeavyAtoms} attribute
   */
  @Override
  public boolean hasAllHeavyAtoms() {
    if ((lazyInitBitmap & HAS_ALL_HEAVY_ATOMS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & HAS_ALL_HEAVY_ATOMS_LAZY_INIT_BIT) == 0) {
          this.hasAllHeavyAtoms = super.hasAllHeavyAtoms();
          lazyInitBitmap |= HAS_ALL_HEAVY_ATOMS_LAZY_INIT_BIT;
        }
      }
    }
    return hasAllHeavyAtoms;
  }

  /**
   * Construct a new immutable {@code DefaultPdbResidue} instance.
   * @param identifier The value for the {@code identifier} attribute
   * @param standardResidueName The value for the {@code standardResidueName} attribute
   * @param modifiedResidueName The value for the {@code modifiedResidueName} attribute
   * @param atoms The value for the {@code atoms} attribute
   * @return An immutable DefaultPdbResidue instance
   */
  public static ImmutableDefaultPdbResidue of(PdbResidueIdentifier identifier, String standardResidueName, String modifiedResidueName, List<PdbAtomLine> atoms) {
    return of(identifier, standardResidueName, modifiedResidueName, (Iterable<? extends PdbAtomLine>) atoms);
  }

  /**
   * Construct a new immutable {@code DefaultPdbResidue} instance.
   * @param identifier The value for the {@code identifier} attribute
   * @param standardResidueName The value for the {@code standardResidueName} attribute
   * @param modifiedResidueName The value for the {@code modifiedResidueName} attribute
   * @param atoms The value for the {@code atoms} attribute
   * @return An immutable DefaultPdbResidue instance
   */
  public static ImmutableDefaultPdbResidue of(PdbResidueIdentifier identifier, String standardResidueName, String modifiedResidueName, Iterable<? extends PdbAtomLine> atoms) {
    return new ImmutableDefaultPdbResidue(identifier, standardResidueName, modifiedResidueName, atoms);
  }

  /**
   * Creates an immutable copy of a {@link DefaultPdbResidue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DefaultPdbResidue instance
   */
  public static ImmutableDefaultPdbResidue copyOf(DefaultPdbResidue instance) {
    if (instance instanceof ImmutableDefaultPdbResidue) {
      return (ImmutableDefaultPdbResidue) instance;
    }
    return ImmutableDefaultPdbResidue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDefaultPdbResidue ImmutableDefaultPdbResidue}.
   * <pre>
   * ImmutableDefaultPdbResidue.builder()
   *    .identifier(pl.poznan.put.pdb.PdbResidueIdentifier) // required {@link DefaultPdbResidue#identifier() identifier}
   *    .standardResidueName(String) // required {@link DefaultPdbResidue#standardResidueName() standardResidueName}
   *    .modifiedResidueName(String) // required {@link DefaultPdbResidue#modifiedResidueName() modifiedResidueName}
   *    .addAtoms|addAllAtoms(pl.poznan.put.pdb.PdbAtomLine) // {@link DefaultPdbResidue#atoms() atoms} elements
   *    .build();
   * </pre>
   * @return A new ImmutableDefaultPdbResidue builder
   */
  public static ImmutableDefaultPdbResidue.Builder builder() {
    return new ImmutableDefaultPdbResidue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDefaultPdbResidue ImmutableDefaultPdbResidue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DefaultPdbResidue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_IDENTIFIER = 0x1L;
    private static final long INIT_BIT_STANDARD_RESIDUE_NAME = 0x2L;
    private static final long INIT_BIT_MODIFIED_RESIDUE_NAME = 0x4L;
    private long initBits = 0x7L;

    private @Nullable PdbResidueIdentifier identifier;
    private @Nullable String standardResidueName;
    private @Nullable String modifiedResidueName;
    private List<PdbAtomLine> atoms = new ArrayList<PdbAtomLine>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.pdb.analysis.PdbResidue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PdbResidue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.pdb.analysis.DefaultPdbResidue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DefaultPdbResidue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof PdbResidue) {
        PdbResidue instance = (PdbResidue) object;
        if ((bits & 0x1L) == 0) {
          standardResidueName(instance.standardResidueName());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          identifier(instance.identifier());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          modifiedResidueName(instance.modifiedResidueName());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          addAllAtoms(instance.atoms());
          bits |= 0x8L;
        }
      }
      if (object instanceof DefaultPdbResidue) {
        DefaultPdbResidue instance = (DefaultPdbResidue) object;
        if ((bits & 0x1L) == 0) {
          standardResidueName(instance.standardResidueName());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          identifier(instance.identifier());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          modifiedResidueName(instance.modifiedResidueName());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          addAllAtoms(instance.atoms());
          bits |= 0x8L;
        }
      }
    }

    /**
     * Initializes the value for the {@link DefaultPdbResidue#identifier() identifier} attribute.
     * @param identifier The value for identifier 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identifier(PdbResidueIdentifier identifier) {
      this.identifier = Objects.requireNonNull(identifier, "identifier");
      initBits &= ~INIT_BIT_IDENTIFIER;
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultPdbResidue#standardResidueName() standardResidueName} attribute.
     * @param standardResidueName The value for standardResidueName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder standardResidueName(String standardResidueName) {
      this.standardResidueName = Objects.requireNonNull(standardResidueName, "standardResidueName");
      initBits &= ~INIT_BIT_STANDARD_RESIDUE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultPdbResidue#modifiedResidueName() modifiedResidueName} attribute.
     * @param modifiedResidueName The value for modifiedResidueName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder modifiedResidueName(String modifiedResidueName) {
      this.modifiedResidueName = Objects.requireNonNull(modifiedResidueName, "modifiedResidueName");
      initBits &= ~INIT_BIT_MODIFIED_RESIDUE_NAME;
      return this;
    }

    /**
     * Adds one element to {@link DefaultPdbResidue#atoms() atoms} list.
     * @param element A atoms element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAtoms(PdbAtomLine element) {
      this.atoms.add(Objects.requireNonNull(element, "atoms element"));
      return this;
    }

    /**
     * Adds elements to {@link DefaultPdbResidue#atoms() atoms} list.
     * @param elements An array of atoms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAtoms(PdbAtomLine... elements) {
      for (PdbAtomLine element : elements) {
        this.atoms.add(Objects.requireNonNull(element, "atoms element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DefaultPdbResidue#atoms() atoms} list.
     * @param elements An iterable of atoms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder atoms(Iterable<? extends PdbAtomLine> elements) {
      this.atoms.clear();
      return addAllAtoms(elements);
    }

    /**
     * Adds elements to {@link DefaultPdbResidue#atoms() atoms} list.
     * @param elements An iterable of atoms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAtoms(Iterable<? extends PdbAtomLine> elements) {
      for (PdbAtomLine element : elements) {
        this.atoms.add(Objects.requireNonNull(element, "atoms element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableDefaultPdbResidue ImmutableDefaultPdbResidue}.
     * @return An immutable instance of DefaultPdbResidue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDefaultPdbResidue build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDefaultPdbResidue(
          null,
          identifier,
          standardResidueName,
          modifiedResidueName,
          createUnmodifiableList(true, atoms));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_IDENTIFIER) != 0) attributes.add("identifier");
      if ((initBits & INIT_BIT_STANDARD_RESIDUE_NAME) != 0) attributes.add("standardResidueName");
      if ((initBits & INIT_BIT_MODIFIED_RESIDUE_NAME) != 0) attributes.add("modifiedResidueName");
      return "Cannot build DefaultPdbResidue, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
