package pl.poznan.put.pdb.analysis;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.collections4.BidiMap;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CifContainer}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCifContainer.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableCifContainer.of()}.
 */
@Generated(from = "CifContainer", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableCifContainer extends CifContainer {
  private final Map<File, BidiMap<String, String>> fileChainMap;
  private final File cifFile;

  private ImmutableCifContainer(
      File cifFile,
      Map<? extends File, ? extends BidiMap<String, String>> fileChainMap) {
    this.cifFile = Objects.requireNonNull(cifFile, "cifFile");
    this.fileChainMap = createUnmodifiableMap(true, false, fileChainMap);
  }

  private ImmutableCifContainer(
      ImmutableCifContainer original,
      Map<File, BidiMap<String, String>> fileChainMap,
      File cifFile) {
    this.fileChainMap = fileChainMap;
    this.cifFile = cifFile;
  }

  /**
   *@return The mapping of chain name in PDB and mmCIF for a specific file. 
   */
  @Override
  public Map<File, BidiMap<String, String>> fileChainMap() {
    return fileChainMap;
  }

  /**
   *@return The value of the {@code cifFile} attribute, 
   */
  @Override
  public File cifFile() {
    return cifFile;
  }

  /**
   * Copy the current immutable object by replacing the {@link CifContainer#fileChainMap() fileChainMap} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the fileChainMap map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCifContainer withFileChainMap(Map<? extends File, ? extends BidiMap<String, String>> entries) {
    if (this.fileChainMap == entries) return this;
    Map<File, BidiMap<String, String>> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableCifContainer(this, newValue, this.cifFile);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CifContainer#cifFile() cifFile} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cifFile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCifContainer withCifFile(File value) {
    if (this.cifFile == value) return this;
    File newValue = Objects.requireNonNull(value, "cifFile");
    return new ImmutableCifContainer(this, this.fileChainMap, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCifContainer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCifContainer
        && equalTo((ImmutableCifContainer) another);
  }

  private boolean equalTo(ImmutableCifContainer another) {
    return fileChainMap.equals(another.fileChainMap)
        && cifFile.equals(another.cifFile);
  }

  /**
   * Computes a hash code from attributes: {@code fileChainMap}, {@code cifFile}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + fileChainMap.hashCode();
    h += (h << 5) + cifFile.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CifContainer} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CifContainer{"
        + "fileChainMap=" + fileChainMap
        + ", cifFile=" + cifFile
        + "}";
  }

  /**
   * Construct a new immutable {@code CifContainer} instance.
   * @param cifFile The value for the {@code cifFile} attribute
   * @param fileChainMap The value for the {@code fileChainMap} attribute
   * @return An immutable CifContainer instance
   */
  public static ImmutableCifContainer of(File cifFile, Map<? extends File, ? extends BidiMap<String, String>> fileChainMap) {
    return new ImmutableCifContainer(cifFile, fileChainMap);
  }

  /**
   * Creates an immutable copy of a {@link CifContainer} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CifContainer instance
   */
  public static ImmutableCifContainer copyOf(CifContainer instance) {
    if (instance instanceof ImmutableCifContainer) {
      return (ImmutableCifContainer) instance;
    }
    return ImmutableCifContainer.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCifContainer ImmutableCifContainer}.
   * <pre>
   * ImmutableCifContainer.builder()
   *    .putFileChainMap|putAllFileChainMap(java.io.File =&gt; org.apache.commons.collections4.BidiMap&amp;lt;String, String&amp;gt;) // {@link CifContainer#fileChainMap() fileChainMap} mappings
   *    .cifFile(java.io.File) // required {@link CifContainer#cifFile() cifFile}
   *    .build();
   * </pre>
   * @return A new ImmutableCifContainer builder
   */
  public static ImmutableCifContainer.Builder builder() {
    return new ImmutableCifContainer.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCifContainer ImmutableCifContainer}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CifContainer", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CIF_FILE = 0x1L;
    private long initBits = 0x1L;

    private Map<File, BidiMap<String, String>> fileChainMap = new LinkedHashMap<File, BidiMap<String, String>>();
    private @Nullable File cifFile;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CifContainer} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CifContainer instance) {
      Objects.requireNonNull(instance, "instance");
      putAllFileChainMap(instance.fileChainMap());
      cifFile(instance.cifFile());
      return this;
    }

    /**
     * Put one entry to the {@link CifContainer#fileChainMap() fileChainMap} map.
     * @param key The key in the fileChainMap map
     * @param value The associated value in the fileChainMap map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putFileChainMap(File key, BidiMap<String, String> value) {
      this.fileChainMap.put(
          Objects.requireNonNull(key, "fileChainMap key"),
          Objects.requireNonNull(value, "fileChainMap value"));
      return this;
    }

    /**
     * Put one entry to the {@link CifContainer#fileChainMap() fileChainMap} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putFileChainMap(Map.Entry<? extends File, ? extends BidiMap<String, String>> entry) {
      File k = entry.getKey();
      BidiMap<String, String> v = entry.getValue();
      this.fileChainMap.put(
          Objects.requireNonNull(k, "fileChainMap key"),
          Objects.requireNonNull(v, "fileChainMap value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CifContainer#fileChainMap() fileChainMap} map. Nulls are not permitted
     * @param entries The entries that will be added to the fileChainMap map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder fileChainMap(Map<? extends File, ? extends BidiMap<String, String>> entries) {
      this.fileChainMap.clear();
      return putAllFileChainMap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CifContainer#fileChainMap() fileChainMap} map. Nulls are not permitted
     * @param entries The entries that will be added to the fileChainMap map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllFileChainMap(Map<? extends File, ? extends BidiMap<String, String>> entries) {
      for (Map.Entry<? extends File, ? extends BidiMap<String, String>> e : entries.entrySet()) {
        File k = e.getKey();
        BidiMap<String, String> v = e.getValue();
        this.fileChainMap.put(
            Objects.requireNonNull(k, "fileChainMap key"),
            Objects.requireNonNull(v, "fileChainMap value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CifContainer#cifFile() cifFile} attribute.
     * @param cifFile The value for cifFile 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cifFile(File cifFile) {
      this.cifFile = Objects.requireNonNull(cifFile, "cifFile");
      initBits &= ~INIT_BIT_CIF_FILE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCifContainer ImmutableCifContainer}.
     * @return An immutable instance of CifContainer
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCifContainer build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCifContainer(null, createUnmodifiableMap(false, false, fileChainMap), cifFile);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CIF_FILE) != 0) attributes.add("cifFile");
      return "Cannot build CifContainer, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
