package pl.poznan.put.pdb;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PdbTitleLine}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePdbTitleLine.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutablePdbTitleLine.of()}.
 */
@Generated(from = "PdbTitleLine", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutablePdbTitleLine extends PdbTitleLine {
  private final String continuation;
  private final String title;

  private ImmutablePdbTitleLine(String continuation, String title) {
    this.continuation = Objects.requireNonNull(continuation, "continuation");
    this.title = Objects.requireNonNull(title, "title");
  }

  private ImmutablePdbTitleLine(ImmutablePdbTitleLine original, String continuation, String title) {
    this.continuation = continuation;
    this.title = title;
  }

  /**
   *@return The value of the {@code continuation} attribute 
   */
  @Override
  public String continuation() {
    return continuation;
  }

  /**
   *@return The value of the {@code title} attribute 
   */
  @Override
  public String title() {
    return title;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbTitleLine#continuation() continuation} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for continuation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbTitleLine withContinuation(String value) {
    String newValue = Objects.requireNonNull(value, "continuation");
    if (this.continuation.equals(newValue)) return this;
    return new ImmutablePdbTitleLine(this, newValue, this.title);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbTitleLine#title() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbTitleLine withTitle(String value) {
    String newValue = Objects.requireNonNull(value, "title");
    if (this.title.equals(newValue)) return this;
    return new ImmutablePdbTitleLine(this, this.continuation, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePdbTitleLine} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePdbTitleLine
        && equalTo((ImmutablePdbTitleLine) another);
  }

  private boolean equalTo(ImmutablePdbTitleLine another) {
    return continuation.equals(another.continuation)
        && title.equals(another.title);
  }

  /**
   * Computes a hash code from attributes: {@code continuation}, {@code title}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + continuation.hashCode();
    h += (h << 5) + title.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code PdbTitleLine} instance.
   * @param continuation The value for the {@code continuation} attribute
   * @param title The value for the {@code title} attribute
   * @return An immutable PdbTitleLine instance
   */
  public static ImmutablePdbTitleLine of(String continuation, String title) {
    return new ImmutablePdbTitleLine(continuation, title);
  }

  /**
   * Creates an immutable copy of a {@link PdbTitleLine} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PdbTitleLine instance
   */
  public static ImmutablePdbTitleLine copyOf(PdbTitleLine instance) {
    if (instance instanceof ImmutablePdbTitleLine) {
      return (ImmutablePdbTitleLine) instance;
    }
    return ImmutablePdbTitleLine.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePdbTitleLine ImmutablePdbTitleLine}.
   * <pre>
   * ImmutablePdbTitleLine.builder()
   *    .continuation(String) // required {@link PdbTitleLine#continuation() continuation}
   *    .title(String) // required {@link PdbTitleLine#title() title}
   *    .build();
   * </pre>
   * @return A new ImmutablePdbTitleLine builder
   */
  public static ImmutablePdbTitleLine.Builder builder() {
    return new ImmutablePdbTitleLine.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePdbTitleLine ImmutablePdbTitleLine}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PdbTitleLine", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CONTINUATION = 0x1L;
    private static final long INIT_BIT_TITLE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String continuation;
    private @Nullable String title;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PdbTitleLine} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PdbTitleLine instance) {
      Objects.requireNonNull(instance, "instance");
      continuation(instance.continuation());
      title(instance.title());
      return this;
    }

    /**
     * Initializes the value for the {@link PdbTitleLine#continuation() continuation} attribute.
     * @param continuation The value for continuation 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder continuation(String continuation) {
      this.continuation = Objects.requireNonNull(continuation, "continuation");
      initBits &= ~INIT_BIT_CONTINUATION;
      return this;
    }

    /**
     * Initializes the value for the {@link PdbTitleLine#title() title} attribute.
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder title(String title) {
      this.title = Objects.requireNonNull(title, "title");
      initBits &= ~INIT_BIT_TITLE;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePdbTitleLine ImmutablePdbTitleLine}.
     * @return An immutable instance of PdbTitleLine
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePdbTitleLine build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePdbTitleLine(null, continuation, title);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONTINUATION) != 0) attributes.add("continuation");
      if ((initBits & INIT_BIT_TITLE) != 0) attributes.add("title");
      return "Cannot build PdbTitleLine, some of required attributes are not set " + attributes;
    }
  }
}
