package pl.poznan.put.pdb;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PdbResidueIdentifier}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePdbResidueIdentifier.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutablePdbResidueIdentifier.of()}.
 */
@Generated(from = "PdbResidueIdentifier", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutablePdbResidueIdentifier extends PdbResidueIdentifier {
  private final String chainIdentifier;
  private final int residueNumber;
  private final String insertionCode;

  private ImmutablePdbResidueIdentifier(String chainIdentifier, int residueNumber, String insertionCode) {
    this.chainIdentifier = Objects.requireNonNull(chainIdentifier, "chainIdentifier");
    this.residueNumber = residueNumber;
    this.insertionCode = Objects.requireNonNull(insertionCode, "insertionCode");
  }

  private ImmutablePdbResidueIdentifier(
      ImmutablePdbResidueIdentifier original,
      String chainIdentifier,
      int residueNumber,
      String insertionCode) {
    this.chainIdentifier = chainIdentifier;
    this.residueNumber = residueNumber;
    this.insertionCode = insertionCode;
  }

  /**
   * @return The value of the {@code chainIdentifier} attribute
   */
  @Override
  public String chainIdentifier() {
    return chainIdentifier;
  }

  /**
   * @return The value of the {@code residueNumber} attribute
   */
  @Override
  public int residueNumber() {
    return residueNumber;
  }

  /**
   * @return The value of the {@code insertionCode} attribute
   */
  @Override
  public String insertionCode() {
    return insertionCode;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbResidueIdentifier#chainIdentifier() chainIdentifier} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for chainIdentifier
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbResidueIdentifier withChainIdentifier(String value) {
    String newValue = Objects.requireNonNull(value, "chainIdentifier");
    if (this.chainIdentifier.equals(newValue)) return this;
    return new ImmutablePdbResidueIdentifier(this, newValue, this.residueNumber, this.insertionCode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbResidueIdentifier#residueNumber() residueNumber} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for residueNumber
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbResidueIdentifier withResidueNumber(int value) {
    if (this.residueNumber == value) return this;
    return new ImmutablePdbResidueIdentifier(this, this.chainIdentifier, value, this.insertionCode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbResidueIdentifier#insertionCode() insertionCode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for insertionCode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbResidueIdentifier withInsertionCode(String value) {
    String newValue = Objects.requireNonNull(value, "insertionCode");
    if (this.insertionCode.equals(newValue)) return this;
    return new ImmutablePdbResidueIdentifier(this, this.chainIdentifier, this.residueNumber, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePdbResidueIdentifier} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePdbResidueIdentifier
        && equalTo((ImmutablePdbResidueIdentifier) another);
  }

  private boolean equalTo(ImmutablePdbResidueIdentifier another) {
    return chainIdentifier.equals(another.chainIdentifier)
        && residueNumber == another.residueNumber
        && insertionCode.equals(another.insertionCode);
  }

  /**
   * Computes a hash code from attributes: {@code chainIdentifier}, {@code residueNumber}, {@code insertionCode}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + chainIdentifier.hashCode();
    h += (h << 5) + residueNumber;
    h += (h << 5) + insertionCode.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code PdbResidueIdentifier} instance.
   * @param chainIdentifier The value for the {@code chainIdentifier} attribute
   * @param residueNumber The value for the {@code residueNumber} attribute
   * @param insertionCode The value for the {@code insertionCode} attribute
   * @return An immutable PdbResidueIdentifier instance
   */
  public static ImmutablePdbResidueIdentifier of(String chainIdentifier, int residueNumber, String insertionCode) {
    return new ImmutablePdbResidueIdentifier(chainIdentifier, residueNumber, insertionCode);
  }

  /**
   * Creates an immutable copy of a {@link PdbResidueIdentifier} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PdbResidueIdentifier instance
   */
  public static ImmutablePdbResidueIdentifier copyOf(PdbResidueIdentifier instance) {
    if (instance instanceof ImmutablePdbResidueIdentifier) {
      return (ImmutablePdbResidueIdentifier) instance;
    }
    return ImmutablePdbResidueIdentifier.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePdbResidueIdentifier ImmutablePdbResidueIdentifier}.
   * <pre>
   * ImmutablePdbResidueIdentifier.builder()
   *    .chainIdentifier(String) // required {@link PdbResidueIdentifier#chainIdentifier() chainIdentifier}
   *    .residueNumber(int) // required {@link PdbResidueIdentifier#residueNumber() residueNumber}
   *    .insertionCode(String) // required {@link PdbResidueIdentifier#insertionCode() insertionCode}
   *    .build();
   * </pre>
   * @return A new ImmutablePdbResidueIdentifier builder
   */
  public static ImmutablePdbResidueIdentifier.Builder builder() {
    return new ImmutablePdbResidueIdentifier.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePdbResidueIdentifier ImmutablePdbResidueIdentifier}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PdbResidueIdentifier", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHAIN_IDENTIFIER = 0x1L;
    private static final long INIT_BIT_RESIDUE_NUMBER = 0x2L;
    private static final long INIT_BIT_INSERTION_CODE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String chainIdentifier;
    private int residueNumber;
    private @Nullable String insertionCode;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.pdb.PdbResidueIdentifier} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PdbResidueIdentifier instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.pdb.ChainNumberICode} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChainNumberICode instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof PdbResidueIdentifier) {
        PdbResidueIdentifier instance = (PdbResidueIdentifier) object;
        if ((bits & 0x2L) == 0) {
          insertionCode(instance.insertionCode());
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          residueNumber(instance.residueNumber());
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          chainIdentifier(instance.chainIdentifier());
          bits |= 0x4L;
        }
      }
      if (object instanceof ChainNumberICode) {
        ChainNumberICode instance = (ChainNumberICode) object;
        if ((bits & 0x2L) == 0) {
          insertionCode(instance.insertionCode());
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          residueNumber(instance.residueNumber());
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          chainIdentifier(instance.chainIdentifier());
          bits |= 0x4L;
        }
      }
    }

    /**
     * Initializes the value for the {@link PdbResidueIdentifier#chainIdentifier() chainIdentifier} attribute.
     * @param chainIdentifier The value for chainIdentifier 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder chainIdentifier(String chainIdentifier) {
      this.chainIdentifier = Objects.requireNonNull(chainIdentifier, "chainIdentifier");
      initBits &= ~INIT_BIT_CHAIN_IDENTIFIER;
      return this;
    }

    /**
     * Initializes the value for the {@link PdbResidueIdentifier#residueNumber() residueNumber} attribute.
     * @param residueNumber The value for residueNumber 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder residueNumber(int residueNumber) {
      this.residueNumber = residueNumber;
      initBits &= ~INIT_BIT_RESIDUE_NUMBER;
      return this;
    }

    /**
     * Initializes the value for the {@link PdbResidueIdentifier#insertionCode() insertionCode} attribute.
     * @param insertionCode The value for insertionCode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder insertionCode(String insertionCode) {
      this.insertionCode = Objects.requireNonNull(insertionCode, "insertionCode");
      initBits &= ~INIT_BIT_INSERTION_CODE;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePdbResidueIdentifier ImmutablePdbResidueIdentifier}.
     * @return An immutable instance of PdbResidueIdentifier
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePdbResidueIdentifier build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePdbResidueIdentifier(null, chainIdentifier, residueNumber, insertionCode);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CHAIN_IDENTIFIER) != 0) attributes.add("chainIdentifier");
      if ((initBits & INIT_BIT_RESIDUE_NUMBER) != 0) attributes.add("residueNumber");
      if ((initBits & INIT_BIT_INSERTION_CODE) != 0) attributes.add("insertionCode");
      return "Cannot build PdbResidueIdentifier, some of required attributes are not set " + attributes;
    }
  }
}
