package pl.poznan.put.pdb;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PdbRemark465Line}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePdbRemark465Line.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutablePdbRemark465Line.of()}.
 */
@Generated(from = "PdbRemark465Line", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutablePdbRemark465Line extends PdbRemark465Line {
  private final int modelNumber;
  private final String residueName;
  private final String chainIdentifier;
  private final int residueNumber;
  private final String insertionCode;

  private ImmutablePdbRemark465Line(
      int modelNumber,
      String residueName,
      String chainIdentifier,
      int residueNumber,
      String insertionCode) {
    this.modelNumber = modelNumber;
    this.residueName = Objects.requireNonNull(residueName, "residueName");
    this.chainIdentifier = Objects.requireNonNull(chainIdentifier, "chainIdentifier");
    this.residueNumber = residueNumber;
    this.insertionCode = Objects.requireNonNull(insertionCode, "insertionCode");
  }

  private ImmutablePdbRemark465Line(
      ImmutablePdbRemark465Line original,
      int modelNumber,
      String residueName,
      String chainIdentifier,
      int residueNumber,
      String insertionCode) {
    this.modelNumber = modelNumber;
    this.residueName = residueName;
    this.chainIdentifier = chainIdentifier;
    this.residueNumber = residueNumber;
    this.insertionCode = insertionCode;
  }

  /**
   *@return The value of the {@code modelNumber} attribute 
   */
  @Override
  public int modelNumber() {
    return modelNumber;
  }

  /**
   *@return The value of the {@code residueName} attribute 
   */
  @Override
  public String residueName() {
    return residueName;
  }

  /**
   *@return The value of the {@code chainIdentifier} attribute 
   */
  @Override
  public String chainIdentifier() {
    return chainIdentifier;
  }

  /**
   *@return The value of the {@code residueNumber} attribute 
   */
  @Override
  public int residueNumber() {
    return residueNumber;
  }

  /**
   *@return The value of the {@code insertionCode} attribute 
   */
  @Override
  public String insertionCode() {
    return insertionCode;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbRemark465Line#modelNumber() modelNumber} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modelNumber
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbRemark465Line withModelNumber(int value) {
    if (this.modelNumber == value) return this;
    return new ImmutablePdbRemark465Line(this, value, this.residueName, this.chainIdentifier, this.residueNumber, this.insertionCode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbRemark465Line#residueName() residueName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for residueName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbRemark465Line withResidueName(String value) {
    String newValue = Objects.requireNonNull(value, "residueName");
    if (this.residueName.equals(newValue)) return this;
    return new ImmutablePdbRemark465Line(this, this.modelNumber, newValue, this.chainIdentifier, this.residueNumber, this.insertionCode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbRemark465Line#chainIdentifier() chainIdentifier} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for chainIdentifier
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbRemark465Line withChainIdentifier(String value) {
    String newValue = Objects.requireNonNull(value, "chainIdentifier");
    if (this.chainIdentifier.equals(newValue)) return this;
    return new ImmutablePdbRemark465Line(this, this.modelNumber, this.residueName, newValue, this.residueNumber, this.insertionCode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbRemark465Line#residueNumber() residueNumber} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for residueNumber
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbRemark465Line withResidueNumber(int value) {
    if (this.residueNumber == value) return this;
    return new ImmutablePdbRemark465Line(this, this.modelNumber, this.residueName, this.chainIdentifier, value, this.insertionCode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbRemark465Line#insertionCode() insertionCode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for insertionCode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbRemark465Line withInsertionCode(String value) {
    String newValue = Objects.requireNonNull(value, "insertionCode");
    if (this.insertionCode.equals(newValue)) return this;
    return new ImmutablePdbRemark465Line(this, this.modelNumber, this.residueName, this.chainIdentifier, this.residueNumber, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePdbRemark465Line} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePdbRemark465Line
        && equalTo((ImmutablePdbRemark465Line) another);
  }

  private boolean equalTo(ImmutablePdbRemark465Line another) {
    return modelNumber == another.modelNumber
        && residueName.equals(another.residueName)
        && chainIdentifier.equals(another.chainIdentifier)
        && residueNumber == another.residueNumber
        && insertionCode.equals(another.insertionCode);
  }

  /**
   * Computes a hash code from attributes: {@code modelNumber}, {@code residueName}, {@code chainIdentifier}, {@code residueNumber}, {@code insertionCode}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + modelNumber;
    h += (h << 5) + residueName.hashCode();
    h += (h << 5) + chainIdentifier.hashCode();
    h += (h << 5) + residueNumber;
    h += (h << 5) + insertionCode.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code PdbRemark465Line} instance.
   * @param modelNumber The value for the {@code modelNumber} attribute
   * @param residueName The value for the {@code residueName} attribute
   * @param chainIdentifier The value for the {@code chainIdentifier} attribute
   * @param residueNumber The value for the {@code residueNumber} attribute
   * @param insertionCode The value for the {@code insertionCode} attribute
   * @return An immutable PdbRemark465Line instance
   */
  public static ImmutablePdbRemark465Line of(int modelNumber, String residueName, String chainIdentifier, int residueNumber, String insertionCode) {
    return new ImmutablePdbRemark465Line(modelNumber, residueName, chainIdentifier, residueNumber, insertionCode);
  }

  /**
   * Creates an immutable copy of a {@link PdbRemark465Line} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PdbRemark465Line instance
   */
  public static ImmutablePdbRemark465Line copyOf(PdbRemark465Line instance) {
    if (instance instanceof ImmutablePdbRemark465Line) {
      return (ImmutablePdbRemark465Line) instance;
    }
    return ImmutablePdbRemark465Line.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePdbRemark465Line ImmutablePdbRemark465Line}.
   * <pre>
   * ImmutablePdbRemark465Line.builder()
   *    .modelNumber(int) // required {@link PdbRemark465Line#modelNumber() modelNumber}
   *    .residueName(String) // required {@link PdbRemark465Line#residueName() residueName}
   *    .chainIdentifier(String) // required {@link PdbRemark465Line#chainIdentifier() chainIdentifier}
   *    .residueNumber(int) // required {@link PdbRemark465Line#residueNumber() residueNumber}
   *    .insertionCode(String) // required {@link PdbRemark465Line#insertionCode() insertionCode}
   *    .build();
   * </pre>
   * @return A new ImmutablePdbRemark465Line builder
   */
  public static ImmutablePdbRemark465Line.Builder builder() {
    return new ImmutablePdbRemark465Line.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePdbRemark465Line ImmutablePdbRemark465Line}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PdbRemark465Line", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_MODEL_NUMBER = 0x1L;
    private static final long INIT_BIT_RESIDUE_NAME = 0x2L;
    private static final long INIT_BIT_CHAIN_IDENTIFIER = 0x4L;
    private static final long INIT_BIT_RESIDUE_NUMBER = 0x8L;
    private static final long INIT_BIT_INSERTION_CODE = 0x10L;
    private long initBits = 0x1fL;

    private int modelNumber;
    private @Nullable String residueName;
    private @Nullable String chainIdentifier;
    private int residueNumber;
    private @Nullable String insertionCode;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.pdb.ChainNumberICode} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChainNumberICode instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.pdb.PdbRemark465Line} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PdbRemark465Line instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof ChainNumberICode) {
        ChainNumberICode instance = (ChainNumberICode) object;
        if ((bits & 0x2L) == 0) {
          insertionCode(instance.insertionCode());
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          residueNumber(instance.residueNumber());
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          chainIdentifier(instance.chainIdentifier());
          bits |= 0x4L;
        }
      }
      if (object instanceof PdbRemark465Line) {
        PdbRemark465Line instance = (PdbRemark465Line) object;
        residueName(instance.residueName());
        modelNumber(instance.modelNumber());
        if ((bits & 0x2L) == 0) {
          insertionCode(instance.insertionCode());
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          residueNumber(instance.residueNumber());
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          chainIdentifier(instance.chainIdentifier());
          bits |= 0x4L;
        }
      }
    }

    /**
     * Initializes the value for the {@link PdbRemark465Line#modelNumber() modelNumber} attribute.
     * @param modelNumber The value for modelNumber 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder modelNumber(int modelNumber) {
      this.modelNumber = modelNumber;
      initBits &= ~INIT_BIT_MODEL_NUMBER;
      return this;
    }

    /**
     * Initializes the value for the {@link PdbRemark465Line#residueName() residueName} attribute.
     * @param residueName The value for residueName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder residueName(String residueName) {
      this.residueName = Objects.requireNonNull(residueName, "residueName");
      initBits &= ~INIT_BIT_RESIDUE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link PdbRemark465Line#chainIdentifier() chainIdentifier} attribute.
     * @param chainIdentifier The value for chainIdentifier 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder chainIdentifier(String chainIdentifier) {
      this.chainIdentifier = Objects.requireNonNull(chainIdentifier, "chainIdentifier");
      initBits &= ~INIT_BIT_CHAIN_IDENTIFIER;
      return this;
    }

    /**
     * Initializes the value for the {@link PdbRemark465Line#residueNumber() residueNumber} attribute.
     * @param residueNumber The value for residueNumber 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder residueNumber(int residueNumber) {
      this.residueNumber = residueNumber;
      initBits &= ~INIT_BIT_RESIDUE_NUMBER;
      return this;
    }

    /**
     * Initializes the value for the {@link PdbRemark465Line#insertionCode() insertionCode} attribute.
     * @param insertionCode The value for insertionCode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder insertionCode(String insertionCode) {
      this.insertionCode = Objects.requireNonNull(insertionCode, "insertionCode");
      initBits &= ~INIT_BIT_INSERTION_CODE;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePdbRemark465Line ImmutablePdbRemark465Line}.
     * @return An immutable instance of PdbRemark465Line
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePdbRemark465Line build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePdbRemark465Line(null, modelNumber, residueName, chainIdentifier, residueNumber, insertionCode);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MODEL_NUMBER) != 0) attributes.add("modelNumber");
      if ((initBits & INIT_BIT_RESIDUE_NAME) != 0) attributes.add("residueName");
      if ((initBits & INIT_BIT_CHAIN_IDENTIFIER) != 0) attributes.add("chainIdentifier");
      if ((initBits & INIT_BIT_RESIDUE_NUMBER) != 0) attributes.add("residueNumber");
      if ((initBits & INIT_BIT_INSERTION_CODE) != 0) attributes.add("insertionCode");
      return "Cannot build PdbRemark465Line, some of required attributes are not set " + attributes;
    }
  }
}
