package pl.poznan.put.pdb;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PdbRemark2Line}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePdbRemark2Line.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutablePdbRemark2Line.of()}.
 */
@Generated(from = "PdbRemark2Line", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutablePdbRemark2Line extends PdbRemark2Line {
  private final double resolution;

  private ImmutablePdbRemark2Line(double resolution) {
    this.resolution = resolution;
  }

  private ImmutablePdbRemark2Line(ImmutablePdbRemark2Line original, double resolution) {
    this.resolution = resolution;
  }

  /**
   *@return The value of the {@code resolution} attribute 
   */
  @Override
  public double resolution() {
    return resolution;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbRemark2Line#resolution() resolution} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for resolution
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbRemark2Line withResolution(double value) {
    if (Double.doubleToLongBits(this.resolution) == Double.doubleToLongBits(value)) return this;
    return new ImmutablePdbRemark2Line(this, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePdbRemark2Line} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePdbRemark2Line
        && equalTo((ImmutablePdbRemark2Line) another);
  }

  private boolean equalTo(ImmutablePdbRemark2Line another) {
    return Double.doubleToLongBits(resolution) == Double.doubleToLongBits(another.resolution);
  }

  /**
   * Computes a hash code from attributes: {@code resolution}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Double.hashCode(resolution);
    return h;
  }

  /**
   * Construct a new immutable {@code PdbRemark2Line} instance.
   * @param resolution The value for the {@code resolution} attribute
   * @return An immutable PdbRemark2Line instance
   */
  public static ImmutablePdbRemark2Line of(double resolution) {
    return new ImmutablePdbRemark2Line(resolution);
  }

  /**
   * Creates an immutable copy of a {@link PdbRemark2Line} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PdbRemark2Line instance
   */
  public static ImmutablePdbRemark2Line copyOf(PdbRemark2Line instance) {
    if (instance instanceof ImmutablePdbRemark2Line) {
      return (ImmutablePdbRemark2Line) instance;
    }
    return ImmutablePdbRemark2Line.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePdbRemark2Line ImmutablePdbRemark2Line}.
   * <pre>
   * ImmutablePdbRemark2Line.builder()
   *    .resolution(double) // required {@link PdbRemark2Line#resolution() resolution}
   *    .build();
   * </pre>
   * @return A new ImmutablePdbRemark2Line builder
   */
  public static ImmutablePdbRemark2Line.Builder builder() {
    return new ImmutablePdbRemark2Line.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePdbRemark2Line ImmutablePdbRemark2Line}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PdbRemark2Line", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_RESOLUTION = 0x1L;
    private long initBits = 0x1L;

    private double resolution;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PdbRemark2Line} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PdbRemark2Line instance) {
      Objects.requireNonNull(instance, "instance");
      resolution(instance.resolution());
      return this;
    }

    /**
     * Initializes the value for the {@link PdbRemark2Line#resolution() resolution} attribute.
     * @param resolution The value for resolution 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resolution(double resolution) {
      this.resolution = resolution;
      initBits &= ~INIT_BIT_RESOLUTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePdbRemark2Line ImmutablePdbRemark2Line}.
     * @return An immutable instance of PdbRemark2Line
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePdbRemark2Line build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePdbRemark2Line(null, resolution);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RESOLUTION) != 0) attributes.add("resolution");
      return "Cannot build PdbRemark2Line, some of required attributes are not set " + attributes;
    }
  }
}
