package pl.poznan.put.pdb;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PdbNamedResidueIdentifier}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePdbNamedResidueIdentifier.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutablePdbNamedResidueIdentifier.of()}.
 */
@Generated(from = "PdbNamedResidueIdentifier", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutablePdbNamedResidueIdentifier extends PdbNamedResidueIdentifier {
  private final String chainIdentifier;
  private final int residueNumber;
  private final String insertionCode;
  private final char oneLetterName;

  private ImmutablePdbNamedResidueIdentifier(
      String chainIdentifier,
      int residueNumber,
      String insertionCode,
      char oneLetterName) {
    this.chainIdentifier = Objects.requireNonNull(chainIdentifier, "chainIdentifier");
    this.residueNumber = residueNumber;
    this.insertionCode = Objects.requireNonNull(insertionCode, "insertionCode");
    this.oneLetterName = oneLetterName;
  }

  private ImmutablePdbNamedResidueIdentifier(
      ImmutablePdbNamedResidueIdentifier original,
      String chainIdentifier,
      int residueNumber,
      String insertionCode,
      char oneLetterName) {
    this.chainIdentifier = chainIdentifier;
    this.residueNumber = residueNumber;
    this.insertionCode = insertionCode;
    this.oneLetterName = oneLetterName;
  }

  /**
   * @return The value of the {@code chainIdentifier} attribute
   */
  @Override
  public String chainIdentifier() {
    return chainIdentifier;
  }

  /**
   * @return The value of the {@code residueNumber} attribute
   */
  @Override
  public int residueNumber() {
    return residueNumber;
  }

  /**
   * @return The value of the {@code insertionCode} attribute
   */
  @Override
  public String insertionCode() {
    return insertionCode;
  }

  /**
   *@return The one letter name of the residue. 
   */
  @Override
  public char oneLetterName() {
    return oneLetterName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbNamedResidueIdentifier#chainIdentifier() chainIdentifier} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for chainIdentifier
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbNamedResidueIdentifier withChainIdentifier(String value) {
    String newValue = Objects.requireNonNull(value, "chainIdentifier");
    if (this.chainIdentifier.equals(newValue)) return this;
    return new ImmutablePdbNamedResidueIdentifier(this, newValue, this.residueNumber, this.insertionCode, this.oneLetterName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbNamedResidueIdentifier#residueNumber() residueNumber} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for residueNumber
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbNamedResidueIdentifier withResidueNumber(int value) {
    if (this.residueNumber == value) return this;
    return new ImmutablePdbNamedResidueIdentifier(this, this.chainIdentifier, value, this.insertionCode, this.oneLetterName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbNamedResidueIdentifier#insertionCode() insertionCode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for insertionCode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbNamedResidueIdentifier withInsertionCode(String value) {
    String newValue = Objects.requireNonNull(value, "insertionCode");
    if (this.insertionCode.equals(newValue)) return this;
    return new ImmutablePdbNamedResidueIdentifier(this, this.chainIdentifier, this.residueNumber, newValue, this.oneLetterName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbNamedResidueIdentifier#oneLetterName() oneLetterName} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for oneLetterName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbNamedResidueIdentifier withOneLetterName(char value) {
    if (this.oneLetterName == value) return this;
    return new ImmutablePdbNamedResidueIdentifier(this, this.chainIdentifier, this.residueNumber, this.insertionCode, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePdbNamedResidueIdentifier} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePdbNamedResidueIdentifier
        && equalTo((ImmutablePdbNamedResidueIdentifier) another);
  }

  private boolean equalTo(ImmutablePdbNamedResidueIdentifier another) {
    return chainIdentifier.equals(another.chainIdentifier)
        && residueNumber == another.residueNumber
        && insertionCode.equals(another.insertionCode)
        && oneLetterName == another.oneLetterName;
  }

  /**
   * Computes a hash code from attributes: {@code chainIdentifier}, {@code residueNumber}, {@code insertionCode}, {@code oneLetterName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + chainIdentifier.hashCode();
    h += (h << 5) + residueNumber;
    h += (h << 5) + insertionCode.hashCode();
    h += (h << 5) + Character.hashCode(oneLetterName);
    return h;
  }

  /**
   * Construct a new immutable {@code PdbNamedResidueIdentifier} instance.
   * @param chainIdentifier The value for the {@code chainIdentifier} attribute
   * @param residueNumber The value for the {@code residueNumber} attribute
   * @param insertionCode The value for the {@code insertionCode} attribute
   * @param oneLetterName The value for the {@code oneLetterName} attribute
   * @return An immutable PdbNamedResidueIdentifier instance
   */
  public static ImmutablePdbNamedResidueIdentifier of(String chainIdentifier, int residueNumber, String insertionCode, char oneLetterName) {
    return new ImmutablePdbNamedResidueIdentifier(chainIdentifier, residueNumber, insertionCode, oneLetterName);
  }

  /**
   * Creates an immutable copy of a {@link PdbNamedResidueIdentifier} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PdbNamedResidueIdentifier instance
   */
  public static ImmutablePdbNamedResidueIdentifier copyOf(PdbNamedResidueIdentifier instance) {
    if (instance instanceof ImmutablePdbNamedResidueIdentifier) {
      return (ImmutablePdbNamedResidueIdentifier) instance;
    }
    return ImmutablePdbNamedResidueIdentifier.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePdbNamedResidueIdentifier ImmutablePdbNamedResidueIdentifier}.
   * <pre>
   * ImmutablePdbNamedResidueIdentifier.builder()
   *    .chainIdentifier(String) // required {@link PdbNamedResidueIdentifier#chainIdentifier() chainIdentifier}
   *    .residueNumber(int) // required {@link PdbNamedResidueIdentifier#residueNumber() residueNumber}
   *    .insertionCode(String) // required {@link PdbNamedResidueIdentifier#insertionCode() insertionCode}
   *    .oneLetterName(char) // required {@link PdbNamedResidueIdentifier#oneLetterName() oneLetterName}
   *    .build();
   * </pre>
   * @return A new ImmutablePdbNamedResidueIdentifier builder
   */
  public static ImmutablePdbNamedResidueIdentifier.Builder builder() {
    return new ImmutablePdbNamedResidueIdentifier.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePdbNamedResidueIdentifier ImmutablePdbNamedResidueIdentifier}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PdbNamedResidueIdentifier", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHAIN_IDENTIFIER = 0x1L;
    private static final long INIT_BIT_RESIDUE_NUMBER = 0x2L;
    private static final long INIT_BIT_INSERTION_CODE = 0x4L;
    private static final long INIT_BIT_ONE_LETTER_NAME = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String chainIdentifier;
    private int residueNumber;
    private @Nullable String insertionCode;
    private char oneLetterName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.pdb.ChainNumberICode} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChainNumberICode instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.pdb.PdbNamedResidueIdentifier} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PdbNamedResidueIdentifier instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof ChainNumberICode) {
        ChainNumberICode instance = (ChainNumberICode) object;
        if ((bits & 0x2L) == 0) {
          insertionCode(instance.insertionCode());
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          residueNumber(instance.residueNumber());
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          chainIdentifier(instance.chainIdentifier());
          bits |= 0x4L;
        }
      }
      if (object instanceof PdbNamedResidueIdentifier) {
        PdbNamedResidueIdentifier instance = (PdbNamedResidueIdentifier) object;
        oneLetterName(instance.oneLetterName());
        if ((bits & 0x2L) == 0) {
          insertionCode(instance.insertionCode());
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          residueNumber(instance.residueNumber());
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          chainIdentifier(instance.chainIdentifier());
          bits |= 0x4L;
        }
      }
    }

    /**
     * Initializes the value for the {@link PdbNamedResidueIdentifier#chainIdentifier() chainIdentifier} attribute.
     * @param chainIdentifier The value for chainIdentifier 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder chainIdentifier(String chainIdentifier) {
      this.chainIdentifier = Objects.requireNonNull(chainIdentifier, "chainIdentifier");
      initBits &= ~INIT_BIT_CHAIN_IDENTIFIER;
      return this;
    }

    /**
     * Initializes the value for the {@link PdbNamedResidueIdentifier#residueNumber() residueNumber} attribute.
     * @param residueNumber The value for residueNumber 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder residueNumber(int residueNumber) {
      this.residueNumber = residueNumber;
      initBits &= ~INIT_BIT_RESIDUE_NUMBER;
      return this;
    }

    /**
     * Initializes the value for the {@link PdbNamedResidueIdentifier#insertionCode() insertionCode} attribute.
     * @param insertionCode The value for insertionCode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder insertionCode(String insertionCode) {
      this.insertionCode = Objects.requireNonNull(insertionCode, "insertionCode");
      initBits &= ~INIT_BIT_INSERTION_CODE;
      return this;
    }

    /**
     * Initializes the value for the {@link PdbNamedResidueIdentifier#oneLetterName() oneLetterName} attribute.
     * @param oneLetterName The value for oneLetterName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder oneLetterName(char oneLetterName) {
      this.oneLetterName = oneLetterName;
      initBits &= ~INIT_BIT_ONE_LETTER_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePdbNamedResidueIdentifier ImmutablePdbNamedResidueIdentifier}.
     * @return An immutable instance of PdbNamedResidueIdentifier
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePdbNamedResidueIdentifier build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePdbNamedResidueIdentifier(null, chainIdentifier, residueNumber, insertionCode, oneLetterName);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CHAIN_IDENTIFIER) != 0) attributes.add("chainIdentifier");
      if ((initBits & INIT_BIT_RESIDUE_NUMBER) != 0) attributes.add("residueNumber");
      if ((initBits & INIT_BIT_INSERTION_CODE) != 0) attributes.add("insertionCode");
      if ((initBits & INIT_BIT_ONE_LETTER_NAME) != 0) attributes.add("oneLetterName");
      return "Cannot build PdbNamedResidueIdentifier, some of required attributes are not set " + attributes;
    }
  }
}
