package pl.poznan.put.pdb;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PdbModresLine}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePdbModresLine.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutablePdbModresLine.of()}.
 */
@Generated(from = "PdbModresLine", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutablePdbModresLine extends PdbModresLine {
  private final String idCode;
  private final String residueName;
  private final String chainIdentifier;
  private final int residueNumber;
  private final String insertionCode;
  private final String standardResidueName;
  private final String comment;

  private ImmutablePdbModresLine(
      String idCode,
      String residueName,
      String chainIdentifier,
      int residueNumber,
      String insertionCode,
      String standardResidueName,
      String comment) {
    this.idCode = Objects.requireNonNull(idCode, "idCode");
    this.residueName = Objects.requireNonNull(residueName, "residueName");
    this.chainIdentifier = Objects.requireNonNull(chainIdentifier, "chainIdentifier");
    this.residueNumber = residueNumber;
    this.insertionCode = Objects.requireNonNull(insertionCode, "insertionCode");
    this.standardResidueName = Objects.requireNonNull(standardResidueName, "standardResidueName");
    this.comment = Objects.requireNonNull(comment, "comment");
  }

  private ImmutablePdbModresLine(
      ImmutablePdbModresLine original,
      String idCode,
      String residueName,
      String chainIdentifier,
      int residueNumber,
      String insertionCode,
      String standardResidueName,
      String comment) {
    this.idCode = idCode;
    this.residueName = residueName;
    this.chainIdentifier = chainIdentifier;
    this.residueNumber = residueNumber;
    this.insertionCode = insertionCode;
    this.standardResidueName = standardResidueName;
    this.comment = comment;
  }

  /**
   *@return The value of the {@code idCode} attribute 
   */
  @Override
  public String idCode() {
    return idCode;
  }

  /**
   *@return The value of the {@code residueName} attribute 
   */
  @Override
  public String residueName() {
    return residueName;
  }

  /**
   *@return The value of the {@code chainIdentifier} attribute 
   */
  @Override
  public String chainIdentifier() {
    return chainIdentifier;
  }

  /**
   *@return The value of the {@code residueNumber} attribute 
   */
  @Override
  public int residueNumber() {
    return residueNumber;
  }

  /**
   *@return The value of the {@code insertionCode} attribute 
   */
  @Override
  public String insertionCode() {
    return insertionCode;
  }

  /**
   *@return The value of the {@code standardResidueName} attribute 
   */
  @Override
  public String standardResidueName() {
    return standardResidueName;
  }

  /**
   *@return The value of the {@code comment} attribute 
   */
  @Override
  public String comment() {
    return comment;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbModresLine#idCode() idCode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for idCode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbModresLine withIdCode(String value) {
    String newValue = Objects.requireNonNull(value, "idCode");
    if (this.idCode.equals(newValue)) return this;
    return new ImmutablePdbModresLine(
        this,
        newValue,
        this.residueName,
        this.chainIdentifier,
        this.residueNumber,
        this.insertionCode,
        this.standardResidueName,
        this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbModresLine#residueName() residueName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for residueName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbModresLine withResidueName(String value) {
    String newValue = Objects.requireNonNull(value, "residueName");
    if (this.residueName.equals(newValue)) return this;
    return new ImmutablePdbModresLine(
        this,
        this.idCode,
        newValue,
        this.chainIdentifier,
        this.residueNumber,
        this.insertionCode,
        this.standardResidueName,
        this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbModresLine#chainIdentifier() chainIdentifier} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for chainIdentifier
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbModresLine withChainIdentifier(String value) {
    String newValue = Objects.requireNonNull(value, "chainIdentifier");
    if (this.chainIdentifier.equals(newValue)) return this;
    return new ImmutablePdbModresLine(
        this,
        this.idCode,
        this.residueName,
        newValue,
        this.residueNumber,
        this.insertionCode,
        this.standardResidueName,
        this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbModresLine#residueNumber() residueNumber} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for residueNumber
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbModresLine withResidueNumber(int value) {
    if (this.residueNumber == value) return this;
    return new ImmutablePdbModresLine(
        this,
        this.idCode,
        this.residueName,
        this.chainIdentifier,
        value,
        this.insertionCode,
        this.standardResidueName,
        this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbModresLine#insertionCode() insertionCode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for insertionCode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbModresLine withInsertionCode(String value) {
    String newValue = Objects.requireNonNull(value, "insertionCode");
    if (this.insertionCode.equals(newValue)) return this;
    return new ImmutablePdbModresLine(
        this,
        this.idCode,
        this.residueName,
        this.chainIdentifier,
        this.residueNumber,
        newValue,
        this.standardResidueName,
        this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbModresLine#standardResidueName() standardResidueName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for standardResidueName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbModresLine withStandardResidueName(String value) {
    String newValue = Objects.requireNonNull(value, "standardResidueName");
    if (this.standardResidueName.equals(newValue)) return this;
    return new ImmutablePdbModresLine(
        this,
        this.idCode,
        this.residueName,
        this.chainIdentifier,
        this.residueNumber,
        this.insertionCode,
        newValue,
        this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbModresLine#comment() comment} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for comment
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbModresLine withComment(String value) {
    String newValue = Objects.requireNonNull(value, "comment");
    if (this.comment.equals(newValue)) return this;
    return new ImmutablePdbModresLine(
        this,
        this.idCode,
        this.residueName,
        this.chainIdentifier,
        this.residueNumber,
        this.insertionCode,
        this.standardResidueName,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePdbModresLine} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePdbModresLine
        && equalTo((ImmutablePdbModresLine) another);
  }

  private boolean equalTo(ImmutablePdbModresLine another) {
    return idCode.equals(another.idCode)
        && residueName.equals(another.residueName)
        && chainIdentifier.equals(another.chainIdentifier)
        && residueNumber == another.residueNumber
        && insertionCode.equals(another.insertionCode)
        && standardResidueName.equals(another.standardResidueName)
        && comment.equals(another.comment);
  }

  /**
   * Computes a hash code from attributes: {@code idCode}, {@code residueName}, {@code chainIdentifier}, {@code residueNumber}, {@code insertionCode}, {@code standardResidueName}, {@code comment}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + idCode.hashCode();
    h += (h << 5) + residueName.hashCode();
    h += (h << 5) + chainIdentifier.hashCode();
    h += (h << 5) + residueNumber;
    h += (h << 5) + insertionCode.hashCode();
    h += (h << 5) + standardResidueName.hashCode();
    h += (h << 5) + comment.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code PdbModresLine} instance.
   * @param idCode The value for the {@code idCode} attribute
   * @param residueName The value for the {@code residueName} attribute
   * @param chainIdentifier The value for the {@code chainIdentifier} attribute
   * @param residueNumber The value for the {@code residueNumber} attribute
   * @param insertionCode The value for the {@code insertionCode} attribute
   * @param standardResidueName The value for the {@code standardResidueName} attribute
   * @param comment The value for the {@code comment} attribute
   * @return An immutable PdbModresLine instance
   */
  public static ImmutablePdbModresLine of(String idCode, String residueName, String chainIdentifier, int residueNumber, String insertionCode, String standardResidueName, String comment) {
    return new ImmutablePdbModresLine(idCode, residueName, chainIdentifier, residueNumber, insertionCode, standardResidueName, comment);
  }

  /**
   * Creates an immutable copy of a {@link PdbModresLine} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PdbModresLine instance
   */
  public static ImmutablePdbModresLine copyOf(PdbModresLine instance) {
    if (instance instanceof ImmutablePdbModresLine) {
      return (ImmutablePdbModresLine) instance;
    }
    return ImmutablePdbModresLine.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePdbModresLine ImmutablePdbModresLine}.
   * <pre>
   * ImmutablePdbModresLine.builder()
   *    .idCode(String) // required {@link PdbModresLine#idCode() idCode}
   *    .residueName(String) // required {@link PdbModresLine#residueName() residueName}
   *    .chainIdentifier(String) // required {@link PdbModresLine#chainIdentifier() chainIdentifier}
   *    .residueNumber(int) // required {@link PdbModresLine#residueNumber() residueNumber}
   *    .insertionCode(String) // required {@link PdbModresLine#insertionCode() insertionCode}
   *    .standardResidueName(String) // required {@link PdbModresLine#standardResidueName() standardResidueName}
   *    .comment(String) // required {@link PdbModresLine#comment() comment}
   *    .build();
   * </pre>
   * @return A new ImmutablePdbModresLine builder
   */
  public static ImmutablePdbModresLine.Builder builder() {
    return new ImmutablePdbModresLine.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePdbModresLine ImmutablePdbModresLine}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PdbModresLine", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID_CODE = 0x1L;
    private static final long INIT_BIT_RESIDUE_NAME = 0x2L;
    private static final long INIT_BIT_CHAIN_IDENTIFIER = 0x4L;
    private static final long INIT_BIT_RESIDUE_NUMBER = 0x8L;
    private static final long INIT_BIT_INSERTION_CODE = 0x10L;
    private static final long INIT_BIT_STANDARD_RESIDUE_NAME = 0x20L;
    private static final long INIT_BIT_COMMENT = 0x40L;
    private long initBits = 0x7fL;

    private @Nullable String idCode;
    private @Nullable String residueName;
    private @Nullable String chainIdentifier;
    private int residueNumber;
    private @Nullable String insertionCode;
    private @Nullable String standardResidueName;
    private @Nullable String comment;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.pdb.ChainNumberICode} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChainNumberICode instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.pdb.PdbModresLine} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PdbModresLine instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof ChainNumberICode) {
        ChainNumberICode instance = (ChainNumberICode) object;
        if ((bits & 0x2L) == 0) {
          insertionCode(instance.insertionCode());
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          residueNumber(instance.residueNumber());
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          chainIdentifier(instance.chainIdentifier());
          bits |= 0x4L;
        }
      }
      if (object instanceof PdbModresLine) {
        PdbModresLine instance = (PdbModresLine) object;
        standardResidueName(instance.standardResidueName());
        residueName(instance.residueName());
        idCode(instance.idCode());
        if ((bits & 0x1L) == 0) {
          residueNumber(instance.residueNumber());
          bits |= 0x1L;
        }
        comment(instance.comment());
        if ((bits & 0x2L) == 0) {
          insertionCode(instance.insertionCode());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          chainIdentifier(instance.chainIdentifier());
          bits |= 0x4L;
        }
      }
    }

    /**
     * Initializes the value for the {@link PdbModresLine#idCode() idCode} attribute.
     * @param idCode The value for idCode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder idCode(String idCode) {
      this.idCode = Objects.requireNonNull(idCode, "idCode");
      initBits &= ~INIT_BIT_ID_CODE;
      return this;
    }

    /**
     * Initializes the value for the {@link PdbModresLine#residueName() residueName} attribute.
     * @param residueName The value for residueName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder residueName(String residueName) {
      this.residueName = Objects.requireNonNull(residueName, "residueName");
      initBits &= ~INIT_BIT_RESIDUE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link PdbModresLine#chainIdentifier() chainIdentifier} attribute.
     * @param chainIdentifier The value for chainIdentifier 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder chainIdentifier(String chainIdentifier) {
      this.chainIdentifier = Objects.requireNonNull(chainIdentifier, "chainIdentifier");
      initBits &= ~INIT_BIT_CHAIN_IDENTIFIER;
      return this;
    }

    /**
     * Initializes the value for the {@link PdbModresLine#residueNumber() residueNumber} attribute.
     * @param residueNumber The value for residueNumber 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder residueNumber(int residueNumber) {
      this.residueNumber = residueNumber;
      initBits &= ~INIT_BIT_RESIDUE_NUMBER;
      return this;
    }

    /**
     * Initializes the value for the {@link PdbModresLine#insertionCode() insertionCode} attribute.
     * @param insertionCode The value for insertionCode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder insertionCode(String insertionCode) {
      this.insertionCode = Objects.requireNonNull(insertionCode, "insertionCode");
      initBits &= ~INIT_BIT_INSERTION_CODE;
      return this;
    }

    /**
     * Initializes the value for the {@link PdbModresLine#standardResidueName() standardResidueName} attribute.
     * @param standardResidueName The value for standardResidueName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder standardResidueName(String standardResidueName) {
      this.standardResidueName = Objects.requireNonNull(standardResidueName, "standardResidueName");
      initBits &= ~INIT_BIT_STANDARD_RESIDUE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link PdbModresLine#comment() comment} attribute.
     * @param comment The value for comment 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder comment(String comment) {
      this.comment = Objects.requireNonNull(comment, "comment");
      initBits &= ~INIT_BIT_COMMENT;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePdbModresLine ImmutablePdbModresLine}.
     * @return An immutable instance of PdbModresLine
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePdbModresLine build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePdbModresLine(
          null,
          idCode,
          residueName,
          chainIdentifier,
          residueNumber,
          insertionCode,
          standardResidueName,
          comment);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID_CODE) != 0) attributes.add("idCode");
      if ((initBits & INIT_BIT_RESIDUE_NAME) != 0) attributes.add("residueName");
      if ((initBits & INIT_BIT_CHAIN_IDENTIFIER) != 0) attributes.add("chainIdentifier");
      if ((initBits & INIT_BIT_RESIDUE_NUMBER) != 0) attributes.add("residueNumber");
      if ((initBits & INIT_BIT_INSERTION_CODE) != 0) attributes.add("insertionCode");
      if ((initBits & INIT_BIT_STANDARD_RESIDUE_NAME) != 0) attributes.add("standardResidueName");
      if ((initBits & INIT_BIT_COMMENT) != 0) attributes.add("comment");
      return "Cannot build PdbModresLine, some of required attributes are not set " + attributes;
    }
  }
}
