package pl.poznan.put.pdb;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PdbHeaderLine}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePdbHeaderLine.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutablePdbHeaderLine.of()}.
 */
@Generated(from = "PdbHeaderLine", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutablePdbHeaderLine extends PdbHeaderLine {
  private final String classification;
  private final Date depositionDate;
  private final String idCode;

  private ImmutablePdbHeaderLine(String classification, Date depositionDate, String idCode) {
    this.classification = Objects.requireNonNull(classification, "classification");
    this.depositionDate = Objects.requireNonNull(depositionDate, "depositionDate");
    this.idCode = Objects.requireNonNull(idCode, "idCode");
  }

  private ImmutablePdbHeaderLine(
      ImmutablePdbHeaderLine original,
      String classification,
      Date depositionDate,
      String idCode) {
    this.classification = classification;
    this.depositionDate = depositionDate;
    this.idCode = idCode;
  }

  /**
   *@return The value of the {@code classification} attribute 
   */
  @Override
  public String classification() {
    return classification;
  }

  /**
   *@return The value of the {@code depositionDate} attribute 
   */
  @Override
  public Date depositionDate() {
    return depositionDate;
  }

  /**
   *@return The value of the {@code idCode} attribute 
   */
  @Override
  public String idCode() {
    return idCode;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbHeaderLine#classification() classification} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for classification
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbHeaderLine withClassification(String value) {
    String newValue = Objects.requireNonNull(value, "classification");
    if (this.classification.equals(newValue)) return this;
    return new ImmutablePdbHeaderLine(this, newValue, this.depositionDate, this.idCode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbHeaderLine#depositionDate() depositionDate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for depositionDate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbHeaderLine withDepositionDate(Date value) {
    if (this.depositionDate == value) return this;
    Date newValue = Objects.requireNonNull(value, "depositionDate");
    return new ImmutablePdbHeaderLine(this, this.classification, newValue, this.idCode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdbHeaderLine#idCode() idCode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for idCode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePdbHeaderLine withIdCode(String value) {
    String newValue = Objects.requireNonNull(value, "idCode");
    if (this.idCode.equals(newValue)) return this;
    return new ImmutablePdbHeaderLine(this, this.classification, this.depositionDate, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePdbHeaderLine} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePdbHeaderLine
        && equalTo((ImmutablePdbHeaderLine) another);
  }

  private boolean equalTo(ImmutablePdbHeaderLine another) {
    return classification.equals(another.classification)
        && depositionDate.equals(another.depositionDate)
        && idCode.equals(another.idCode);
  }

  /**
   * Computes a hash code from attributes: {@code classification}, {@code depositionDate}, {@code idCode}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + classification.hashCode();
    h += (h << 5) + depositionDate.hashCode();
    h += (h << 5) + idCode.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code PdbHeaderLine} instance.
   * @param classification The value for the {@code classification} attribute
   * @param depositionDate The value for the {@code depositionDate} attribute
   * @param idCode The value for the {@code idCode} attribute
   * @return An immutable PdbHeaderLine instance
   */
  public static ImmutablePdbHeaderLine of(String classification, Date depositionDate, String idCode) {
    return new ImmutablePdbHeaderLine(classification, depositionDate, idCode);
  }

  /**
   * Creates an immutable copy of a {@link PdbHeaderLine} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PdbHeaderLine instance
   */
  public static ImmutablePdbHeaderLine copyOf(PdbHeaderLine instance) {
    if (instance instanceof ImmutablePdbHeaderLine) {
      return (ImmutablePdbHeaderLine) instance;
    }
    return ImmutablePdbHeaderLine.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePdbHeaderLine ImmutablePdbHeaderLine}.
   * <pre>
   * ImmutablePdbHeaderLine.builder()
   *    .classification(String) // required {@link PdbHeaderLine#classification() classification}
   *    .depositionDate(Date) // required {@link PdbHeaderLine#depositionDate() depositionDate}
   *    .idCode(String) // required {@link PdbHeaderLine#idCode() idCode}
   *    .build();
   * </pre>
   * @return A new ImmutablePdbHeaderLine builder
   */
  public static ImmutablePdbHeaderLine.Builder builder() {
    return new ImmutablePdbHeaderLine.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePdbHeaderLine ImmutablePdbHeaderLine}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PdbHeaderLine", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CLASSIFICATION = 0x1L;
    private static final long INIT_BIT_DEPOSITION_DATE = 0x2L;
    private static final long INIT_BIT_ID_CODE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String classification;
    private @Nullable Date depositionDate;
    private @Nullable String idCode;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PdbHeaderLine} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PdbHeaderLine instance) {
      Objects.requireNonNull(instance, "instance");
      classification(instance.classification());
      depositionDate(instance.depositionDate());
      idCode(instance.idCode());
      return this;
    }

    /**
     * Initializes the value for the {@link PdbHeaderLine#classification() classification} attribute.
     * @param classification The value for classification 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder classification(String classification) {
      this.classification = Objects.requireNonNull(classification, "classification");
      initBits &= ~INIT_BIT_CLASSIFICATION;
      return this;
    }

    /**
     * Initializes the value for the {@link PdbHeaderLine#depositionDate() depositionDate} attribute.
     * @param depositionDate The value for depositionDate 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder depositionDate(Date depositionDate) {
      this.depositionDate = Objects.requireNonNull(depositionDate, "depositionDate");
      initBits &= ~INIT_BIT_DEPOSITION_DATE;
      return this;
    }

    /**
     * Initializes the value for the {@link PdbHeaderLine#idCode() idCode} attribute.
     * @param idCode The value for idCode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder idCode(String idCode) {
      this.idCode = Objects.requireNonNull(idCode, "idCode");
      initBits &= ~INIT_BIT_ID_CODE;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePdbHeaderLine ImmutablePdbHeaderLine}.
     * @return An immutable instance of PdbHeaderLine
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePdbHeaderLine build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePdbHeaderLine(null, classification, depositionDate, idCode);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLASSIFICATION) != 0) attributes.add("classification");
      if ((initBits & INIT_BIT_DEPOSITION_DATE) != 0) attributes.add("depositionDate");
      if ((initBits & INIT_BIT_ID_CODE) != 0) attributes.add("idCode");
      return "Cannot build PdbHeaderLine, some of required attributes are not set " + attributes;
    }
  }
}
