package pl.poznan.put.pdb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PdbExpdtaLine}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePdbExpdtaLine.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutablePdbExpdtaLine.of()}.
 */
@Generated(from = "PdbExpdtaLine", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutablePdbExpdtaLine extends PdbExpdtaLine {
  private final List<ExperimentalTechnique> experimentalTechniques;

  private ImmutablePdbExpdtaLine(Iterable<? extends ExperimentalTechnique> experimentalTechniques) {
    this.experimentalTechniques = createUnmodifiableList(false, createSafeList(experimentalTechniques, true, false));
  }

  private ImmutablePdbExpdtaLine(
      ImmutablePdbExpdtaLine original,
      List<ExperimentalTechnique> experimentalTechniques) {
    this.experimentalTechniques = experimentalTechniques;
  }

  /**
   *@return The value of the {@code experimentalTechniques} attribute 
   */
  @Override
  public List<ExperimentalTechnique> experimentalTechniques() {
    return experimentalTechniques;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PdbExpdtaLine#experimentalTechniques() experimentalTechniques}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePdbExpdtaLine withExperimentalTechniques(ExperimentalTechnique... elements) {
    List<ExperimentalTechnique> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutablePdbExpdtaLine(this, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PdbExpdtaLine#experimentalTechniques() experimentalTechniques}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of experimentalTechniques elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePdbExpdtaLine withExperimentalTechniques(Iterable<? extends ExperimentalTechnique> elements) {
    if (this.experimentalTechniques == elements) return this;
    List<ExperimentalTechnique> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutablePdbExpdtaLine(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePdbExpdtaLine} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePdbExpdtaLine
        && equalTo((ImmutablePdbExpdtaLine) another);
  }

  private boolean equalTo(ImmutablePdbExpdtaLine another) {
    return experimentalTechniques.equals(another.experimentalTechniques);
  }

  /**
   * Computes a hash code from attributes: {@code experimentalTechniques}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + experimentalTechniques.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code PdbExpdtaLine} instance.
   * @param experimentalTechniques The value for the {@code experimentalTechniques} attribute
   * @return An immutable PdbExpdtaLine instance
   */
  public static ImmutablePdbExpdtaLine of(List<ExperimentalTechnique> experimentalTechniques) {
    return of((Iterable<? extends ExperimentalTechnique>) experimentalTechniques);
  }

  /**
   * Construct a new immutable {@code PdbExpdtaLine} instance.
   * @param experimentalTechniques The value for the {@code experimentalTechniques} attribute
   * @return An immutable PdbExpdtaLine instance
   */
  public static ImmutablePdbExpdtaLine of(Iterable<? extends ExperimentalTechnique> experimentalTechniques) {
    return new ImmutablePdbExpdtaLine(experimentalTechniques);
  }

  /**
   * Creates an immutable copy of a {@link PdbExpdtaLine} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PdbExpdtaLine instance
   */
  public static ImmutablePdbExpdtaLine copyOf(PdbExpdtaLine instance) {
    if (instance instanceof ImmutablePdbExpdtaLine) {
      return (ImmutablePdbExpdtaLine) instance;
    }
    return ImmutablePdbExpdtaLine.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePdbExpdtaLine ImmutablePdbExpdtaLine}.
   * <pre>
   * ImmutablePdbExpdtaLine.builder()
   *    .addExperimentalTechniques|addAllExperimentalTechniques(pl.poznan.put.pdb.ExperimentalTechnique) // {@link PdbExpdtaLine#experimentalTechniques() experimentalTechniques} elements
   *    .build();
   * </pre>
   * @return A new ImmutablePdbExpdtaLine builder
   */
  public static ImmutablePdbExpdtaLine.Builder builder() {
    return new ImmutablePdbExpdtaLine.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePdbExpdtaLine ImmutablePdbExpdtaLine}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PdbExpdtaLine", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<ExperimentalTechnique> experimentalTechniques = new ArrayList<ExperimentalTechnique>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PdbExpdtaLine} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PdbExpdtaLine instance) {
      Objects.requireNonNull(instance, "instance");
      addAllExperimentalTechniques(instance.experimentalTechniques());
      return this;
    }

    /**
     * Adds one element to {@link PdbExpdtaLine#experimentalTechniques() experimentalTechniques} list.
     * @param element A experimentalTechniques element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addExperimentalTechniques(ExperimentalTechnique element) {
      this.experimentalTechniques.add(Objects.requireNonNull(element, "experimentalTechniques element"));
      return this;
    }

    /**
     * Adds elements to {@link PdbExpdtaLine#experimentalTechniques() experimentalTechniques} list.
     * @param elements An array of experimentalTechniques elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addExperimentalTechniques(ExperimentalTechnique... elements) {
      for (ExperimentalTechnique element : elements) {
        this.experimentalTechniques.add(Objects.requireNonNull(element, "experimentalTechniques element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PdbExpdtaLine#experimentalTechniques() experimentalTechniques} list.
     * @param elements An iterable of experimentalTechniques elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder experimentalTechniques(Iterable<? extends ExperimentalTechnique> elements) {
      this.experimentalTechniques.clear();
      return addAllExperimentalTechniques(elements);
    }

    /**
     * Adds elements to {@link PdbExpdtaLine#experimentalTechniques() experimentalTechniques} list.
     * @param elements An iterable of experimentalTechniques elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllExperimentalTechniques(Iterable<? extends ExperimentalTechnique> elements) {
      for (ExperimentalTechnique element : elements) {
        this.experimentalTechniques.add(Objects.requireNonNull(element, "experimentalTechniques element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutablePdbExpdtaLine ImmutablePdbExpdtaLine}.
     * @return An immutable instance of PdbExpdtaLine
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePdbExpdtaLine build() {
      return new ImmutablePdbExpdtaLine(null, createUnmodifiableList(true, experimentalTechniques));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
