package pl.poznan.put.external.dssr;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Pair}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePair.builder()}.
 */
@Generated(from = "Pair", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutablePair implements Pair {
  private final String nt1;
  private final String nt2;
  private final String saenger;
  private final String lw;

  private ImmutablePair(String nt1, String nt2, String saenger, String lw) {
    this.nt1 = nt1;
    this.nt2 = nt2;
    this.saenger = saenger;
    this.lw = lw;
  }

  /**
   * @return The value of the {@code nt1} attribute
   */
  @JsonProperty("nt1")
  @Override
  public String nt1() {
    return nt1;
  }

  /**
   * @return The value of the {@code nt2} attribute
   */
  @JsonProperty("nt2")
  @Override
  public String nt2() {
    return nt2;
  }

  /**
   * @return The value of the {@code saenger} attribute
   */
  @JsonProperty("Saenger")
  @Override
  public String saenger() {
    return saenger;
  }

  /**
   * @return The value of the {@code lw} attribute
   */
  @JsonProperty("LW")
  @Override
  public String lw() {
    return lw;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Pair#nt1() nt1} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nt1
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePair withNt1(String value) {
    String newValue = Objects.requireNonNull(value, "nt1");
    if (this.nt1.equals(newValue)) return this;
    return new ImmutablePair(newValue, this.nt2, this.saenger, this.lw);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Pair#nt2() nt2} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nt2
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePair withNt2(String value) {
    String newValue = Objects.requireNonNull(value, "nt2");
    if (this.nt2.equals(newValue)) return this;
    return new ImmutablePair(this.nt1, newValue, this.saenger, this.lw);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Pair#saenger() saenger} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for saenger
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePair withSaenger(String value) {
    String newValue = Objects.requireNonNull(value, "saenger");
    if (this.saenger.equals(newValue)) return this;
    return new ImmutablePair(this.nt1, this.nt2, newValue, this.lw);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Pair#lw() lw} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lw
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePair withLw(String value) {
    String newValue = Objects.requireNonNull(value, "lw");
    if (this.lw.equals(newValue)) return this;
    return new ImmutablePair(this.nt1, this.nt2, this.saenger, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePair} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePair
        && equalTo((ImmutablePair) another);
  }

  private boolean equalTo(ImmutablePair another) {
    return nt1.equals(another.nt1)
        && nt2.equals(another.nt2)
        && saenger.equals(another.saenger)
        && lw.equals(another.lw);
  }

  /**
   * Computes a hash code from attributes: {@code nt1}, {@code nt2}, {@code saenger}, {@code lw}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + nt1.hashCode();
    h += (h << 5) + nt2.hashCode();
    h += (h << 5) + saenger.hashCode();
    h += (h << 5) + lw.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Pair} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Pair{"
        + "nt1=" + nt1
        + ", nt2=" + nt2
        + ", saenger=" + saenger
        + ", lw=" + lw
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Pair", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Pair {
    @Nullable String nt1;
    @Nullable String nt2;
    @Nullable String saenger;
    @Nullable String lw;
    @JsonProperty("nt1")
    public void setNt1(String nt1) {
      this.nt1 = nt1;
    }
    @JsonProperty("nt2")
    public void setNt2(String nt2) {
      this.nt2 = nt2;
    }
    @JsonProperty("Saenger")
    public void setSaenger(String saenger) {
      this.saenger = saenger;
    }
    @JsonProperty("LW")
    public void setLw(String lw) {
      this.lw = lw;
    }
    @Override
    public String nt1() { throw new UnsupportedOperationException(); }
    @Override
    public String nt2() { throw new UnsupportedOperationException(); }
    @Override
    public String saenger() { throw new UnsupportedOperationException(); }
    @Override
    public String lw() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePair fromJson(Json json) {
    ImmutablePair.Builder builder = ImmutablePair.builder();
    if (json.nt1 != null) {
      builder.nt1(json.nt1);
    }
    if (json.nt2 != null) {
      builder.nt2(json.nt2);
    }
    if (json.saenger != null) {
      builder.saenger(json.saenger);
    }
    if (json.lw != null) {
      builder.lw(json.lw);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Pair} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Pair instance
   */
  public static ImmutablePair copyOf(Pair instance) {
    if (instance instanceof ImmutablePair) {
      return (ImmutablePair) instance;
    }
    return ImmutablePair.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePair ImmutablePair}.
   * <pre>
   * ImmutablePair.builder()
   *    .nt1(String) // required {@link Pair#nt1() nt1}
   *    .nt2(String) // required {@link Pair#nt2() nt2}
   *    .saenger(String) // required {@link Pair#saenger() saenger}
   *    .lw(String) // required {@link Pair#lw() lw}
   *    .build();
   * </pre>
   * @return A new ImmutablePair builder
   */
  public static ImmutablePair.Builder builder() {
    return new ImmutablePair.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePair ImmutablePair}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Pair", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NT1 = 0x1L;
    private static final long INIT_BIT_NT2 = 0x2L;
    private static final long INIT_BIT_SAENGER = 0x4L;
    private static final long INIT_BIT_LW = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String nt1;
    private @Nullable String nt2;
    private @Nullable String saenger;
    private @Nullable String lw;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Pair} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Pair instance) {
      Objects.requireNonNull(instance, "instance");
      nt1(instance.nt1());
      nt2(instance.nt2());
      saenger(instance.saenger());
      lw(instance.lw());
      return this;
    }

    /**
     * Initializes the value for the {@link Pair#nt1() nt1} attribute.
     * @param nt1 The value for nt1 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("nt1")
    public final Builder nt1(String nt1) {
      this.nt1 = Objects.requireNonNull(nt1, "nt1");
      initBits &= ~INIT_BIT_NT1;
      return this;
    }

    /**
     * Initializes the value for the {@link Pair#nt2() nt2} attribute.
     * @param nt2 The value for nt2 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("nt2")
    public final Builder nt2(String nt2) {
      this.nt2 = Objects.requireNonNull(nt2, "nt2");
      initBits &= ~INIT_BIT_NT2;
      return this;
    }

    /**
     * Initializes the value for the {@link Pair#saenger() saenger} attribute.
     * @param saenger The value for saenger 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Saenger")
    public final Builder saenger(String saenger) {
      this.saenger = Objects.requireNonNull(saenger, "saenger");
      initBits &= ~INIT_BIT_SAENGER;
      return this;
    }

    /**
     * Initializes the value for the {@link Pair#lw() lw} attribute.
     * @param lw The value for lw 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("LW")
    public final Builder lw(String lw) {
      this.lw = Objects.requireNonNull(lw, "lw");
      initBits &= ~INIT_BIT_LW;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePair ImmutablePair}.
     * @return An immutable instance of Pair
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePair build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePair(nt1, nt2, saenger, lw);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NT1) != 0) attributes.add("nt1");
      if ((initBits & INIT_BIT_NT2) != 0) attributes.add("nt2");
      if ((initBits & INIT_BIT_SAENGER) != 0) attributes.add("saenger");
      if ((initBits & INIT_BIT_LW) != 0) attributes.add("lw");
      return "Cannot build Pair, some of required attributes are not set " + attributes;
    }
  }
}
