package pl.poznan.put.external.dssr;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Nucleotide}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNucleotide.builder()}.
 */
@Generated(from = "Nucleotide", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableNucleotide implements Nucleotide {
  private final String id;
  private final String chainName;
  private final String oneLetterName;
  private final int residueNumber;

  private ImmutableNucleotide(String id, String chainName, String oneLetterName, int residueNumber) {
    this.id = id;
    this.chainName = chainName;
    this.oneLetterName = oneLetterName;
    this.residueNumber = residueNumber;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("nt_id")
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code chainName} attribute
   */
  @JsonProperty("chain_name")
  @Override
  public String chainName() {
    return chainName;
  }

  /**
   * @return The value of the {@code oneLetterName} attribute
   */
  @JsonProperty("nt_code")
  @Override
  public String oneLetterName() {
    return oneLetterName;
  }

  /**
   * @return The value of the {@code residueNumber} attribute
   */
  @JsonProperty("nt_resnum")
  @Override
  public int residueNumber() {
    return residueNumber;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Nucleotide#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNucleotide withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableNucleotide(newValue, this.chainName, this.oneLetterName, this.residueNumber);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Nucleotide#chainName() chainName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for chainName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNucleotide withChainName(String value) {
    String newValue = Objects.requireNonNull(value, "chainName");
    if (this.chainName.equals(newValue)) return this;
    return new ImmutableNucleotide(this.id, newValue, this.oneLetterName, this.residueNumber);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Nucleotide#oneLetterName() oneLetterName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for oneLetterName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNucleotide withOneLetterName(String value) {
    String newValue = Objects.requireNonNull(value, "oneLetterName");
    if (this.oneLetterName.equals(newValue)) return this;
    return new ImmutableNucleotide(this.id, this.chainName, newValue, this.residueNumber);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Nucleotide#residueNumber() residueNumber} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for residueNumber
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNucleotide withResidueNumber(int value) {
    if (this.residueNumber == value) return this;
    return new ImmutableNucleotide(this.id, this.chainName, this.oneLetterName, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNucleotide} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNucleotide
        && equalTo((ImmutableNucleotide) another);
  }

  private boolean equalTo(ImmutableNucleotide another) {
    return id.equals(another.id)
        && chainName.equals(another.chainName)
        && oneLetterName.equals(another.oneLetterName)
        && residueNumber == another.residueNumber;
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code chainName}, {@code oneLetterName}, {@code residueNumber}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + chainName.hashCode();
    h += (h << 5) + oneLetterName.hashCode();
    h += (h << 5) + residueNumber;
    return h;
  }

  /**
   * Prints the immutable value {@code Nucleotide} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Nucleotide{"
        + "id=" + id
        + ", chainName=" + chainName
        + ", oneLetterName=" + oneLetterName
        + ", residueNumber=" + residueNumber
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Nucleotide", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Nucleotide {
    @Nullable String id;
    @Nullable String chainName;
    @Nullable String oneLetterName;
    int residueNumber;
    boolean residueNumberIsSet;
    @JsonProperty("nt_id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("chain_name")
    public void setChainName(String chainName) {
      this.chainName = chainName;
    }
    @JsonProperty("nt_code")
    public void setOneLetterName(String oneLetterName) {
      this.oneLetterName = oneLetterName;
    }
    @JsonProperty("nt_resnum")
    public void setResidueNumber(int residueNumber) {
      this.residueNumber = residueNumber;
      this.residueNumberIsSet = true;
    }
    @Override
    public String id() { throw new UnsupportedOperationException(); }
    @Override
    public String chainName() { throw new UnsupportedOperationException(); }
    @Override
    public String oneLetterName() { throw new UnsupportedOperationException(); }
    @Override
    public int residueNumber() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableNucleotide fromJson(Json json) {
    ImmutableNucleotide.Builder builder = ImmutableNucleotide.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.chainName != null) {
      builder.chainName(json.chainName);
    }
    if (json.oneLetterName != null) {
      builder.oneLetterName(json.oneLetterName);
    }
    if (json.residueNumberIsSet) {
      builder.residueNumber(json.residueNumber);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Nucleotide} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Nucleotide instance
   */
  public static ImmutableNucleotide copyOf(Nucleotide instance) {
    if (instance instanceof ImmutableNucleotide) {
      return (ImmutableNucleotide) instance;
    }
    return ImmutableNucleotide.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNucleotide ImmutableNucleotide}.
   * <pre>
   * ImmutableNucleotide.builder()
   *    .id(String) // required {@link Nucleotide#id() id}
   *    .chainName(String) // required {@link Nucleotide#chainName() chainName}
   *    .oneLetterName(String) // required {@link Nucleotide#oneLetterName() oneLetterName}
   *    .residueNumber(int) // required {@link Nucleotide#residueNumber() residueNumber}
   *    .build();
   * </pre>
   * @return A new ImmutableNucleotide builder
   */
  public static ImmutableNucleotide.Builder builder() {
    return new ImmutableNucleotide.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNucleotide ImmutableNucleotide}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Nucleotide", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_CHAIN_NAME = 0x2L;
    private static final long INIT_BIT_ONE_LETTER_NAME = 0x4L;
    private static final long INIT_BIT_RESIDUE_NUMBER = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String id;
    private @Nullable String chainName;
    private @Nullable String oneLetterName;
    private int residueNumber;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Nucleotide} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Nucleotide instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      chainName(instance.chainName());
      oneLetterName(instance.oneLetterName());
      residueNumber(instance.residueNumber());
      return this;
    }

    /**
     * Initializes the value for the {@link Nucleotide#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("nt_id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Nucleotide#chainName() chainName} attribute.
     * @param chainName The value for chainName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("chain_name")
    public final Builder chainName(String chainName) {
      this.chainName = Objects.requireNonNull(chainName, "chainName");
      initBits &= ~INIT_BIT_CHAIN_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Nucleotide#oneLetterName() oneLetterName} attribute.
     * @param oneLetterName The value for oneLetterName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("nt_code")
    public final Builder oneLetterName(String oneLetterName) {
      this.oneLetterName = Objects.requireNonNull(oneLetterName, "oneLetterName");
      initBits &= ~INIT_BIT_ONE_LETTER_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Nucleotide#residueNumber() residueNumber} attribute.
     * @param residueNumber The value for residueNumber 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("nt_resnum")
    public final Builder residueNumber(int residueNumber) {
      this.residueNumber = residueNumber;
      initBits &= ~INIT_BIT_RESIDUE_NUMBER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNucleotide ImmutableNucleotide}.
     * @return An immutable instance of Nucleotide
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNucleotide build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNucleotide(id, chainName, oneLetterName, residueNumber);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_CHAIN_NAME) != 0) attributes.add("chainName");
      if ((initBits & INIT_BIT_ONE_LETTER_NAME) != 0) attributes.add("oneLetterName");
      if ((initBits & INIT_BIT_RESIDUE_NUMBER) != 0) attributes.add("residueNumber");
      return "Cannot build Nucleotide, some of required attributes are not set " + attributes;
    }
  }
}
