package pl.poznan.put.external.dssr;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DssrJson}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDssrJson.builder()}.
 */
@Generated(from = "DssrJson", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableDssrJson extends DssrJson {
  private final List<Pair> pairs;
  private final List<Nucleotide> nucleotides;

  private ImmutableDssrJson(
      List<Pair> pairs,
      List<Nucleotide> nucleotides) {
    this.pairs = pairs;
    this.nucleotides = nucleotides;
  }

  /**
   * @return The value of the {@code pairs} attribute
   */
  @JsonProperty("pairs")
  @Override
  public List<Pair> pairs() {
    return pairs;
  }

  /**
   * @return The value of the {@code nucleotides} attribute
   */
  @JsonProperty("nts")
  @Override
  public List<Nucleotide> nucleotides() {
    return nucleotides;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DssrJson#pairs() pairs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDssrJson withPairs(Pair... elements) {
    List<Pair> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableDssrJson(newValue, this.nucleotides);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DssrJson#pairs() pairs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of pairs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDssrJson withPairs(Iterable<? extends Pair> elements) {
    if (this.pairs == elements) return this;
    List<Pair> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableDssrJson(newValue, this.nucleotides);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DssrJson#nucleotides() nucleotides}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDssrJson withNucleotides(Nucleotide... elements) {
    List<Nucleotide> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableDssrJson(this.pairs, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DssrJson#nucleotides() nucleotides}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of nucleotides elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDssrJson withNucleotides(Iterable<? extends Nucleotide> elements) {
    if (this.nucleotides == elements) return this;
    List<Nucleotide> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableDssrJson(this.pairs, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDssrJson} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDssrJson
        && equalTo((ImmutableDssrJson) another);
  }

  private boolean equalTo(ImmutableDssrJson another) {
    return pairs.equals(another.pairs)
        && nucleotides.equals(another.nucleotides);
  }

  /**
   * Computes a hash code from attributes: {@code pairs}, {@code nucleotides}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + pairs.hashCode();
    h += (h << 5) + nucleotides.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DssrJson} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DssrJson{"
        + "pairs=" + pairs
        + ", nucleotides=" + nucleotides
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DssrJson", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends DssrJson {
    @Nullable List<Pair> pairs = Collections.emptyList();
    @Nullable List<Nucleotide> nucleotides = Collections.emptyList();
    @JsonProperty("pairs")
    public void setPairs(List<Pair> pairs) {
      this.pairs = pairs;
    }
    @JsonProperty("nts")
    public void setNucleotides(List<Nucleotide> nucleotides) {
      this.nucleotides = nucleotides;
    }
    @Override
    public List<Pair> pairs() { throw new UnsupportedOperationException(); }
    @Override
    public List<Nucleotide> nucleotides() { throw new UnsupportedOperationException(); }
    @Override
    protected Map<String, Nucleotide> idNucleotideMap() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDssrJson fromJson(Json json) {
    ImmutableDssrJson.Builder builder = ImmutableDssrJson.builder();
    if (json.pairs != null) {
      builder.addAllPairs(json.pairs);
    }
    if (json.nucleotides != null) {
      builder.addAllNucleotides(json.nucleotides);
    }
    return builder.build();
  }

  private transient volatile long lazyInitBitmap;

  private static final long ID_NUCLEOTIDE_MAP_LAZY_INIT_BIT = 0x1L;

  private transient Map<String, Nucleotide> idNucleotideMap;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link DssrJson#idNucleotideMap() idNucleotideMap} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code idNucleotideMap} attribute
   */
  @Override
  protected Map<String, Nucleotide> idNucleotideMap() {
    if ((lazyInitBitmap & ID_NUCLEOTIDE_MAP_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & ID_NUCLEOTIDE_MAP_LAZY_INIT_BIT) == 0) {
          this.idNucleotideMap = Objects.requireNonNull(super.idNucleotideMap(), "idNucleotideMap");
          lazyInitBitmap |= ID_NUCLEOTIDE_MAP_LAZY_INIT_BIT;
        }
      }
    }
    return idNucleotideMap;
  }

  /**
   * Creates an immutable copy of a {@link DssrJson} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DssrJson instance
   */
  public static ImmutableDssrJson copyOf(DssrJson instance) {
    if (instance instanceof ImmutableDssrJson) {
      return (ImmutableDssrJson) instance;
    }
    return ImmutableDssrJson.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDssrJson ImmutableDssrJson}.
   * <pre>
   * ImmutableDssrJson.builder()
   *    .addPairs|addAllPairs(pl.poznan.put.external.dssr.Pair) // {@link DssrJson#pairs() pairs} elements
   *    .addNucleotides|addAllNucleotides(pl.poznan.put.external.dssr.Nucleotide) // {@link DssrJson#nucleotides() nucleotides} elements
   *    .build();
   * </pre>
   * @return A new ImmutableDssrJson builder
   */
  public static ImmutableDssrJson.Builder builder() {
    return new ImmutableDssrJson.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDssrJson ImmutableDssrJson}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DssrJson", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<Pair> pairs = new ArrayList<Pair>();
    private List<Nucleotide> nucleotides = new ArrayList<Nucleotide>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DssrJson} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DssrJson instance) {
      Objects.requireNonNull(instance, "instance");
      addAllPairs(instance.pairs());
      addAllNucleotides(instance.nucleotides());
      return this;
    }

    /**
     * Adds one element to {@link DssrJson#pairs() pairs} list.
     * @param element A pairs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPairs(Pair element) {
      this.pairs.add(Objects.requireNonNull(element, "pairs element"));
      return this;
    }

    /**
     * Adds elements to {@link DssrJson#pairs() pairs} list.
     * @param elements An array of pairs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPairs(Pair... elements) {
      for (Pair element : elements) {
        this.pairs.add(Objects.requireNonNull(element, "pairs element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DssrJson#pairs() pairs} list.
     * @param elements An iterable of pairs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("pairs")
    public final Builder pairs(Iterable<? extends Pair> elements) {
      this.pairs.clear();
      return addAllPairs(elements);
    }

    /**
     * Adds elements to {@link DssrJson#pairs() pairs} list.
     * @param elements An iterable of pairs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPairs(Iterable<? extends Pair> elements) {
      for (Pair element : elements) {
        this.pairs.add(Objects.requireNonNull(element, "pairs element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link DssrJson#nucleotides() nucleotides} list.
     * @param element A nucleotides element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addNucleotides(Nucleotide element) {
      this.nucleotides.add(Objects.requireNonNull(element, "nucleotides element"));
      return this;
    }

    /**
     * Adds elements to {@link DssrJson#nucleotides() nucleotides} list.
     * @param elements An array of nucleotides elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addNucleotides(Nucleotide... elements) {
      for (Nucleotide element : elements) {
        this.nucleotides.add(Objects.requireNonNull(element, "nucleotides element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DssrJson#nucleotides() nucleotides} list.
     * @param elements An iterable of nucleotides elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("nts")
    public final Builder nucleotides(Iterable<? extends Nucleotide> elements) {
      this.nucleotides.clear();
      return addAllNucleotides(elements);
    }

    /**
     * Adds elements to {@link DssrJson#nucleotides() nucleotides} list.
     * @param elements An iterable of nucleotides elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNucleotides(Iterable<? extends Nucleotide> elements) {
      for (Nucleotide element : elements) {
        this.nucleotides.add(Objects.requireNonNull(element, "nucleotides element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableDssrJson ImmutableDssrJson}.
     * @return An immutable instance of DssrJson
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDssrJson build() {
      return new ImmutableDssrJson(createUnmodifiableList(true, pairs), createUnmodifiableList(true, nucleotides));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
