package pl.poznan.put.constant;

/** A set of useful constants in structural bioinformatics e.g. greek letters, Angstrom, etc. */
public final class Unicode {
  public static final String ALPHA = "α";
  public static final String BETA = "β";
  public static final String GAMMA = "γ";
  public static final String DELTA = "δ";
  public static final String EPSILON = "ε";
  public static final String ZETA = "ζ";
  public static final String CHI = "χ";
  public static final String TAU = "τ";
  public static final String NU0 = "ν0";
  public static final String NU1 = "ν1";
  public static final String NU2 = "ν2";
  public static final String NU3 = "ν3";
  public static final String NU4 = "ν4";
  public static final String ETA = "η";
  public static final String ETA_PRIM = "η'";
  public static final String THETA = "θ";
  public static final String THETA_PRIM = "θ'";
  public static final String PHI = "ϕ";
  public static final String PSI = "ψ";
  public static final String OMEGA = "ω";
  public static final String CHI1 = "χ1";
  public static final String CHI2 = "χ2";
  public static final String CHI3 = "χ3";
  public static final String CHI4 = "χ4";
  public static final String CHI5 = "χ5";
  public static final String CALPHA = "Cα";
  public static final String DEGREE = "°";
  public static final String ANGSTROM = "Å";
  public static final String PI = "π";
  public static final String INFINITY = "∞";

  private Unicode() {
    super();
  }
}
