package pl.poznan.put.circular.samples;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.circular.Angle;

/**
 * Immutable implementation of {@link TrigonometricMoment}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTrigonometricMoment.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableTrigonometricMoment.of()}.
 */
@Generated(from = "TrigonometricMoment", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableTrigonometricMoment extends TrigonometricMoment {
  private final Angle meanDirection;
  private final double meanResultantLength;

  private ImmutableTrigonometricMoment(Angle meanDirection, double meanResultantLength) {
    this.meanDirection = Objects.requireNonNull(meanDirection, "meanDirection");
    this.meanResultantLength = meanResultantLength;
  }

  private ImmutableTrigonometricMoment(
      ImmutableTrigonometricMoment original,
      Angle meanDirection,
      double meanResultantLength) {
    this.meanDirection = meanDirection;
    this.meanResultantLength = meanResultantLength;
  }

  /**
   *@return The mean direction. 
   */
  @Override
  public Angle meanDirection() {
    return meanDirection;
  }

  /**
   *@return The length of the vector representing the mean direction. 
   */
  @Override
  public double meanResultantLength() {
    return meanResultantLength;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TrigonometricMoment#meanDirection() meanDirection} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for meanDirection
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTrigonometricMoment withMeanDirection(Angle value) {
    if (this.meanDirection == value) return this;
    Angle newValue = Objects.requireNonNull(value, "meanDirection");
    return new ImmutableTrigonometricMoment(this, newValue, this.meanResultantLength);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TrigonometricMoment#meanResultantLength() meanResultantLength} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for meanResultantLength
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTrigonometricMoment withMeanResultantLength(double value) {
    if (Double.doubleToLongBits(this.meanResultantLength) == Double.doubleToLongBits(value)) return this;
    return new ImmutableTrigonometricMoment(this, this.meanDirection, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTrigonometricMoment} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTrigonometricMoment
        && equalTo((ImmutableTrigonometricMoment) another);
  }

  private boolean equalTo(ImmutableTrigonometricMoment another) {
    return meanDirection.equals(another.meanDirection)
        && Double.doubleToLongBits(meanResultantLength) == Double.doubleToLongBits(another.meanResultantLength);
  }

  /**
   * Computes a hash code from attributes: {@code meanDirection}, {@code meanResultantLength}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + meanDirection.hashCode();
    h += (h << 5) + Double.hashCode(meanResultantLength);
    return h;
  }

  /**
   * Prints the immutable value {@code TrigonometricMoment} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TrigonometricMoment{"
        + "meanDirection=" + meanDirection
        + ", meanResultantLength=" + meanResultantLength
        + "}";
  }

  /**
   * Construct a new immutable {@code TrigonometricMoment} instance.
   * @param meanDirection The value for the {@code meanDirection} attribute
   * @param meanResultantLength The value for the {@code meanResultantLength} attribute
   * @return An immutable TrigonometricMoment instance
   */
  public static ImmutableTrigonometricMoment of(Angle meanDirection, double meanResultantLength) {
    return new ImmutableTrigonometricMoment(meanDirection, meanResultantLength);
  }

  /**
   * Creates an immutable copy of a {@link TrigonometricMoment} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TrigonometricMoment instance
   */
  public static ImmutableTrigonometricMoment copyOf(TrigonometricMoment instance) {
    if (instance instanceof ImmutableTrigonometricMoment) {
      return (ImmutableTrigonometricMoment) instance;
    }
    return ImmutableTrigonometricMoment.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTrigonometricMoment ImmutableTrigonometricMoment}.
   * <pre>
   * ImmutableTrigonometricMoment.builder()
   *    .meanDirection(pl.poznan.put.circular.Angle) // required {@link TrigonometricMoment#meanDirection() meanDirection}
   *    .meanResultantLength(double) // required {@link TrigonometricMoment#meanResultantLength() meanResultantLength}
   *    .build();
   * </pre>
   * @return A new ImmutableTrigonometricMoment builder
   */
  public static ImmutableTrigonometricMoment.Builder builder() {
    return new ImmutableTrigonometricMoment.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTrigonometricMoment ImmutableTrigonometricMoment}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TrigonometricMoment", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_MEAN_DIRECTION = 0x1L;
    private static final long INIT_BIT_MEAN_RESULTANT_LENGTH = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Angle meanDirection;
    private double meanResultantLength;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TrigonometricMoment} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TrigonometricMoment instance) {
      Objects.requireNonNull(instance, "instance");
      meanDirection(instance.meanDirection());
      meanResultantLength(instance.meanResultantLength());
      return this;
    }

    /**
     * Initializes the value for the {@link TrigonometricMoment#meanDirection() meanDirection} attribute.
     * @param meanDirection The value for meanDirection 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder meanDirection(Angle meanDirection) {
      this.meanDirection = Objects.requireNonNull(meanDirection, "meanDirection");
      initBits &= ~INIT_BIT_MEAN_DIRECTION;
      return this;
    }

    /**
     * Initializes the value for the {@link TrigonometricMoment#meanResultantLength() meanResultantLength} attribute.
     * @param meanResultantLength The value for meanResultantLength 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder meanResultantLength(double meanResultantLength) {
      this.meanResultantLength = meanResultantLength;
      initBits &= ~INIT_BIT_MEAN_RESULTANT_LENGTH;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTrigonometricMoment ImmutableTrigonometricMoment}.
     * @return An immutable instance of TrigonometricMoment
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTrigonometricMoment build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTrigonometricMoment(null, meanDirection, meanResultantLength);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MEAN_DIRECTION) != 0) attributes.add("meanDirection");
      if ((initBits & INIT_BIT_MEAN_RESULTANT_LENGTH) != 0) attributes.add("meanResultantLength");
      return "Cannot build TrigonometricMoment, some of required attributes are not set " + attributes;
    }
  }
}
