package pl.poznan.put.circular.samples;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.tuple.Pair;
import org.immutables.value.Generated;
import pl.poznan.put.circular.Angle;

/**
 * Immutable implementation of {@link AngleSample}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAngleSample.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableAngleSample.of()}.
 */
@Generated(from = "AngleSample", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableAngleSample extends AngleSample {
  private final Collection<Angle> data;

  private ImmutableAngleSample(Collection<Angle> data) {
    this.data = Objects.requireNonNull(data, "data");
  }

  private ImmutableAngleSample(ImmutableAngleSample original, Collection<Angle> data) {
    this.data = data;
  }

  /**
   *@return The collection of values in the sample. 
   */
  @Override
  public Collection<Angle> data() {
    return data;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AngleSample#data() data} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for data
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAngleSample withData(Collection<Angle> value) {
    if (this.data == value) return this;
    Collection<Angle> newValue = Objects.requireNonNull(value, "data");
    return validate(new ImmutableAngleSample(this, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAngleSample} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAngleSample
        && equalTo((ImmutableAngleSample) another);
  }

  private boolean equalTo(ImmutableAngleSample another) {
    return data.equals(another.data);
  }

  /**
   * Computes a hash code from attributes: {@code data}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + data.hashCode();
    return h;
  }

  private transient volatile long lazyInitBitmap;

  private static final long MEAN_DIRECTION_LAZY_INIT_BIT = 0x1L;

  private transient Angle meanDirection;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AngleSample#meanDirection() meanDirection} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code meanDirection} attribute
   */
  @Override
  public Angle meanDirection() {
    if ((lazyInitBitmap & MEAN_DIRECTION_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & MEAN_DIRECTION_LAZY_INIT_BIT) == 0) {
          this.meanDirection = Objects.requireNonNull(super.meanDirection(), "meanDirection");
          lazyInitBitmap |= MEAN_DIRECTION_LAZY_INIT_BIT;
        }
      }
    }
    return meanDirection;
  }

  private static final long MEAN_RESULTANT_LENGTH_LAZY_INIT_BIT = 0x2L;

  private transient double meanResultantLength;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AngleSample#meanResultantLength() meanResultantLength} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code meanResultantLength} attribute
   */
  @Override
  public double meanResultantLength() {
    if ((lazyInitBitmap & MEAN_RESULTANT_LENGTH_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & MEAN_RESULTANT_LENGTH_LAZY_INIT_BIT) == 0) {
          this.meanResultantLength = super.meanResultantLength();
          lazyInitBitmap |= MEAN_RESULTANT_LENGTH_LAZY_INIT_BIT;
        }
      }
    }
    return meanResultantLength;
  }

  private static final long CIRCULAR_VARIANCE_LAZY_INIT_BIT = 0x4L;

  private transient double circularVariance;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AngleSample#circularVariance() circularVariance} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code circularVariance} attribute
   */
  @Override
  public double circularVariance() {
    if ((lazyInitBitmap & CIRCULAR_VARIANCE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CIRCULAR_VARIANCE_LAZY_INIT_BIT) == 0) {
          this.circularVariance = super.circularVariance();
          lazyInitBitmap |= CIRCULAR_VARIANCE_LAZY_INIT_BIT;
        }
      }
    }
    return circularVariance;
  }

  private static final long CIRCULAR_STANDARD_DEVIATION_LAZY_INIT_BIT = 0x8L;

  private transient double circularStandardDeviation;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AngleSample#circularStandardDeviation() circularStandardDeviation} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code circularStandardDeviation} attribute
   */
  @Override
  public double circularStandardDeviation() {
    if ((lazyInitBitmap & CIRCULAR_STANDARD_DEVIATION_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CIRCULAR_STANDARD_DEVIATION_LAZY_INIT_BIT) == 0) {
          this.circularStandardDeviation = super.circularStandardDeviation();
          lazyInitBitmap |= CIRCULAR_STANDARD_DEVIATION_LAZY_INIT_BIT;
        }
      }
    }
    return circularStandardDeviation;
  }

  private static final long CIRCULAR_DISPERSION_LAZY_INIT_BIT = 0x10L;

  private transient double circularDispersion;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AngleSample#circularDispersion() circularDispersion} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code circularDispersion} attribute
   */
  @Override
  public double circularDispersion() {
    if ((lazyInitBitmap & CIRCULAR_DISPERSION_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CIRCULAR_DISPERSION_LAZY_INIT_BIT) == 0) {
          this.circularDispersion = super.circularDispersion();
          lazyInitBitmap |= CIRCULAR_DISPERSION_LAZY_INIT_BIT;
        }
      }
    }
    return circularDispersion;
  }

  private static final long SKEWNESS_LAZY_INIT_BIT = 0x20L;

  private transient double skewness;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AngleSample#skewness() skewness} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code skewness} attribute
   */
  @Override
  public double skewness() {
    if ((lazyInitBitmap & SKEWNESS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SKEWNESS_LAZY_INIT_BIT) == 0) {
          this.skewness = super.skewness();
          lazyInitBitmap |= SKEWNESS_LAZY_INIT_BIT;
        }
      }
    }
    return skewness;
  }

  private static final long KURTOSIS_LAZY_INIT_BIT = 0x40L;

  private transient double kurtosis;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AngleSample#kurtosis() kurtosis} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code kurtosis} attribute
   */
  @Override
  public double kurtosis() {
    if ((lazyInitBitmap & KURTOSIS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & KURTOSIS_LAZY_INIT_BIT) == 0) {
          this.kurtosis = super.kurtosis();
          lazyInitBitmap |= KURTOSIS_LAZY_INIT_BIT;
        }
      }
    }
    return kurtosis;
  }

  private static final long MEDIAN_DIRECTION_LAZY_INIT_BIT = 0x80L;

  private transient Angle medianDirection;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AngleSample#medianDirection() medianDirection} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code medianDirection} attribute
   */
  @Override
  public Angle medianDirection() {
    if ((lazyInitBitmap & MEDIAN_DIRECTION_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & MEDIAN_DIRECTION_LAZY_INIT_BIT) == 0) {
          this.medianDirection = Objects.requireNonNull(super.medianDirection(), "medianDirection");
          lazyInitBitmap |= MEDIAN_DIRECTION_LAZY_INIT_BIT;
        }
      }
    }
    return medianDirection;
  }

  private static final long MEAN_DEVIATION_LAZY_INIT_BIT = 0x100L;

  private transient double meanDeviation;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AngleSample#meanDeviation() meanDeviation} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code meanDeviation} attribute
   */
  @Override
  public double meanDeviation() {
    if ((lazyInitBitmap & MEAN_DEVIATION_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & MEAN_DEVIATION_LAZY_INIT_BIT) == 0) {
          this.meanDeviation = super.meanDeviation();
          lazyInitBitmap |= MEAN_DEVIATION_LAZY_INIT_BIT;
        }
      }
    }
    return meanDeviation;
  }

  private static final long MEDIAN_AND_MEAN_DEVIATION_LAZY_INIT_BIT = 0x200L;

  private transient Pair<Angle, Double> medianAndMeanDeviation;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AngleSample#medianAndMeanDeviation() medianAndMeanDeviation} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code medianAndMeanDeviation} attribute
   */
  @Override
  protected Pair<Angle, Double> medianAndMeanDeviation() {
    if ((lazyInitBitmap & MEDIAN_AND_MEAN_DEVIATION_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & MEDIAN_AND_MEAN_DEVIATION_LAZY_INIT_BIT) == 0) {
          this.medianAndMeanDeviation = Objects.requireNonNull(super.medianAndMeanDeviation(), "medianAndMeanDeviation");
          lazyInitBitmap |= MEDIAN_AND_MEAN_DEVIATION_LAZY_INIT_BIT;
        }
      }
    }
    return medianAndMeanDeviation;
  }

  private static final long SORTED_DATA_LAZY_INIT_BIT = 0x400L;

  private transient List<Angle> sortedData;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AngleSample#sortedData() sortedData} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code sortedData} attribute
   */
  @Override
  protected List<Angle> sortedData() {
    if ((lazyInitBitmap & SORTED_DATA_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SORTED_DATA_LAZY_INIT_BIT) == 0) {
          this.sortedData = Objects.requireNonNull(super.sortedData(), "sortedData");
          lazyInitBitmap |= SORTED_DATA_LAZY_INIT_BIT;
        }
      }
    }
    return sortedData;
  }

  private static final long UM1_LAZY_INIT_BIT = 0x800L;

  private transient TrigonometricMoment um1;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AngleSample#um1() um1} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code um1} attribute
   */
  @Override
  protected TrigonometricMoment um1() {
    if ((lazyInitBitmap & UM1_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & UM1_LAZY_INIT_BIT) == 0) {
          this.um1 = Objects.requireNonNull(super.um1(), "um1");
          lazyInitBitmap |= UM1_LAZY_INIT_BIT;
        }
      }
    }
    return um1;
  }

  private static final long CM2_LAZY_INIT_BIT = 0x1000L;

  private transient TrigonometricMoment cm2;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AngleSample#cm2() cm2} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code cm2} attribute
   */
  @Override
  protected TrigonometricMoment cm2() {
    if ((lazyInitBitmap & CM2_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CM2_LAZY_INIT_BIT) == 0) {
          this.cm2 = Objects.requireNonNull(super.cm2(), "cm2");
          lazyInitBitmap |= CM2_LAZY_INIT_BIT;
        }
      }
    }
    return cm2;
  }

  private static final long UM2_LAZY_INIT_BIT = 0x2000L;

  private transient TrigonometricMoment um2;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AngleSample#um2() um2} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code um2} attribute
   */
  @Override
  protected TrigonometricMoment um2() {
    if ((lazyInitBitmap & UM2_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & UM2_LAZY_INIT_BIT) == 0) {
          this.um2 = Objects.requireNonNull(super.um2(), "um2");
          lazyInitBitmap |= UM2_LAZY_INIT_BIT;
        }
      }
    }
    return um2;
  }

  /**
   * Construct a new immutable {@code AngleSample} instance.
   * @param data The value for the {@code data} attribute
   * @return An immutable AngleSample instance
   */
  public static ImmutableAngleSample of(Collection<Angle> data) {
    return validate(new ImmutableAngleSample(data));
  }

  private static ImmutableAngleSample validate(ImmutableAngleSample instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link AngleSample} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AngleSample instance
   */
  public static ImmutableAngleSample copyOf(AngleSample instance) {
    if (instance instanceof ImmutableAngleSample) {
      return (ImmutableAngleSample) instance;
    }
    return ImmutableAngleSample.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAngleSample ImmutableAngleSample}.
   * <pre>
   * ImmutableAngleSample.builder()
   *    .data(Collection&amp;lt;pl.poznan.put.circular.Angle&amp;gt;) // required {@link AngleSample#data() data}
   *    .build();
   * </pre>
   * @return A new ImmutableAngleSample builder
   */
  public static ImmutableAngleSample.Builder builder() {
    return new ImmutableAngleSample.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAngleSample ImmutableAngleSample}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AngleSample", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DATA = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Collection<Angle> data;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AngleSample} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AngleSample instance) {
      Objects.requireNonNull(instance, "instance");
      data(instance.data());
      return this;
    }

    /**
     * Initializes the value for the {@link AngleSample#data() data} attribute.
     * @param data The value for data 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(Collection<Angle> data) {
      this.data = Objects.requireNonNull(data, "data");
      initBits &= ~INIT_BIT_DATA;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAngleSample ImmutableAngleSample}.
     * @return An immutable instance of AngleSample
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAngleSample build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableAngleSample.validate(new ImmutableAngleSample(null, data));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DATA) != 0) attributes.add("data");
      return "Cannot build AngleSample, some of required attributes are not set " + attributes;
    }
  }
}
