package pl.poznan.put.circular;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Histogram}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHistogram.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableHistogram.of()}.
 */
@Generated(from = "Histogram", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableHistogram extends Histogram {
  private final Collection<Angle> data;
  private final double binWidth;

  private ImmutableHistogram(Collection<Angle> data, double binWidth) {
    this.data = Objects.requireNonNull(data, "data");
    this.binWidth = binWidth;
  }

  private ImmutableHistogram(
      ImmutableHistogram original,
      Collection<Angle> data,
      double binWidth) {
    this.data = data;
    this.binWidth = binWidth;
  }

  /**
   *@return A collection of angular data. 
   */
  @Override
  public Collection<Angle> data() {
    return data;
  }

  /**
   *@return The width of bin in range [0, pi). 
   */
  @Override
  public double binWidth() {
    return binWidth;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Histogram#data() data} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for data
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHistogram withData(Collection<Angle> value) {
    if (this.data == value) return this;
    Collection<Angle> newValue = Objects.requireNonNull(value, "data");
    return validate(new ImmutableHistogram(this, newValue, this.binWidth));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Histogram#binWidth() binWidth} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for binWidth
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHistogram withBinWidth(double value) {
    if (Double.doubleToLongBits(this.binWidth) == Double.doubleToLongBits(value)) return this;
    return validate(new ImmutableHistogram(this, this.data, value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHistogram} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHistogram
        && equalTo((ImmutableHistogram) another);
  }

  private boolean equalTo(ImmutableHistogram another) {
    return data.equals(another.data)
        && Double.doubleToLongBits(binWidth) == Double.doubleToLongBits(another.binWidth);
  }

  /**
   * Computes a hash code from attributes: {@code data}, {@code binWidth}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + data.hashCode();
    h += (h << 5) + Double.hashCode(binWidth);
    return h;
  }

  /**
   * Prints the immutable value {@code Histogram} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Histogram{"
        + "data=" + data
        + ", binWidth=" + binWidth
        + "}";
  }

  private transient volatile long lazyInitBitmap;

  private static final long BINS_LAZY_INIT_BIT = 0x1L;

  private transient Collection<Histogram.Bin> bins;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Histogram#bins() bins} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code bins} attribute
   */
  @Override
  protected Collection<Histogram.Bin> bins() {
    if ((lazyInitBitmap & BINS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & BINS_LAZY_INIT_BIT) == 0) {
          this.bins = Objects.requireNonNull(super.bins(), "bins");
          lazyInitBitmap |= BINS_LAZY_INIT_BIT;
        }
      }
    }
    return bins;
  }

  /**
   * Construct a new immutable {@code Histogram} instance.
   * @param data The value for the {@code data} attribute
   * @param binWidth The value for the {@code binWidth} attribute
   * @return An immutable Histogram instance
   */
  public static ImmutableHistogram of(Collection<Angle> data, double binWidth) {
    return validate(new ImmutableHistogram(data, binWidth));
  }

  private static ImmutableHistogram validate(ImmutableHistogram instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Histogram} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Histogram instance
   */
  public static ImmutableHistogram copyOf(Histogram instance) {
    if (instance instanceof ImmutableHistogram) {
      return (ImmutableHistogram) instance;
    }
    return ImmutableHistogram.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHistogram ImmutableHistogram}.
   * <pre>
   * ImmutableHistogram.builder()
   *    .data(Collection&amp;lt;pl.poznan.put.circular.Angle&amp;gt;) // required {@link Histogram#data() data}
   *    .binWidth(double) // required {@link Histogram#binWidth() binWidth}
   *    .build();
   * </pre>
   * @return A new ImmutableHistogram builder
   */
  public static ImmutableHistogram.Builder builder() {
    return new ImmutableHistogram.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHistogram ImmutableHistogram}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Histogram", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DATA = 0x1L;
    private static final long INIT_BIT_BIN_WIDTH = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Collection<Angle> data;
    private double binWidth;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Histogram} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Histogram instance) {
      Objects.requireNonNull(instance, "instance");
      data(instance.data());
      binWidth(instance.binWidth());
      return this;
    }

    /**
     * Initializes the value for the {@link Histogram#data() data} attribute.
     * @param data The value for data 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(Collection<Angle> data) {
      this.data = Objects.requireNonNull(data, "data");
      initBits &= ~INIT_BIT_DATA;
      return this;
    }

    /**
     * Initializes the value for the {@link Histogram#binWidth() binWidth} attribute.
     * @param binWidth The value for binWidth 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder binWidth(double binWidth) {
      this.binWidth = binWidth;
      initBits &= ~INIT_BIT_BIN_WIDTH;
      return this;
    }

    /**
     * Builds a new {@link ImmutableHistogram ImmutableHistogram}.
     * @return An immutable instance of Histogram
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHistogram build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableHistogram.validate(new ImmutableHistogram(null, data, binWidth));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DATA) != 0) attributes.add("data");
      if ((initBits & INIT_BIT_BIN_WIDTH) != 0) attributes.add("binWidth");
      return "Cannot build Histogram, some of required attributes are not set " + attributes;
    }
  }
}
