package pl.poznan.put.circular;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Histogram.Bin}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBin.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableBin.of()}.
 */
@Generated(from = "Histogram.Bin", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
final class ImmutableBin implements Histogram.Bin {
  private final double radiansStart;
  private final List<Angle> data;

  private ImmutableBin(double radiansStart, Iterable<? extends Angle> data) {
    this.radiansStart = radiansStart;
    this.data = createUnmodifiableList(false, createSafeList(data, true, false));
  }

  private ImmutableBin(ImmutableBin original, double radiansStart, List<Angle> data) {
    this.radiansStart = radiansStart;
    this.data = data;
  }

  /**
   * @return The value of the {@code radiansStart} attribute
   */
  @Override
  public double radiansStart() {
    return radiansStart;
  }

  /**
   * @return The value of the {@code data} attribute
   */
  @Override
  public List<Angle> data() {
    return data;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Histogram.Bin#radiansStart() radiansStart} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for radiansStart
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBin withRadiansStart(double value) {
    if (Double.doubleToLongBits(this.radiansStart) == Double.doubleToLongBits(value)) return this;
    return new ImmutableBin(this, value, this.data);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Histogram.Bin#data() data}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBin withData(Angle... elements) {
    List<Angle> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableBin(this, this.radiansStart, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Histogram.Bin#data() data}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of data elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBin withData(Iterable<? extends Angle> elements) {
    if (this.data == elements) return this;
    List<Angle> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableBin(this, this.radiansStart, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBin} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBin
        && equalTo((ImmutableBin) another);
  }

  private boolean equalTo(ImmutableBin another) {
    return Double.doubleToLongBits(radiansStart) == Double.doubleToLongBits(another.radiansStart)
        && data.equals(another.data);
  }

  /**
   * Computes a hash code from attributes: {@code radiansStart}, {@code data}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Double.hashCode(radiansStart);
    h += (h << 5) + data.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Bin} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Bin{"
        + "radiansStart=" + radiansStart
        + ", data=" + data
        + "}";
  }

  /**
   * Construct a new immutable {@code Bin} instance.
   * @param radiansStart The value for the {@code radiansStart} attribute
   * @param data The value for the {@code data} attribute
   * @return An immutable Bin instance
   */
  public static ImmutableBin of(double radiansStart, List<Angle> data) {
    return of(radiansStart, (Iterable<? extends Angle>) data);
  }

  /**
   * Construct a new immutable {@code Bin} instance.
   * @param radiansStart The value for the {@code radiansStart} attribute
   * @param data The value for the {@code data} attribute
   * @return An immutable Bin instance
   */
  public static ImmutableBin of(double radiansStart, Iterable<? extends Angle> data) {
    return new ImmutableBin(radiansStart, data);
  }

  /**
   * Creates an immutable copy of a {@link Histogram.Bin} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Bin instance
   */
  public static ImmutableBin copyOf(Histogram.Bin instance) {
    if (instance instanceof ImmutableBin) {
      return (ImmutableBin) instance;
    }
    return ImmutableBin.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBin ImmutableBin}.
   * <pre>
   * ImmutableBin.builder()
   *    .radiansStart(double) // required {@link Histogram.Bin#radiansStart() radiansStart}
   *    .addData|addAllData(pl.poznan.put.circular.Angle) // {@link Histogram.Bin#data() data} elements
   *    .build();
   * </pre>
   * @return A new ImmutableBin builder
   */
  public static ImmutableBin.Builder builder() {
    return new ImmutableBin.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBin ImmutableBin}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Histogram.Bin", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_RADIANS_START = 0x1L;
    private long initBits = 0x1L;

    private double radiansStart;
    private List<Angle> data = new ArrayList<Angle>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Bin} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Histogram.Bin instance) {
      Objects.requireNonNull(instance, "instance");
      radiansStart(instance.radiansStart());
      addAllData(instance.data());
      return this;
    }

    /**
     * Initializes the value for the {@link Histogram.Bin#radiansStart() radiansStart} attribute.
     * @param radiansStart The value for radiansStart 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder radiansStart(double radiansStart) {
      this.radiansStart = radiansStart;
      initBits &= ~INIT_BIT_RADIANS_START;
      return this;
    }

    /**
     * Adds one element to {@link Histogram.Bin#data() data} list.
     * @param element A data element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addData(Angle element) {
      this.data.add(Objects.requireNonNull(element, "data element"));
      return this;
    }

    /**
     * Adds elements to {@link Histogram.Bin#data() data} list.
     * @param elements An array of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addData(Angle... elements) {
      for (Angle element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Histogram.Bin#data() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(Iterable<? extends Angle> elements) {
      this.data.clear();
      return addAllData(elements);
    }

    /**
     * Adds elements to {@link Histogram.Bin#data() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllData(Iterable<? extends Angle> elements) {
      for (Angle element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableBin ImmutableBin}.
     * @return An immutable instance of Bin
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBin build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBin(null, radiansStart, createUnmodifiableList(true, data));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RADIANS_START) != 0) attributes.add("radiansStart");
      return "Cannot build Bin, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
