package pl.poznan.put.circular;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Angle}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAngle.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableAngle.of()}.
 */
@Generated(from = "Angle", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableAngle extends Angle {
  private final double radians;

  private ImmutableAngle(double radians) {
    this.radians = radians;
  }

  private ImmutableAngle(ImmutableAngle original, double radians) {
    this.radians = radians;
  }

  /**
   *@return Value in radians in range (-pi; pi]. 
   */
  @Override
  public double radians() {
    return radians;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Angle#radians() radians} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for radians
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAngle withRadians(double value) {
    if (Double.doubleToLongBits(this.radians) == Double.doubleToLongBits(value)) return this;
    return validate(new ImmutableAngle(this, value));
  }

  /**
   * Computes a hash code from attributes: {@code radians}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Double.hashCode(radians);
    return h;
  }

  /**
   * Construct a new immutable {@code Angle} instance.
   * @param radians The value for the {@code radians} attribute
   * @return An immutable Angle instance
   */
  public static ImmutableAngle of(double radians) {
    return validate(new ImmutableAngle(radians));
  }

  private static ImmutableAngle validate(ImmutableAngle instance) {
    instance = (ImmutableAngle) instance.normalize();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Angle} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Angle instance
   */
  public static ImmutableAngle copyOf(Angle instance) {
    if (instance instanceof ImmutableAngle) {
      return (ImmutableAngle) instance;
    }
    return ImmutableAngle.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAngle ImmutableAngle}.
   * <pre>
   * ImmutableAngle.builder()
   *    .radians(double) // required {@link Angle#radians() radians}
   *    .build();
   * </pre>
   * @return A new ImmutableAngle builder
   */
  public static ImmutableAngle.Builder builder() {
    return new ImmutableAngle.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAngle ImmutableAngle}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Angle", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_RADIANS = 0x1L;
    private long initBits = 0x1L;

    private double radians;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Angle} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Angle instance) {
      Objects.requireNonNull(instance, "instance");
      radians(instance.radians());
      return this;
    }

    /**
     * Initializes the value for the {@link Angle#radians() radians} attribute.
     * @param radians The value for radians 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder radians(double radians) {
      this.radians = radians;
      initBits &= ~INIT_BIT_RADIANS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAngle ImmutableAngle}.
     * @return An immutable instance of Angle
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAngle build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableAngle.validate(new ImmutableAngle(null, radians));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RADIANS) != 0) attributes.add("radians");
      return "Cannot build Angle, some of required attributes are not set " + attributes;
    }
  }
}
