package pl.poznan.put.atom;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link BondLength}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBondLength.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableBondLength.of()}.
 */
@Generated(from = "BondLength", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableBondLength implements BondLength {
  private final double min;
  private final double max;
  private final double avg;

  private ImmutableBondLength(double min, double max, double avg) {
    this.min = min;
    this.max = max;
    this.avg = avg;
  }

  private ImmutableBondLength(ImmutableBondLength original, double min, double max, double avg) {
    this.min = min;
    this.max = max;
    this.avg = avg;
  }

  /**
   *@return The minimum length. 
   */
  @Override
  public double min() {
    return min;
  }

  /**
   *@return The maximum length. 
   */
  @Override
  public double max() {
    return max;
  }

  /**
   *@return The average length. 
   */
  @Override
  public double avg() {
    return avg;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BondLength#min() min} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for min
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBondLength withMin(double value) {
    if (Double.doubleToLongBits(this.min) == Double.doubleToLongBits(value)) return this;
    return new ImmutableBondLength(this, value, this.max, this.avg);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BondLength#max() max} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for max
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBondLength withMax(double value) {
    if (Double.doubleToLongBits(this.max) == Double.doubleToLongBits(value)) return this;
    return new ImmutableBondLength(this, this.min, value, this.avg);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BondLength#avg() avg} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for avg
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBondLength withAvg(double value) {
    if (Double.doubleToLongBits(this.avg) == Double.doubleToLongBits(value)) return this;
    return new ImmutableBondLength(this, this.min, this.max, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBondLength} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBondLength
        && equalTo((ImmutableBondLength) another);
  }

  private boolean equalTo(ImmutableBondLength another) {
    return Double.doubleToLongBits(min) == Double.doubleToLongBits(another.min)
        && Double.doubleToLongBits(max) == Double.doubleToLongBits(another.max)
        && Double.doubleToLongBits(avg) == Double.doubleToLongBits(another.avg);
  }

  /**
   * Computes a hash code from attributes: {@code min}, {@code max}, {@code avg}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Double.hashCode(min);
    h += (h << 5) + Double.hashCode(max);
    h += (h << 5) + Double.hashCode(avg);
    return h;
  }

  /**
   * Prints the immutable value {@code BondLength} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BondLength{"
        + "min=" + min
        + ", max=" + max
        + ", avg=" + avg
        + "}";
  }

  /**
   * Construct a new immutable {@code BondLength} instance.
   * @param min The value for the {@code min} attribute
   * @param max The value for the {@code max} attribute
   * @param avg The value for the {@code avg} attribute
   * @return An immutable BondLength instance
   */
  public static ImmutableBondLength of(double min, double max, double avg) {
    return new ImmutableBondLength(min, max, avg);
  }

  /**
   * Creates an immutable copy of a {@link BondLength} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BondLength instance
   */
  public static ImmutableBondLength copyOf(BondLength instance) {
    if (instance instanceof ImmutableBondLength) {
      return (ImmutableBondLength) instance;
    }
    return ImmutableBondLength.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBondLength ImmutableBondLength}.
   * <pre>
   * ImmutableBondLength.builder()
   *    .min(double) // required {@link BondLength#min() min}
   *    .max(double) // required {@link BondLength#max() max}
   *    .avg(double) // required {@link BondLength#avg() avg}
   *    .build();
   * </pre>
   * @return A new ImmutableBondLength builder
   */
  public static ImmutableBondLength.Builder builder() {
    return new ImmutableBondLength.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBondLength ImmutableBondLength}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BondLength", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_MIN = 0x1L;
    private static final long INIT_BIT_MAX = 0x2L;
    private static final long INIT_BIT_AVG = 0x4L;
    private long initBits = 0x7L;

    private double min;
    private double max;
    private double avg;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BondLength} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BondLength instance) {
      Objects.requireNonNull(instance, "instance");
      min(instance.min());
      max(instance.max());
      avg(instance.avg());
      return this;
    }

    /**
     * Initializes the value for the {@link BondLength#min() min} attribute.
     * @param min The value for min 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder min(double min) {
      this.min = min;
      initBits &= ~INIT_BIT_MIN;
      return this;
    }

    /**
     * Initializes the value for the {@link BondLength#max() max} attribute.
     * @param max The value for max 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder max(double max) {
      this.max = max;
      initBits &= ~INIT_BIT_MAX;
      return this;
    }

    /**
     * Initializes the value for the {@link BondLength#avg() avg} attribute.
     * @param avg The value for avg 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder avg(double avg) {
      this.avg = avg;
      initBits &= ~INIT_BIT_AVG;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBondLength ImmutableBondLength}.
     * @return An immutable instance of BondLength
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBondLength build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBondLength(null, min, max, avg);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MIN) != 0) attributes.add("min");
      if ((initBits & INIT_BIT_MAX) != 0) attributes.add("max");
      if ((initBits & INIT_BIT_AVG) != 0) attributes.add("avg");
      return "Cannot build BondLength, some of required attributes are not set " + attributes;
    }
  }
}
