/*
 * Decompiled with CFR 0.152.
 */
package pl.pkk82.dropboxuploader;

import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.users.FullAccount;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;

public class DropboxUploader {
    public static void main(String[] args) throws DbxException, IOException {
        if (args.length < 2) {
            System.err.println("No params, access token needed and file needed");
            System.exit(1);
        }
        String accessToken = args[0];
        Path path = Paths.get(args[1], new String[0]);
        DbxRequestConfig config = new DbxRequestConfig("pkk82-backuper");
        DbxClientV2 client = new DbxClientV2(config, accessToken);
        FullAccount account = client.users().getCurrentAccount();
        System.out.println(account.getName().getDisplayName());
        try (FileInputStream in = new FileInputStream(path.toFile());){
            client.files().uploadBuilder("/" + path.getFileName()).uploadAndFinish((InputStream)in);
        }
    }
}

